/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.modeling;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.modeling.Alias;
import io.fluxcapacitor.javaclient.modeling.AnnotatedEntityHolder;
import io.fluxcapacitor.javaclient.modeling.Entity;
import io.fluxcapacitor.javaclient.modeling.EntityHelper;
import io.fluxcapacitor.javaclient.modeling.Member;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmutableEntity<T>
implements Entity<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImmutableEntity.class);
    @JsonProperty
    private final Object id;
    @JsonProperty
    private final Class<T> type;
    @JsonProperty
    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="type")
    private final T value;
    @JsonProperty
    private final String idProperty;
    private final transient Entity<?> parent;
    private final transient AnnotatedEntityHolder holder;
    private final transient EntityHelper entityHelper;
    private final transient Serializer serializer;
    private final AtomicReference<Object> entities = new AtomicReference();
    private final AtomicReference<Object> aliases = new AtomicReference();

    @Override
    public Class<T> type() {
        T value = this.get();
        return value == null ? this.type : value.getClass();
    }

    @Override
    public Entity<T> withType(Class<T> type) {
        if (!this.type().isAssignableFrom(type)) {
            throw new IllegalArgumentException("Given type is not assignable to entity type");
        }
        return ((ImmutableEntityBuilder)this.toBuilder().type(type)).build();
    }

    @Override
    public T get() {
        return this.value;
    }

    @Override
    public Entity<T> update(UnaryOperator<T> function) {
        Object after = ((ImmutableEntityBuilder)this.toBuilder().value(function.apply(this.get()))).build();
        return this.parent == null ? after : (Entity)this.parent.update(p -> this.holder.updateOwner(p, this, (Entity<?>)after)).getEntity(this.id()).orElse(null);
    }

    @Override
    public Entity<T> apply(Message message) {
        return this.apply(new DeserializingMessage(message, MessageType.EVENT, this.serializer));
    }

    @Override
    public Entity<T> commit() {
        return this;
    }

    @Override
    public <E extends Exception> Entity<T> assertLegal(Object command) throws E {
        this.entityHelper.assertLegal(command, this.root());
        return this;
    }

    @Override
    public Entity<T> apply(DeserializingMessage message) {
        Optional<HandlerInvoker> invoker = this.entityHelper.applyInvoker(message, this);
        if (invoker.isPresent()) {
            return ((ImmutableEntityBuilder)this.toBuilder().value(invoker.get().invoke())).build();
        }
        ImmutableEntity<Object> result = this;
        Object payload = message.getPayload();
        for (Entity<?> entity : result.possibleTargets(payload)) {
            ImmutableEntity immutableEntity = (ImmutableEntity)entity;
            Entity<T> updated = immutableEntity.apply(message);
            if (immutableEntity.get() == updated.get()) continue;
            result = ((ImmutableEntityBuilder)result.toBuilder().value(immutableEntity.holder().updateOwner(result.get(), entity, updated))).build();
        }
        return result;
    }

    protected Collection<? extends ImmutableEntity<?>> computeEntities() {
        Class<T> type = this.type();
        ArrayList result = new ArrayList();
        for (AccessibleObject location : ReflectionUtils.getAnnotatedProperties(type, Member.class)) {
            result.addAll(AnnotatedEntityHolder.getEntityHolder(type, location, this.entityHelper, this.serializer).getEntities(this).toList());
        }
        return result;
    }

    protected Collection<?> computeAliases() {
        T target = this.get();
        if (target == null) {
            return Collections.emptyList();
        }
        ArrayList results = new ArrayList();
        for (AccessibleObject location : ReflectionUtils.getAnnotatedProperties(target.getClass(), Alias.class)) {
            Object v = ReflectionUtils.getValue((AccessibleObject)location, target, (boolean)false);
            if (v == null) continue;
            ReflectionUtils.getAnnotationAs((AnnotatedElement)location, Alias.class, Alias.class).ifPresent((? super T alias) -> {
                UnaryOperator aliasFunction = id -> "".equals(alias.prefix()) && "".equals(alias.postfix()) ? id : alias.prefix() + String.valueOf(id) + alias.postfix();
                if (v instanceof Collection) {
                    Collection collection = (Collection)v;
                    results.addAll(collection.stream().filter(Objects::nonNull).map(aliasFunction).toList());
                } else {
                    results.add(aliasFunction.apply(v));
                }
            });
        }
        return results;
    }

    @Generated
    protected ImmutableEntity(ImmutableEntityBuilder<T, ?, ?> b) {
        this.id = b.id;
        this.type = b.type;
        this.value = b.value;
        this.idProperty = b.idProperty;
        this.parent = b.parent;
        this.holder = b.holder;
        this.entityHelper = b.entityHelper;
        this.serializer = b.serializer;
    }

    @Generated
    public static <T> ImmutableEntityBuilder<T, ?, ?> builder() {
        return new ImmutableEntityBuilderImpl();
    }

    @Generated
    public ImmutableEntityBuilder<T, ?, ?> toBuilder() {
        return new ImmutableEntityBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public Object id() {
        return this.id;
    }

    @Override
    @Generated
    public String idProperty() {
        return this.idProperty;
    }

    @Override
    @Generated
    public Entity<?> parent() {
        return this.parent;
    }

    @Generated
    public AnnotatedEntityHolder holder() {
        return this.holder;
    }

    @Generated
    public EntityHelper entityHelper() {
        return this.entityHelper;
    }

    @Generated
    public Serializer serializer() {
        return this.serializer;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImmutableEntity)) {
            return false;
        }
        ImmutableEntity other = (ImmutableEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Object this$id = this.id();
        Object other$id = other.id();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Class<T> this$type = this.type();
        Class<T> other$type = other.type();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        T this$value = this.value();
        T other$value = other.value();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$idProperty = this.idProperty();
        String other$idProperty = other.idProperty();
        return !(this$idProperty == null ? other$idProperty != null : !this$idProperty.equals(other$idProperty));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ImmutableEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $id = this.id();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Class<T> $type = this.type();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        T $value = this.value();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $idProperty = this.idProperty();
        result = result * 59 + ($idProperty == null ? 43 : $idProperty.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ImmutableEntity(id=" + String.valueOf(this.id()) + ", type=" + String.valueOf(this.type()) + ", idProperty=" + this.idProperty() + ")";
    }

    @Generated
    protected T value() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Generated
    public Collection<? extends Entity<?>> entities() {
        Object $value = this.entities.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.entities;
            synchronized (atomicReference) {
                $value = this.entities.get();
                if ($value == null) {
                    Collection<ImmutableEntity<?>> actualValue = this.computeEntities();
                    $value = actualValue == null ? this.entities : actualValue;
                    this.entities.set($value);
                }
            }
        }
        return (Collection)($value == this.entities ? null : $value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Generated
    public Collection<?> aliases() {
        Object $value = this.aliases.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.aliases;
            synchronized (atomicReference) {
                $value = this.aliases.get();
                if ($value == null) {
                    Collection<?> actualValue = this.computeAliases();
                    $value = actualValue == null ? this.aliases : actualValue;
                    this.aliases.set($value);
                }
            }
        }
        return (Collection)($value == this.aliases ? null : $value);
    }

    @Generated
    public static abstract class ImmutableEntityBuilder<T, C extends ImmutableEntity<T>, B extends ImmutableEntityBuilder<T, C, B>> {
        @Generated
        private Object id;
        @Generated
        private Class<T> type;
        @Generated
        private T value;
        @Generated
        private String idProperty;
        @Generated
        private Entity<?> parent;
        @Generated
        private AnnotatedEntityHolder holder;
        @Generated
        private EntityHelper entityHelper;
        @Generated
        private Serializer serializer;

        @Generated
        protected B $fillValuesFrom(C instance) {
            ImmutableEntityBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static <T> void $fillValuesFromInstanceIntoBuilder(ImmutableEntity<T> instance, ImmutableEntityBuilder<T, ?, ?> b) {
            b.id(instance.id);
            b.type(instance.type);
            b.value(instance.value);
            b.idProperty(instance.idProperty);
            b.parent(instance.parent);
            b.holder(instance.holder);
            b.entityHelper(instance.entityHelper);
            b.serializer(instance.serializer);
        }

        @JsonProperty
        @Generated
        public B id(Object id) {
            this.id = id;
            return this.self();
        }

        @JsonProperty
        @Generated
        public B type(Class<T> type) {
            this.type = type;
            return this.self();
        }

        @JsonProperty
        @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="type")
        @Generated
        public B value(T value) {
            this.value = value;
            return this.self();
        }

        @JsonProperty
        @Generated
        public B idProperty(String idProperty) {
            this.idProperty = idProperty;
            return this.self();
        }

        @Generated
        public B parent(Entity<?> parent) {
            this.parent = parent;
            return this.self();
        }

        @Generated
        public B holder(AnnotatedEntityHolder holder) {
            this.holder = holder;
            return this.self();
        }

        @Generated
        public B entityHelper(EntityHelper entityHelper) {
            this.entityHelper = entityHelper;
            return this.self();
        }

        @Generated
        public B serializer(Serializer serializer) {
            this.serializer = serializer;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "ImmutableEntity.ImmutableEntityBuilder(id=" + String.valueOf(this.id) + ", type=" + String.valueOf(this.type) + ", value=" + String.valueOf(this.value) + ", idProperty=" + this.idProperty + ", parent=" + String.valueOf(this.parent) + ", holder=" + String.valueOf(this.holder) + ", entityHelper=" + String.valueOf(this.entityHelper) + ", serializer=" + String.valueOf(this.serializer) + ")";
        }
    }

    @Generated
    private static final class ImmutableEntityBuilderImpl<T>
    extends ImmutableEntityBuilder<T, ImmutableEntity<T>, ImmutableEntityBuilderImpl<T>> {
        @Generated
        private ImmutableEntityBuilderImpl() {
        }

        @Override
        @Generated
        protected ImmutableEntityBuilderImpl<T> self() {
            return this;
        }

        @Override
        @Generated
        public ImmutableEntity<T> build() {
            return new ImmutableEntity(this);
        }
    }
}

