/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.publishing.client;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.Command;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.api.publishing.Append;
import io.fluxcapacitor.javaclient.common.websocket.AbstractWebsocketClient;
import io.fluxcapacitor.javaclient.configuration.client.WebSocketClient;
import io.fluxcapacitor.javaclient.publishing.client.GatewayClient;
import jakarta.websocket.ClientEndpoint;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;

@ClientEndpoint
public class WebsocketGatewayClient
extends AbstractWebsocketClient
implements GatewayClient {
    private final Set<Consumer<List<SerializedMessage>>> monitors = new CopyOnWriteArraySet<Consumer<List<SerializedMessage>>>();
    private final Metadata metricsMetadata;
    private final MessageType messageType;

    public WebsocketGatewayClient(String endPointUrl, WebSocketClient client, MessageType type) {
        this(URI.create(endPointUrl), client, type);
    }

    public WebsocketGatewayClient(URI endPointUri, WebSocketClient client, MessageType type) {
        this(endPointUri, client, type, type != MessageType.METRICS);
    }

    public WebsocketGatewayClient(URI endPointUri, WebSocketClient client, MessageType type, boolean sendMetrics) {
        super(endPointUri, client, sendMetrics, client.getClientConfig().getGatewaySessions().get(type));
        this.metricsMetadata = Metadata.of((Object)"messageType", (Object)type);
        this.messageType = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> append(Guarantee guarantee, SerializedMessage ... messages) {
        try {
            CompletableFuture<Void> completableFuture = this.sendCommand((Command)new Append(this.messageType, Arrays.asList(messages), guarantee));
            return completableFuture;
        }
        finally {
            if (!this.monitors.isEmpty()) {
                this.monitors.forEach(m -> m.accept(Arrays.asList(messages)));
            }
        }
    }

    @Override
    public String toString() {
        return "%s-%s".formatted(super.toString(), this.messageType);
    }

    @Override
    protected Metadata metricsMetadata() {
        return this.metricsMetadata;
    }

    public Registration registerMonitor(Consumer<List<SerializedMessage>> monitor) {
        this.monitors.add(monitor);
        return () -> this.monitors.remove(monitor);
    }
}

