/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking;

import io.fluxcapacitor.common.RetryConfiguration;
import io.fluxcapacitor.common.TimingUtils;
import io.fluxcapacitor.javaclient.common.exception.FunctionalException;
import io.fluxcapacitor.javaclient.tracking.ErrorHandler;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryingErrorHandler
implements ErrorHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RetryingErrorHandler.class);
    private final Predicate<Throwable> errorFilter;
    private final boolean stopConsumerOnFailure;
    private final boolean logFunctionalErrors;
    private final RetryConfiguration retryConfiguration;

    public RetryingErrorHandler() {
        this(false);
    }

    public RetryingErrorHandler(boolean stopConsumerOnFailure) {
        this(e -> !(e instanceof FunctionalException), stopConsumerOnFailure);
    }

    public RetryingErrorHandler(Predicate<Throwable> errorFilter) {
        this(errorFilter, false);
    }

    public RetryingErrorHandler(Predicate<Throwable> errorFilter, boolean stopConsumerOnFailure) {
        this(5, Duration.ofSeconds(2L), errorFilter, stopConsumerOnFailure, true);
    }

    public RetryingErrorHandler(int maxRetries, Duration delay, Predicate<Throwable> errorFilter, boolean stopConsumerOnFailure, boolean logFunctionalErrors) {
        this(maxRetries, delay, errorFilter, stopConsumerOnFailure, logFunctionalErrors, e -> e);
    }

    public RetryingErrorHandler(int maxRetries, Duration delay, Predicate<Throwable> errorFilter, boolean stopConsumerOnFailure, boolean logFunctionalErrors, Function<Throwable, ?> errorMapper) {
        this(errorFilter, stopConsumerOnFailure, logFunctionalErrors, RetryConfiguration.builder().delay(delay).maxRetries(maxRetries).errorMapper(errorMapper).successLogger(s -> log.info("Message handling was successful on retry")).exceptionLogger(s -> {}).build());
    }

    /*
     * Loose catch block
     */
    @Override
    public Object handleError(Throwable error, String errorMessage, Callable<?> retryFunction) {
        block10: {
            if (this.errorFilter.test(error)) break block10;
            this.logError(String.format("%s. Not retrying. %s", errorMessage, this.stopConsumerOnFailure ? "Propagating error." : "Continuing with next handler."), error);
            if (this.stopConsumerOnFailure) {
                throw error;
            }
            return this.retryConfiguration.getErrorMapper().apply(error);
            {
                catch (Throwable $ex) {
                    throw $ex;
                }
            }
        }
        try {
            if (this.retryConfiguration.getMaxRetries() == 0) {
                throw error;
            }
            if (this.retryConfiguration.getMaxRetries() > 0) {
                log.warn("{}. Retrying up to {} times.", new Object[]{errorMessage, this.retryConfiguration.getMaxRetries(), error});
            } else {
                log.warn("{}. Retrying until the errors stop.", (Object)errorMessage, (Object)error);
            }
            return TimingUtils.retryOnFailure(retryFunction, (RetryConfiguration)this.retryConfiguration);
        }
        catch (Throwable e) {
            if (this.stopConsumerOnFailure) {
                log.error("{}. Not retrying any further. Propagating error.", (Object)errorMessage, (Object)error);
                throw error;
            }
            this.logError(errorMessage + ". Not retrying any further. Continuing with next handler.", error);
            return this.retryConfiguration.getErrorMapper().apply(error);
        }
    }

    protected void logError(String message, Throwable error) {
        if (RetryingErrorHandler.isTechnicalError(error)) {
            log.error(message, error);
        } else if (this.logFunctionalErrors) {
            log.warn(message, error);
        }
    }

    protected static boolean isTechnicalError(Throwable error) {
        return !(error instanceof FunctionalException);
    }

    @ConstructorProperties(value={"errorFilter", "stopConsumerOnFailure", "logFunctionalErrors", "retryConfiguration"})
    @Generated
    protected RetryingErrorHandler(Predicate<Throwable> errorFilter, boolean stopConsumerOnFailure, boolean logFunctionalErrors, RetryConfiguration retryConfiguration) {
        this.errorFilter = errorFilter;
        this.stopConsumerOnFailure = stopConsumerOnFailure;
        this.logFunctionalErrors = logFunctionalErrors;
        this.retryConfiguration = retryConfiguration;
    }
}

