/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking;

import io.fluxcapacitor.common.ConsistentHashing;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.tracking.MessageBatch;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.tracking.ConsumerConfiguration;
import java.beans.ConstructorProperties;
import java.util.Optional;
import lombok.Generated;

public final class Tracker {
    public static final ThreadLocal<Tracker> current = new ThreadLocal();
    private final String name;
    private final String trackerId;
    private final MessageType messageType;
    private final ConsumerConfiguration configuration;
    private final MessageBatch messageBatch;

    public static Optional<Tracker> current() {
        return Optional.ofNullable(current.get());
    }

    public boolean canHandle(DeserializingMessage message, String routingKey) {
        if (this.messageBatch == null || this.messageBatch.getPosition() == null) {
            return true;
        }
        int segment = ConsistentHashing.computeSegment((String)routingKey);
        return ConsistentHashing.fallsInRange((int)segment, (int[])this.messageBatch.getSegment()) && this.messageBatch.getPosition().isNewIndex(segment, message.getIndex());
    }

    @ConstructorProperties(value={"name", "trackerId", "messageType", "configuration", "messageBatch"})
    @Generated
    public Tracker(String name, String trackerId, MessageType messageType, ConsumerConfiguration configuration, MessageBatch messageBatch) {
        this.name = name;
        this.trackerId = trackerId;
        this.messageType = messageType;
        this.configuration = configuration;
        this.messageBatch = messageBatch;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getTrackerId() {
        return this.trackerId;
    }

    @Generated
    public MessageType getMessageType() {
        return this.messageType;
    }

    @Generated
    public ConsumerConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public MessageBatch getMessageBatch() {
        return this.messageBatch;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Tracker)) {
            return false;
        }
        Tracker other = (Tracker)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$trackerId = this.getTrackerId();
        String other$trackerId = other.getTrackerId();
        if (this$trackerId == null ? other$trackerId != null : !this$trackerId.equals(other$trackerId)) {
            return false;
        }
        MessageType this$messageType = this.getMessageType();
        MessageType other$messageType = other.getMessageType();
        if (this$messageType == null ? other$messageType != null : !this$messageType.equals(other$messageType)) {
            return false;
        }
        ConsumerConfiguration this$configuration = this.getConfiguration();
        ConsumerConfiguration other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $trackerId = this.getTrackerId();
        result = result * 59 + ($trackerId == null ? 43 : $trackerId.hashCode());
        MessageType $messageType = this.getMessageType();
        result = result * 59 + ($messageType == null ? 43 : $messageType.hashCode());
        ConsumerConfiguration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Tracker(name=" + this.getName() + ", trackerId=" + this.getTrackerId() + ", messageType=" + String.valueOf(this.getMessageType()) + ", configuration=" + String.valueOf(this.getConfiguration()) + ")";
    }

    @Generated
    public Tracker withMessageBatch(MessageBatch messageBatch) {
        return this.messageBatch == messageBatch ? this : new Tracker(this.name, this.trackerId, this.messageType, this.configuration, messageBatch);
    }
}

