/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling.authentication;

import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.javaclient.common.HasMessage;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.DelegatingUserProvider;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.User;
import java.util.Optional;
import java.util.ServiceLoader;

public interface UserProvider {
    public static final UserProvider defaultUserProvider = Optional.of(ServiceLoader.load(UserProvider.class)).flatMap(loader -> loader.stream().map(ServiceLoader.Provider::get).reduce(UserProvider::andThen)).orElse(null);

    default public User getActiveUser() {
        return User.getCurrent();
    }

    public User getUserById(Object var1);

    public User getSystemUser();

    public User fromMessage(HasMessage var1);

    public boolean containsUser(Metadata var1);

    public Metadata removeFromMetadata(Metadata var1);

    default public Metadata addToMetadata(Metadata metadata, User user) {
        return this.addToMetadata(metadata, user, false);
    }

    public Metadata addToMetadata(Metadata var1, User var2, boolean var3);

    default public UserProvider andThen(final UserProvider other) {
        return new DelegatingUserProvider(this, this){

            @Override
            public User getUserById(Object userId) {
                return Optional.ofNullable(super.getUserById(userId)).orElseGet(() -> other.getUserById(userId));
            }

            @Override
            public User getSystemUser() {
                return Optional.ofNullable(super.getSystemUser()).orElseGet(other::getSystemUser);
            }

            @Override
            public User fromMessage(HasMessage message) {
                return Optional.ofNullable(super.fromMessage(message)).orElseGet(() -> other.fromMessage(message));
            }

            @Override
            public boolean containsUser(Metadata metadata) {
                return super.containsUser(metadata) || other.containsUser(metadata);
            }

            @Override
            public Metadata removeFromMetadata(Metadata metadata) {
                metadata = super.removeFromMetadata(metadata);
                return other.removeFromMetadata(metadata);
            }

            @Override
            public Metadata addToMetadata(Metadata metadata, User user, boolean ifAbsent) {
                if (ifAbsent) {
                    return other.addToMetadata(super.addToMetadata(metadata, user, true), user, true);
                }
                boolean chained = this.delegate instanceof DelegatingUserProvider;
                return other.addToMetadata(super.addToMetadata(metadata, user, chained), user, true);
            }
        };
    }
}

