/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling.errorreporting;

import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.javaclient.common.ClientUtils;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.exception.FunctionalException;
import io.fluxcapacitor.javaclient.common.exception.TechnicalException;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.publishing.ErrorGateway;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerInterceptor;
import java.beans.ConstructorProperties;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorReportingInterceptor
implements HandlerInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ErrorReportingInterceptor.class);
    private final ErrorGateway errorGateway;

    @Override
    public Function<DeserializingMessage, Object> interceptHandling(Function<DeserializingMessage, Object> function, HandlerInvoker invoker) {
        if (ClientUtils.isLocalHandler(invoker)) {
            return function;
        }
        return message -> {
            try {
                Object result = function.apply((DeserializingMessage)message);
                if (result instanceof CompletionStage) {
                    CompletionStage s = (CompletionStage)result;
                    s.whenComplete((r, e) -> {
                        if (e != null) {
                            message.run(m -> this.reportError((Throwable)e, invoker, (DeserializingMessage)m));
                        }
                    });
                }
                return result;
            }
            catch (Throwable e2) {
                this.reportError(e2, invoker, (DeserializingMessage)message);
                throw e2;
            }
        };
    }

    protected void reportError(Throwable e, HandlerInvoker invoker, DeserializingMessage cause) {
        e = ObjectUtils.unwrapException((Throwable)e);
        Metadata metadata = cause.getMetadata();
        if (!(e instanceof FunctionalException) && !(e instanceof TechnicalException)) {
            metadata = metadata.with((Object)"stackTrace", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            e = new TechnicalException(String.format("Handler %s failed to handle a %s", invoker.getTargetClass(), cause));
        }
        this.errorGateway.report(new Message(e, metadata));
    }

    @ConstructorProperties(value={"errorGateway"})
    @Generated
    public ErrorReportingInterceptor(ErrorGateway errorGateway) {
        this.errorGateway = errorGateway;
    }
}

