/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.metrics;

import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.ClientUtils;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.tracking.Tracker;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerInterceptor;
import io.fluxcapacitor.javaclient.tracking.handling.LocalHandler;
import io.fluxcapacitor.javaclient.tracking.metrics.CompleteMessageEvent;
import io.fluxcapacitor.javaclient.tracking.metrics.HandleMessageEvent;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlerMonitor
implements HandlerInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HandlerMonitor.class);

    @Override
    public Function<DeserializingMessage, Object> interceptHandling(Function<DeserializingMessage, Object> function, HandlerInvoker invoker) {
        return message -> {
            Instant start = Instant.now();
            try {
                Object result = function.apply((DeserializingMessage)message);
                this.publishMetrics(invoker, (DeserializingMessage)message, false, start, result);
                return result;
            }
            catch (Throwable e) {
                this.publishMetrics(invoker, (DeserializingMessage)message, true, start, e);
                throw e;
            }
        };
    }

    protected void publishMetrics(HandlerInvoker invoker, DeserializingMessage message, boolean exceptionalResult, Instant start, Object result) {
        try {
            if (this.logMetrics(invoker)) {
                String consumer = Tracker.current().map(Tracker::getName).orElseGet(() -> "local-" + String.valueOf(message.getMessageType()));
                boolean completed = !(result instanceof CompletableFuture) || ((CompletableFuture)result).isDone();
                FluxCapacitor.getOptionally().ifPresent(fc -> fc.metricsGateway().publish(new HandleMessageEvent(consumer, invoker.getTargetClass().getSimpleName(), message.getIndex(), message.getType(), exceptionalResult, start.until(Instant.now(), ChronoUnit.NANOS), completed)));
                if (!completed) {
                    Map<String, String> correlationData = FluxCapacitor.currentCorrelationData();
                    ((CompletionStage)result).whenComplete((r, e) -> message.run(m -> FluxCapacitor.getOptionally().ifPresent(fc -> fc.metricsGateway().publish(new CompleteMessageEvent(consumer, invoker.getTargetClass().getSimpleName(), m.getIndex(), m.getType(), e != null, start.until(Instant.now(), ChronoUnit.NANOS)), Metadata.of((Map)correlationData)))));
                }
            }
        }
        catch (Exception e2) {
            log.error("Failed to publish handler metrics", (Throwable)e2);
        }
    }

    protected boolean logMetrics(HandlerInvoker invoker) {
        return ClientUtils.getLocalHandlerAnnotation(invoker.getTargetClass(), invoker.getMethod()).map(LocalHandler::logMetrics).orElseGet(() -> Tracker.current().isPresent());
    }
}

