/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.web;

import com.typesafe.config.Config;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.serialization.JsonUtils;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.web.ParameterValue;
import io.fluxcapacitor.javaclient.web.WebParameterType;
import io.fluxcapacitor.javaclient.web.WebRequest;
import io.fluxcapacitor.javaclient.web.WebRequestContext;
import io.fluxcapacitor.javaclient.web.WebUtils;
import io.jooby.BeanConverter;
import io.jooby.Body;
import io.jooby.Context;
import io.jooby.Cookie;
import io.jooby.DefaultContext;
import io.jooby.Environment;
import io.jooby.ErrorHandler;
import io.jooby.Formdata;
import io.jooby.MediaType;
import io.jooby.MessageDecoder;
import io.jooby.MessageEncoder;
import io.jooby.MvcExtension;
import io.jooby.ParamSource;
import io.jooby.QueryString;
import io.jooby.Route;
import io.jooby.RouteSet;
import io.jooby.Router;
import io.jooby.RouterOption;
import io.jooby.Sender;
import io.jooby.ServerOptions;
import io.jooby.ServerSentEmitter;
import io.jooby.ServiceKey;
import io.jooby.ServiceRegistry;
import io.jooby.SessionStore;
import io.jooby.StatusCode;
import io.jooby.Value;
import io.jooby.ValueConverter;
import io.jooby.ValueNode;
import io.jooby.WebSocket;
import io.jooby.buffer.DataBuffer;
import io.jooby.buffer.DataBufferFactory;
import io.jooby.exception.RegistryException;
import io.jooby.handler.AssetHandler;
import io.jooby.handler.AssetSource;
import io.jooby.internal.RouterImpl;
import jakarta.inject.Provider;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.HttpCookie;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class DefaultWebRequestContext
implements DefaultContext,
WebRequestContext {
    private static final Pattern IP_PATTERN = Pattern.compile("[0-9a-fA-F.:]+");
    private static final Router ROUTER = new ConvertingRouter();
    private final Supplier<byte[]> bodySupplier;
    private final Metadata metadata;
    private final AtomicReference<Object> uri = new AtomicReference();
    private final AtomicReference<Object> method = new AtomicReference();
    private final AtomicReference<Object> requestPath = new AtomicReference();
    @jakarta.annotation.Nullable
    private final AtomicReference<Object> origin = new AtomicReference();
    private final AtomicReference<Object> query = new AtomicReference();
    private final AtomicReference<Object> header = new AtomicReference();
    private final AtomicReference<Object> cookieMap = new AtomicReference();
    private final AtomicReference<Object> attributes = new AtomicReference();
    private final AtomicReference<Object> remoteAddress = new AtomicReference();
    private Map<String, String> pathMap;
    private Route route;
    private final AtomicReference<Object> body = new AtomicReference();
    private final AtomicReference<Object> form = new AtomicReference();

    public static DefaultWebRequestContext getWebRequestContext(DeserializingMessage message) {
        return message.computeContextIfAbsent(DefaultWebRequestContext.class, DefaultWebRequestContext::new);
    }

    DefaultWebRequestContext(DeserializingMessage message) {
        if (message.getMessageType() != MessageType.WEBREQUEST) {
            throw new IllegalArgumentException("Invalid message type: " + String.valueOf(message.getMessageType()));
        }
        this.bodySupplier = () -> (byte[])message.getSerializedObject().getData().getValue();
        this.metadata = message.getMetadata();
    }

    @NotNull
    public Map<String, String> pathMap() {
        return this.pathMap;
    }

    @Override
    public ParameterValue getParameter(WebParameterType type, String name) {
        ParamSource[] paramSourceArray = new ParamSource[1];
        paramSourceArray[0] = switch (type) {
            default -> throw new MatchException(null, null);
            case WebParameterType.PATH -> ParamSource.PATH;
            case WebParameterType.HEADER -> ParamSource.HEADER;
            case WebParameterType.COOKIE -> ParamSource.COOKIE;
            case WebParameterType.FORM -> ParamSource.FORM;
            case WebParameterType.QUERY -> ParamSource.QUERY;
        };
        Value value = this.lookup(name, paramSourceArray);
        return new ParameterValue(value);
    }

    @NotNull
    public String getProtocol() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public List<Certificate> getClientCertificates() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public String getScheme() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Context setRemoteAddress(@NotNull String remoteAddress) {
        return this;
    }

    @NotNull
    public Context setHost(@NotNull String host) {
        return this;
    }

    @NotNull
    public Context setPort(int port) {
        return this;
    }

    @NotNull
    public Context setScheme(@NotNull String scheme) {
        return this;
    }

    public boolean isInIoThread() {
        return false;
    }

    @NotNull
    public Context dispatch(@NotNull Runnable action) {
        return this;
    }

    @NotNull
    public Context dispatch(@NotNull Executor executor, @NotNull Runnable action) {
        return this;
    }

    @NotNull
    public Context detach(@NotNull Route.Handler next) throws Exception {
        return this;
    }

    @NotNull
    public Context upgrade(@NotNull WebSocket.Initializer handler) {
        return this;
    }

    @NotNull
    public Context upgrade(@NotNull ServerSentEmitter.Handler handler) {
        return this;
    }

    @NotNull
    public Context setResponseHeader(@NotNull String name, @NotNull String value) {
        return this;
    }

    @NotNull
    public Context removeResponseHeader(@NotNull String name) {
        return this;
    }

    @NotNull
    public Context removeResponseHeaders() {
        return this;
    }

    @NotNull
    public Context setResponseLength(long length) {
        return this;
    }

    @Nullable
    public String getResponseHeader(@NotNull String name) {
        return null;
    }

    public long getResponseLength() {
        return -1L;
    }

    public boolean isResponseStarted() {
        return false;
    }

    public boolean getResetHeadersOnError() {
        return false;
    }

    @NotNull
    public MediaType getResponseType() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Context setResponseCode(int statusCode) {
        return this;
    }

    @NotNull
    public StatusCode getResponseCode() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public OutputStream responseStream() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Sender responseSender() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public PrintWriter responseWriter(@NotNull MediaType contentType, @Nullable Charset charset) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Router getRouter() {
        return ROUTER;
    }

    @NotNull
    public Context setMethod(@NotNull String method) {
        return this;
    }

    @NotNull
    public Context setRequestPath(@NotNull String path) {
        return this;
    }

    @NotNull
    public Context send(@NotNull String data, @NotNull Charset charset) {
        return this;
    }

    @NotNull
    public Context send(@NotNull byte[] data) {
        return this;
    }

    @NotNull
    public Context send(@NotNull ByteBuffer data) {
        return this;
    }

    @NotNull
    public Context send(@NotNull DataBuffer data) {
        return this;
    }

    @NotNull
    public Context send(@NotNull ByteBuffer[] data) {
        return this;
    }

    @NotNull
    public Context send(@NotNull ReadableByteChannel channel) {
        return this;
    }

    @NotNull
    public Context send(@NotNull InputStream input) {
        return this;
    }

    @NotNull
    public Context send(@NotNull FileChannel file) {
        return this;
    }

    @NotNull
    public Context send(@NotNull StatusCode statusCode) {
        return this;
    }

    @NotNull
    public Context setResetHeadersOnError(boolean value) {
        return this;
    }

    @NotNull
    public Context setResponseCookie(@NotNull Cookie cookie) {
        return this;
    }

    @NotNull
    public Context setResponseType(@NotNull String contentType) {
        return this;
    }

    @NotNull
    public Context setResponseType(@NotNull MediaType contentType, @Nullable Charset charset) {
        return this;
    }

    @NotNull
    public Context setDefaultResponseType(@NotNull MediaType contentType) {
        return this;
    }

    @NotNull
    public Context onComplete(@NotNull Route.Complete task) {
        return this;
    }

    @Generated
    public Supplier<byte[]> getBodySupplier() {
        return this.bodySupplier;
    }

    @Generated
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Generated
    public Map<String, String> getPathMap() {
        return this.pathMap;
    }

    @Generated
    public Route getRoute() {
        return this.route;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultWebRequestContext)) {
            return false;
        }
        DefaultWebRequestContext other = (DefaultWebRequestContext)o;
        Supplier<byte[]> this$bodySupplier = this.getBodySupplier();
        Supplier<byte[]> other$bodySupplier = other.getBodySupplier();
        if (this$bodySupplier == null ? other$bodySupplier != null : !this$bodySupplier.equals(other$bodySupplier)) {
            return false;
        }
        Metadata this$metadata = this.getMetadata();
        Metadata other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) {
            return false;
        }
        URI this$uri = this.getUri();
        URI other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !((Object)this$uri).equals(other$uri)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$requestPath = this.getRequestPath();
        String other$requestPath = other.getRequestPath();
        if (this$requestPath == null ? other$requestPath != null : !this$requestPath.equals(other$requestPath)) {
            return false;
        }
        String this$origin = this.getOrigin();
        String other$origin = other.getOrigin();
        if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
            return false;
        }
        QueryString this$query = this.query();
        QueryString other$query = other.query();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        ValueNode this$header = this.header();
        ValueNode other$header = other.header();
        if (this$header == null ? other$header != null : !this$header.equals(other$header)) {
            return false;
        }
        Map<String, String> this$cookieMap = this.cookieMap();
        Map<String, String> other$cookieMap = other.cookieMap();
        if (this$cookieMap == null ? other$cookieMap != null : !((Object)this$cookieMap).equals(other$cookieMap)) {
            return false;
        }
        Map<String, Object> this$attributes = this.getAttributes();
        Map<String, Object> other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        String this$remoteAddress = this.getRemoteAddress();
        String other$remoteAddress = other.getRemoteAddress();
        if (this$remoteAddress == null ? other$remoteAddress != null : !this$remoteAddress.equals(other$remoteAddress)) {
            return false;
        }
        Map<String, String> this$pathMap = this.getPathMap();
        Map<String, String> other$pathMap = other.getPathMap();
        if (this$pathMap == null ? other$pathMap != null : !((Object)this$pathMap).equals(other$pathMap)) {
            return false;
        }
        Route this$route = this.getRoute();
        Route other$route = other.getRoute();
        if (this$route == null ? other$route != null : !this$route.equals(other$route)) {
            return false;
        }
        Body this$body = this.body();
        Body other$body = other.body();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        Formdata this$form = this.form();
        Formdata other$form = other.form();
        return !(this$form == null ? other$form != null : !this$form.equals(other$form));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Supplier<byte[]> $bodySupplier = this.getBodySupplier();
        result = result * 59 + ($bodySupplier == null ? 43 : $bodySupplier.hashCode());
        Metadata $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
        URI $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : ((Object)$uri).hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $requestPath = this.getRequestPath();
        result = result * 59 + ($requestPath == null ? 43 : $requestPath.hashCode());
        String $origin = this.getOrigin();
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        QueryString $query = this.query();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        ValueNode $header = this.header();
        result = result * 59 + ($header == null ? 43 : $header.hashCode());
        Map<String, String> $cookieMap = this.cookieMap();
        result = result * 59 + ($cookieMap == null ? 43 : ((Object)$cookieMap).hashCode());
        Map<String, Object> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        String $remoteAddress = this.getRemoteAddress();
        result = result * 59 + ($remoteAddress == null ? 43 : $remoteAddress.hashCode());
        Map<String, String> $pathMap = this.getPathMap();
        result = result * 59 + ($pathMap == null ? 43 : ((Object)$pathMap).hashCode());
        Route $route = this.getRoute();
        result = result * 59 + ($route == null ? 43 : $route.hashCode());
        Body $body = this.body();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        Formdata $form = this.form();
        result = result * 59 + ($form == null ? 43 : $form.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DefaultWebRequestContext(bodySupplier=" + String.valueOf(this.getBodySupplier()) + ", metadata=" + String.valueOf(this.getMetadata()) + ", uri=" + String.valueOf(this.getUri()) + ", method=" + this.getMethod() + ", requestPath=" + this.getRequestPath() + ", origin=" + this.getOrigin() + ", query=" + String.valueOf(this.query()) + ", header=" + String.valueOf(this.header()) + ", cookieMap=" + String.valueOf(this.cookieMap()) + ", attributes=" + String.valueOf(this.getAttributes()) + ", remoteAddress=" + this.getRemoteAddress() + ", pathMap=" + String.valueOf(this.getPathMap()) + ", route=" + String.valueOf(this.getRoute()) + ", body=" + String.valueOf(this.body()) + ", form=" + String.valueOf(this.form()) + ")";
    }

    @ConstructorProperties(value={"bodySupplier", "metadata"})
    @Generated
    public DefaultWebRequestContext(Supplier<byte[]> bodySupplier, Metadata metadata) {
        this.bodySupplier = bodySupplier;
        this.metadata = metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public URI getUri() {
        Object $value = this.uri.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.uri;
            synchronized (atomicReference) {
                $value = this.uri.get();
                if ($value == null) {
                    URI actualValue = URI.create(WebRequest.getUrl(this.metadata));
                    $value = actualValue == null ? this.uri : actualValue;
                    this.uri.set($value);
                }
            }
        }
        return (URI)($value == this.uri ? null : $value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public String getMethod() {
        Object $value = this.method.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.method;
            synchronized (atomicReference) {
                $value = this.method.get();
                if ($value == null) {
                    String actualValue = WebRequest.getMethod(this.metadata).name();
                    $value = actualValue == null ? this.method : actualValue;
                    this.method.set($value);
                }
            }
        }
        return (String)($value == this.method ? null : $value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public String getRequestPath() {
        Object $value = this.requestPath.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.requestPath;
            synchronized (atomicReference) {
                $value = this.requestPath.get();
                if ($value == null) {
                    String actualValue = this.getUri().getRawPath();
                    $value = actualValue == null ? this.requestPath : actualValue;
                    this.requestPath.set($value);
                }
            }
        }
        return (String)($value == this.requestPath ? null : $value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @jakarta.annotation.Nullable
    @Generated
    public String getOrigin() {
        Object $value = this.origin.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.origin;
            synchronized (atomicReference) {
                $value = this.origin.get();
                if ($value == null) {
                    String actualValue = Optional.ofNullable(this.getUri().getScheme()).map(scheme -> scheme + "://" + this.getUri().getHost() + Optional.ofNullable(this.getUri().getPort()).filter(p -> p >= 0).map(p -> ":" + p).orElse("")).orElse(null);
                    $value = actualValue == null ? this.origin : actualValue;
                    this.origin.set($value);
                }
            }
        }
        return (String)($value == this.origin ? null : $value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public QueryString query() {
        Object $value = this.query.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.query;
            synchronized (atomicReference) {
                $value = this.query.get();
                if ($value == null) {
                    QueryString actualValue = QueryString.create((Context)this, (String)this.getUri().getQuery());
                    $value = actualValue == null ? this.query : actualValue;
                    this.query.set($value);
                }
            }
        }
        return (QueryString)($value == this.query ? null : $value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public ValueNode header() {
        Object $value = this.header.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.header;
            synchronized (atomicReference) {
                $value = this.header.get();
                if ($value == null) {
                    ValueNode actualValue = Value.headers((Context)this, WebRequest.getHeaders(this.metadata));
                    $value = actualValue == null ? this.header : actualValue;
                    this.header.set($value);
                }
            }
        }
        return (ValueNode)($value == this.header ? null : $value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public Map<String, String> cookieMap() {
        Object $value = this.cookieMap.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.cookieMap;
            synchronized (atomicReference) {
                $value = this.cookieMap.get();
                if ($value == null) {
                    Map<String, String> actualValue = WebRequest.getHeaders(this.metadata).getOrDefault("Cookie", Collections.emptyList()).stream().findFirst().map(WebUtils::parseRequestCookieHeader).orElseGet(Collections::emptyList).stream().collect(Collectors.toMap(HttpCookie::getName, HttpCookie::getValue));
                    $value = actualValue == null ? this.cookieMap : actualValue;
                    this.cookieMap.set($value);
                }
            }
        }
        return (Map)($value == this.cookieMap ? null : $value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public Map<String, Object> getAttributes() {
        Serializable $value = this.attributes.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.attributes;
            synchronized (atomicReference) {
                $value = this.attributes.get();
                if ($value == null) {
                    HashMap actualValue = new HashMap();
                    $value = actualValue == null ? this.attributes : actualValue;
                    this.attributes.set($value);
                }
            }
        }
        return (Map)((Object)($value == this.attributes ? null : $value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public String getRemoteAddress() {
        Object $value = this.remoteAddress.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.remoteAddress;
            synchronized (atomicReference) {
                $value = this.remoteAddress.get();
                if ($value == null) {
                    String actualValue = Stream.of("X-Forwarded-For", "Forwarded", "X-Real-IP").flatMap(h -> WebRequest.getHeader(this.metadata, h).stream()).flatMap(s -> {
                        Matcher matcher = IP_PATTERN.matcher((CharSequence)s);
                        return matcher.find() ? Stream.of(matcher.group()) : Stream.empty();
                    }).findFirst().orElse("");
                    $value = actualValue == null ? this.remoteAddress : actualValue;
                    this.remoteAddress.set($value);
                }
            }
        }
        return (String)($value == this.remoteAddress ? null : $value);
    }

    @Generated
    public DefaultWebRequestContext setPathMap(Map<String, String> pathMap) {
        this.pathMap = pathMap;
        return this;
    }

    @Generated
    public DefaultWebRequestContext setRoute(Route route) {
        this.route = route;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public Body body() {
        Object $value = this.body.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.body;
            synchronized (atomicReference) {
                $value = this.body.get();
                if ($value == null) {
                    Body actualValue = Body.of((Context)this, (byte[])this.bodySupplier.get());
                    $value = actualValue == null ? this.body : actualValue;
                    this.body.set($value);
                }
            }
        }
        return (Body)($value == this.body ? null : $value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public Formdata form() {
        Object $value = this.form.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.form;
            synchronized (atomicReference) {
                $value = this.form.get();
                if ($value == null) {
                    Formdata actualValue = Formdata.create((Context)this);
                    $value = actualValue == null ? this.form : actualValue;
                    this.form.set($value);
                }
            }
        }
        return (Formdata)($value == this.form ? null : $value);
    }

    protected static class ConvertingRouter
    implements Router {
        private final Router delegate = new RouterImpl();

        public ConvertingRouter() {
            this.delegate.converter((ValueConverter)new DefaultConverter());
        }

        @Generated
        public Config getConfig() {
            return this.delegate.getConfig();
        }

        @Generated
        public Environment getEnvironment() {
            return this.delegate.getEnvironment();
        }

        @Generated
        public List<Locale> getLocales() {
            return this.delegate.getLocales();
        }

        @Generated
        public Map<String, Object> getAttributes() {
            return this.delegate.getAttributes();
        }

        @Generated
        public <T> T attribute(String key) {
            return (T)this.delegate.attribute(key);
        }

        @Generated
        public Router attribute(String key, Object value) {
            return this.delegate.attribute(key, value);
        }

        @Generated
        public ServiceRegistry getServices() {
            return this.delegate.getServices();
        }

        @Generated
        public Router setContextPath(String contextPath) {
            return this.delegate.setContextPath(contextPath);
        }

        @Generated
        public String getContextPath() {
            return this.delegate.getContextPath();
        }

        @Generated
        public boolean isTrustProxy() {
            return this.delegate.isTrustProxy();
        }

        @Generated
        public boolean isStarted() {
            return this.delegate.isStarted();
        }

        @Generated
        public boolean isStopped() {
            return this.delegate.isStopped();
        }

        @Generated
        public Router setTrustProxy(boolean trustProxy) {
            return this.delegate.setTrustProxy(trustProxy);
        }

        @Generated
        public Router setHiddenMethod(String parameterName) {
            return this.delegate.setHiddenMethod(parameterName);
        }

        @Generated
        public Router setHiddenMethod(Function<Context, Optional<String>> provider) {
            return this.delegate.setHiddenMethod(provider);
        }

        @Generated
        public Router setCurrentUser(Function<Context, Object> provider) {
            return this.delegate.setCurrentUser(provider);
        }

        @Generated
        public Router setContextAsService(boolean contextAsService) {
            return this.delegate.setContextAsService(contextAsService);
        }

        @Generated
        public Router domain(String domain, Router subrouter) {
            return this.delegate.domain(domain, subrouter);
        }

        @Generated
        public RouteSet domain(String domain, Runnable body) {
            return this.delegate.domain(domain, body);
        }

        @Generated
        public Router mount(Predicate<Context> predicate, Router router) {
            return this.delegate.mount(predicate, router);
        }

        @Generated
        public RouteSet mount(Predicate<Context> predicate, Runnable body) {
            return this.delegate.mount(predicate, body);
        }

        @Generated
        public Router mount(String path, Router router) {
            return this.delegate.mount(path, router);
        }

        @Generated
        public Router mount(Router router) {
            return this.delegate.mount(router);
        }

        @Generated
        public Router mvc(MvcExtension router) {
            return this.delegate.mvc(router);
        }

        @Deprecated
        @Generated
        public Router mvc(Class router) {
            return this.delegate.mvc(router);
        }

        @Deprecated
        @Generated
        public <T> Router mvc(Class<T> router, Provider<T> provider) {
            return this.delegate.mvc(router, provider);
        }

        @Deprecated
        @Generated
        public Router mvc(Object router) {
            return this.delegate.mvc(router);
        }

        @Generated
        public Route ws(String pattern, WebSocket.Initializer handler) {
            return this.delegate.ws(pattern, handler);
        }

        @Generated
        public Route sse(String pattern, ServerSentEmitter.Handler handler) {
            return this.delegate.sse(pattern, handler);
        }

        @Generated
        public List<Route> getRoutes() {
            return this.delegate.getRoutes();
        }

        @Generated
        public Router encoder(MessageEncoder encoder) {
            return this.delegate.encoder(encoder);
        }

        @Generated
        public Router encoder(MediaType contentType, MessageEncoder encoder) {
            return this.delegate.encoder(contentType, encoder);
        }

        @Generated
        public Path getTmpdir() {
            return this.delegate.getTmpdir();
        }

        @Generated
        public Router decoder(MediaType contentType, MessageDecoder decoder) {
            return this.delegate.decoder(contentType, decoder);
        }

        @Generated
        public Executor getWorker() {
            return this.delegate.getWorker();
        }

        @Generated
        public Router setWorker(Executor worker) {
            return this.delegate.setWorker(worker);
        }

        @Generated
        public Router setDefaultWorker(Executor worker) {
            return this.delegate.setDefaultWorker(worker);
        }

        @Generated
        public DataBufferFactory getBufferFactory() {
            return this.delegate.getBufferFactory();
        }

        @Generated
        public Router setBufferFactory(DataBufferFactory bufferFactory) {
            return this.delegate.setBufferFactory(bufferFactory);
        }

        @Generated
        public Router use(Route.Filter filter) {
            return this.delegate.use(filter);
        }

        @Deprecated
        @Generated
        public Router decorator(Route.Decorator filter) {
            return this.delegate.decorator(filter);
        }

        @Generated
        public Router before(Route.Before before) {
            return this.delegate.before(before);
        }

        @Generated
        public Router after(Route.After after) {
            return this.delegate.after(after);
        }

        @Generated
        public Router dispatch(Runnable body) {
            return this.delegate.dispatch(body);
        }

        @Generated
        public Router dispatch(Executor executor, Runnable body) {
            return this.delegate.dispatch(executor, body);
        }

        @Generated
        public RouteSet routes(Runnable body) {
            return this.delegate.routes(body);
        }

        @Generated
        public RouteSet path(String pattern, Runnable body) {
            return this.delegate.path(pattern, body);
        }

        @Generated
        public Route get(String pattern, Route.Handler handler) {
            return this.delegate.get(pattern, handler);
        }

        @Generated
        public Route post(String pattern, Route.Handler handler) {
            return this.delegate.post(pattern, handler);
        }

        @Generated
        public Route put(String pattern, Route.Handler handler) {
            return this.delegate.put(pattern, handler);
        }

        @Generated
        public Route delete(String pattern, Route.Handler handler) {
            return this.delegate.delete(pattern, handler);
        }

        @Generated
        public Route patch(String pattern, Route.Handler handler) {
            return this.delegate.patch(pattern, handler);
        }

        @Generated
        public Route head(String pattern, Route.Handler handler) {
            return this.delegate.head(pattern, handler);
        }

        @Generated
        public Route options(String pattern, Route.Handler handler) {
            return this.delegate.options(pattern, handler);
        }

        @Generated
        public Route trace(String pattern, Route.Handler handler) {
            return this.delegate.trace(pattern, handler);
        }

        @Generated
        public AssetHandler assets(String pattern, Path source) {
            return this.delegate.assets(pattern, source);
        }

        @Generated
        public AssetHandler assets(String pattern, String source) {
            return this.delegate.assets(pattern, source);
        }

        @Generated
        public AssetHandler assets(String pattern, AssetSource source, AssetSource ... sources) {
            return this.delegate.assets(pattern, source, sources);
        }

        @Generated
        public AssetHandler assets(String pattern, AssetHandler handler) {
            return this.delegate.assets(pattern, handler);
        }

        @Generated
        public Route route(String method, String pattern, Route.Handler handler) {
            return this.delegate.route(method, pattern, handler);
        }

        @Generated
        public Router.Match match(Context ctx) {
            return this.delegate.match(ctx);
        }

        @Generated
        public boolean match(String method, String path) {
            return this.delegate.match(method, path);
        }

        @Generated
        public Router errorCode(Class<? extends Throwable> type, StatusCode statusCode) {
            return this.delegate.errorCode(type, statusCode);
        }

        @Generated
        public StatusCode errorCode(Throwable cause) {
            return this.delegate.errorCode(cause);
        }

        @Generated
        public Router error(StatusCode statusCode, ErrorHandler handler) {
            return this.delegate.error(statusCode, handler);
        }

        @Generated
        public Router error(Class<? extends Throwable> type, ErrorHandler handler) {
            return this.delegate.error(type, handler);
        }

        @Generated
        public Router error(Predicate<StatusCode> predicate, ErrorHandler handler) {
            return this.delegate.error(predicate, handler);
        }

        @Generated
        public Router error(ErrorHandler handler) {
            return this.delegate.error(handler);
        }

        @Generated
        public ErrorHandler getErrorHandler() {
            return this.delegate.getErrorHandler();
        }

        @Generated
        public Logger getLog() {
            return this.delegate.getLog();
        }

        @Generated
        public Set<RouterOption> getRouterOptions() {
            return this.delegate.getRouterOptions();
        }

        @Generated
        public Router setRouterOptions(RouterOption ... options) {
            return this.delegate.setRouterOptions(options);
        }

        @Generated
        public SessionStore getSessionStore() {
            return this.delegate.getSessionStore();
        }

        @Generated
        public Router setSessionStore(SessionStore store) {
            return this.delegate.setSessionStore(store);
        }

        @Generated
        public Executor executor(String name) {
            return this.delegate.executor(name);
        }

        @Generated
        public Router executor(String name, Executor executor) {
            return this.delegate.executor(name, executor);
        }

        @Generated
        public Cookie getFlashCookie() {
            return this.delegate.getFlashCookie();
        }

        @Generated
        public Router setFlashCookie(Cookie flashCookie) {
            return this.delegate.setFlashCookie(flashCookie);
        }

        @Generated
        public Router converter(ValueConverter converter) {
            return this.delegate.converter(converter);
        }

        @Generated
        public List<ValueConverter> getConverters() {
            return this.delegate.getConverters();
        }

        @Generated
        public List<BeanConverter> getBeanConverters() {
            return this.delegate.getBeanConverters();
        }

        @Generated
        public ServerOptions getServerOptions() {
            return this.delegate.getServerOptions();
        }

        @Generated
        public <T> T require(Class<T> type) throws RegistryException {
            return (T)this.delegate.require(type);
        }

        @Generated
        public <T> T require(Class<T> type, String name) throws RegistryException {
            return (T)this.delegate.require(type, name);
        }

        @Generated
        public <T> T require(ServiceKey<T> key) throws RegistryException {
            return (T)this.delegate.require(key);
        }
    }

    protected static final class Wrapper<T> {
        private final T value;

        <V> V get(Class<V> type) {
            if (this.value == null) {
                return null;
            }
            if (type.isInstance(this.value)) {
                return type.cast(this.value);
            }
            Wrapper result = (Wrapper)JsonUtils.convertValue((Object)this, tf -> tf.constructParametricType(Wrapper.class, new Class[]{type}));
            return (V)result.value;
        }

        @ConstructorProperties(value={"value"})
        @Generated
        public Wrapper(T value) {
            this.value = value;
        }

        @Generated
        public T getValue() {
            return this.value;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Wrapper)) {
                return false;
            }
            Wrapper other = (Wrapper)o;
            T this$value = this.getValue();
            T other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DefaultWebRequestContext.Wrapper(value=" + String.valueOf(this.getValue()) + ")";
        }
    }

    protected static class DefaultConverter
    implements ValueConverter<Value> {
        protected DefaultConverter() {
        }

        public boolean supports(@NotNull Class type) {
            return true;
        }

        public Object convert(@NotNull Value value, @NotNull Class type) {
            return new Wrapper<String>(value.valueOrNull()).get(type);
        }
    }
}

