/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.web;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.handling.HandlerConfiguration;
import io.fluxcapacitor.common.handling.HandlerInspector;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.common.handling.HandlerMatcher;
import io.fluxcapacitor.common.handling.ParameterResolver;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.web.DefaultWebRequestContext;
import io.fluxcapacitor.javaclient.web.Path;
import io.fluxcapacitor.javaclient.web.WebParameters;
import io.fluxcapacitor.javaclient.web.WebUtils;
import io.jooby.Context;
import io.jooby.Route;
import io.jooby.Router;
import io.jooby.internal.RouterImpl;
import java.io.Serializable;
import java.lang.reflect.Executable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class WebHandlerMatcher
implements HandlerMatcher<Object, DeserializingMessage> {
    private final Router router = new RouterImpl();

    public static WebHandlerMatcher create(Class<?> c, List<ParameterResolver<? super DeserializingMessage>> parameterResolvers, HandlerConfiguration<DeserializingMessage> config) {
        List<HandlerInspector.MethodHandlerMatcher<DeserializingMessage>> matchers = Stream.concat(ReflectionUtils.getAllMethods(c).stream(), Arrays.stream(c.getDeclaredConstructors())).filter(m -> config.methodMatches(c, m)).flatMap(m -> Stream.of(new HandlerInspector.MethodHandlerMatcher(m, c, parameterResolvers, config))).toList();
        return new WebHandlerMatcher(matchers);
    }

    protected WebHandlerMatcher(List<HandlerInspector.MethodHandlerMatcher<DeserializingMessage>> methodHandlerMatchers) {
        HashMap<String, Router> subRouters = new HashMap<String, Router>();
        for (HandlerInspector.MethodHandlerMatcher<DeserializingMessage> m : methodHandlerMatchers) {
            String root = ReflectionUtils.getMethodAnnotation((Executable)m.getExecutable(), Path.class).or(() -> Optional.ofNullable((Path)ReflectionUtils.getTypeAnnotation((Class)m.getTargetClass(), Path.class))).or(() -> ReflectionUtils.getPackageAnnotation((Package)m.getTargetClass().getPackage(), Path.class)).map(Path::value).map(p -> p.endsWith("//") || !p.endsWith("/") ? p : p.substring(0, p.length() - 1)).orElse("");
            WebParameters webParameters = WebUtils.getWebParameters(m.getExecutable(), m.getMethodAnnotationType()).orElseThrow();
            String origin2 = webParameters.getOrigin();
            Router router = origin2 == null ? this.router : subRouters.computeIfAbsent(origin2, __ -> new RouterImpl());
            router.route(webParameters.getMethod().name(), root + webParameters.getPath(), (Route.Handler & Serializable)ctx -> m);
        }
        subRouters.forEach((origin, subRouter) -> this.router.mount(ctx -> {
            if (ctx instanceof DefaultWebRequestContext) {
                DefaultWebRequestContext context = (DefaultWebRequestContext)ctx;
                return Objects.equals(origin, context.getOrigin());
            }
            throw new UnsupportedOperationException("Unknown context class: " + String.valueOf(ctx.getClass()));
        }, subRouter));
    }

    public boolean canHandle(DeserializingMessage message) {
        return this.methodMatcher(message).map(m -> m.canHandle((Object)message)).orElse(false);
    }

    public Stream<Executable> matchingMethods(DeserializingMessage message) {
        return this.methodMatcher(message).stream().flatMap(m -> m.matchingMethods((Object)message));
    }

    public Optional<HandlerInvoker> getInvoker(Object target, DeserializingMessage message) {
        return this.methodMatcher(message).flatMap(m -> m.getInvoker(target, (Object)message));
    }

    protected Optional<HandlerInspector.MethodHandlerMatcher<DeserializingMessage>> methodMatcher(DeserializingMessage message) {
        if (message.getMessageType() != MessageType.WEBREQUEST) {
            return Optional.empty();
        }
        DefaultWebRequestContext context = DefaultWebRequestContext.getWebRequestContext(message);
        return Optional.of(this.router.match((Context)context)).filter(Router.Match::matches).map(match -> (HandlerInspector.MethodHandlerMatcher)match.execute((Context)context));
    }
}

