/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Supplier;
import lombok.Generated;

@JsonSerialize(using=CustomSerializer.class)
@JsonDeserialize(using=CustomDeserializer.class)
public class LazyId {
    private volatile String id;
    private volatile boolean computed;
    private final Supplier<String> supplier;

    public LazyId() {
        this(FluxCapacitor::generateId);
    }

    public LazyId(Supplier<String> supplier) {
        this.supplier = Objects.requireNonNull(supplier);
    }

    public LazyId(Object id) {
        this.id = id == null ? null : id.toString();
        this.computed = true;
        this.supplier = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getId() {
        if (!this.computed) {
            LazyId lazyId = this;
            synchronized (lazyId) {
                if (!this.computed) {
                    this.id = this.supplier.get();
                    this.computed = true;
                }
            }
        }
        return this.id;
    }

    public String toString() {
        return this.getId();
    }

    @Generated
    public boolean isComputed() {
        return this.computed;
    }

    @Generated
    public Supplier<String> getSupplier() {
        return this.supplier;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LazyId)) {
            return false;
        }
        LazyId other = (LazyId)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LazyId;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    static class CustomDeserializer
    extends StdScalarDeserializer<LazyId> {
        protected CustomDeserializer() {
            super(LazyId.class);
        }

        public LazyId getNullValue(DeserializationContext ctxt) {
            return new LazyId((Object)null);
        }

        public LazyId deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return new LazyId(p.getText());
        }
    }

    static class CustomSerializer
    extends StdScalarSerializer<LazyId> {
        protected CustomSerializer() {
            super(LazyId.class);
        }

        public void serialize(LazyId value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            String s;
            String string = s = value == null ? null : value.getId();
            if (s == null) {
                gen.writeNull();
            } else {
                gen.writeString(s);
            }
        }
    }
}

