/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.HasMessage;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.User;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.UserProvider;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, defaultImpl=Message.class)
public class Message
implements HasMessage {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Message.class);
    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
    private final Object payload;
    private final Metadata metadata;
    private final String messageId;
    private final Instant timestamp;
    @JsonIgnore
    private final AtomicReference<Object> routingKey = new AtomicReference();

    public static Message asMessage(Object object) {
        Message message;
        if (object instanceof HasMessage) {
            HasMessage hm = (HasMessage)object;
            message = hm.toMessage();
        } else {
            message = new Message(object);
        }
        return message;
    }

    public Message(Object payload) {
        this(payload, Metadata.empty());
    }

    public Message(Object payload, Metadata metadata) {
        this(payload, metadata, null, null);
    }

    @ConstructorProperties(value={"payload", "metadata", "messageId", "timestamp"})
    public Message(Object payload, Metadata metadata, String messageId, Instant timestamp) {
        this.payload = payload;
        this.metadata = Optional.ofNullable(metadata).orElseGet(Metadata::empty);
        this.messageId = Optional.ofNullable(messageId).orElseGet(() -> FluxCapacitor.currentIdentityProvider().nextTechnicalId());
        this.timestamp = Optional.ofNullable(timestamp).orElseGet(() -> FluxCapacitor.currentTime().truncatedTo(ChronoUnit.MILLIS));
    }

    @Override
    public <R> R getPayload() {
        return (R)this.payload;
    }

    @Override
    public Message toMessage() {
        return this;
    }

    public Message withPayload(Object payload) {
        if (payload == this.getPayload()) {
            return this;
        }
        return new Message(payload, this.metadata, this.messageId, this.timestamp);
    }

    public Message addMetadata(Metadata metadata) {
        return this.withMetadata(this.getMetadata().with(metadata));
    }

    public Message addMetadata(String key, Object value) {
        return this.withMetadata(this.getMetadata().with((Object)key, value));
    }

    public Message addMetadata(Object ... keyValues) {
        return this.withMetadata(this.getMetadata().with(keyValues));
    }

    public Message addMetadata(Map<String, ?> values) {
        return this.withMetadata(this.getMetadata().with(values));
    }

    public Message addUser(User user) {
        return this.addMetadata(FluxCapacitor.getOptionally().map(FluxCapacitor::userProvider).or(() -> Optional.ofNullable(UserProvider.defaultUserProvider)).orElseThrow(() -> new IllegalStateException("User provider is not set")).addToMetadata(this.getMetadata(), user));
    }

    public SerializedMessage serialize(Serializer serializer) {
        return new SerializedMessage(serializer.serialize(this.payload), this.metadata, this.messageId, Long.valueOf(this.timestamp.toEpochMilli()));
    }

    @Generated
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @Generated
    public String getMessageId() {
        return this.messageId;
    }

    @Override
    @Generated
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Object this$payload = this.getPayload();
        Object other$payload = other.getPayload();
        if (this$payload == null ? other$payload != null : !this$payload.equals(other$payload)) {
            return false;
        }
        Metadata this$metadata = this.getMetadata();
        Metadata other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) {
            return false;
        }
        String this$messageId = this.getMessageId();
        String other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !this$messageId.equals(other$messageId)) {
            return false;
        }
        Instant this$timestamp = this.getTimestamp();
        Instant other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        Optional<String> this$routingKey = this.getRoutingKey();
        Optional<String> other$routingKey = other.getRoutingKey();
        return !(this$routingKey == null ? other$routingKey != null : !((Object)this$routingKey).equals(other$routingKey));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Message;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
        Metadata $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
        String $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : $messageId.hashCode());
        Instant $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        Optional<String> $routingKey = this.getRoutingKey();
        result = result * 59 + ($routingKey == null ? 43 : ((Object)$routingKey).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Message(payload=" + String.valueOf(this.getPayload()) + ", metadata=" + String.valueOf(this.getMetadata()) + ", messageId=" + this.getMessageId() + ", timestamp=" + String.valueOf(this.getTimestamp()) + ", routingKey=" + String.valueOf(this.getRoutingKey()) + ")";
    }

    @Generated
    public Message withMetadata(Metadata metadata) {
        return this.metadata == metadata ? this : new Message(this.payload, metadata, this.messageId, this.timestamp);
    }

    @Generated
    public Message withMessageId(String messageId) {
        return this.messageId == messageId ? this : new Message(this.payload, this.metadata, messageId, this.timestamp);
    }

    @Generated
    public Message withTimestamp(Instant timestamp) {
        return this.timestamp == timestamp ? this : new Message(this.payload, this.metadata, this.messageId, timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public Optional<String> getRoutingKey() {
        Object $value = this.routingKey.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.routingKey;
            synchronized (atomicReference) {
                $value = this.routingKey.get();
                if ($value == null) {
                    Optional<String> actualValue = this.computeRoutingKey();
                    $value = actualValue == null ? this.routingKey : actualValue;
                    this.routingKey.set($value);
                }
            }
        }
        return (Optional)($value == this.routingKey ? null : $value);
    }
}

