/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.serialization.casting;

import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.api.SerializedObject;
import io.fluxcapacitor.common.reflection.DefaultMemberInvoker;
import io.fluxcapacitor.common.reflection.MemberInvoker;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.common.serialization.DeserializationException;
import io.fluxcapacitor.javaclient.common.serialization.casting.AnnotatedCaster;
import io.fluxcapacitor.javaclient.common.serialization.casting.Cast;
import io.fluxcapacitor.javaclient.common.serialization.casting.CastParameters;
import io.fluxcapacitor.javaclient.common.serialization.casting.HasSource;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class CastInspector {
    public static boolean hasCasterMethods(Class<?> type) {
        return ReflectionUtils.getAllMethods(type).stream().anyMatch(m -> ReflectionUtils.has(Cast.class, (Method)m));
    }

    public static <T> List<AnnotatedCaster<T>> getCasters(Class<? extends Annotation> castAnnotation, Collection<?> candidateTargets, Class<T> dataType, Comparator<AnnotatedCaster<?>> casterComparator) {
        ArrayList result = new ArrayList();
        for (Object caster : candidateTargets) {
            ReflectionUtils.getAllMethods(caster.getClass()).forEach(m -> CastInspector.createCaster(caster, m, dataType, castAnnotation).ifPresent(result::add));
        }
        result.sort(casterComparator);
        return result;
    }

    private static <T> Optional<AnnotatedCaster<T>> createCaster(Object target, Method m, Class<T> dataType, Class<? extends Annotation> castAnnotation) {
        if (!ReflectionUtils.has(castAnnotation, (Method)m)) {
            return Optional.empty();
        }
        return ReflectionUtils.getAnnotationAs((AnnotatedElement)m, Cast.class, CastParameters.class).map(params -> CastInspector.createCaster(params, m, target, dataType));
    }

    private static <T> AnnotatedCaster<T> createCaster(CastParameters castParameters, Method method, Object target, Class<T> dataType) {
        if (((Method)ReflectionUtils.ensureAccessible((AccessibleObject)method)).getReturnType().equals(Void.TYPE)) {
            return new AnnotatedCaster(method, castParameters, i -> Stream.empty());
        }
        Function invokeFunction = CastInspector.invokeFunction(method, target, dataType);
        BiFunction resultMapper = CastInspector.mapResult(castParameters, method, dataType);
        return new AnnotatedCaster(method, castParameters, d -> (Stream)resultMapper.apply((SerializedObject)d, () -> invokeFunction.apply((SerializedObject)d)));
    }

    private static <T> Function<SerializedObject<T, ?>, Object> invokeFunction(Method method, Object target, Class<T> dataType) {
        List<Function> parameterFunctions = Arrays.stream(method.getGenericParameterTypes()).map(pt -> {
            if (pt instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)pt;
                if (parameterizedType.getRawType().equals(Data.class) && dataType.isAssignableFrom((Class)parameterizedType.getActualTypeArguments()[0])) {
                    return SerializedObject::data;
                }
                if (dataType.isAssignableFrom((Class)parameterizedType.getRawType())) {
                    return s -> s.data().getValue();
                }
            } else if (pt instanceof Class) {
                Class c = (Class)pt;
                if (dataType.isAssignableFrom(c)) {
                    return s -> s.data().getValue();
                }
                if (SerializedMessage.class.isAssignableFrom(c)) {
                    return s -> {
                        SerializedMessage m;
                        HasSource i;
                        Object patt0$temp;
                        return s instanceof HasSource && (patt0$temp = (i = (HasSource)s).getSource()) instanceof SerializedMessage ? (m = (SerializedMessage)patt0$temp) : null;
                    };
                }
            }
            throw new DeserializationException(String.format("Parameter in upcaster method '%s' is of unexpected type. Expected Data<%s> or %s.", method, dataType.getName(), dataType.getName()));
        }).toList();
        MemberInvoker invoker = DefaultMemberInvoker.asInvoker((Member)method);
        try {
            return s -> {
                Object[] args = new Object[parameterFunctions.size()];
                for (int i = 0; i < parameterFunctions.size(); ++i) {
                    Object arg = ((Function)parameterFunctions.get(i)).apply(s);
                    if (arg == null) {
                        return null;
                    }
                    args[i] = arg;
                }
                return invoker.invoke(target, args);
            };
        }
        catch (Throwable e) {
            throw new DeserializationException("Exception while upcasting using method: " + String.valueOf(invoker.getMember()), e);
        }
    }

    private static <T> BiFunction<SerializedObject<T, ?>, Supplier<Object>, Stream<SerializedObject<T, ?>>> mapResult(CastParameters annotation, Method method, Class<T> dataType) {
        if (dataType.isAssignableFrom(method.getReturnType())) {
            return (s, o) -> Stream.of(s.withData(new Data(o, annotation.type(), annotation.revision() + annotation.revisionDelta(), s.data().getFormat())));
        }
        if (method.getReturnType().equals(Data.class)) {
            return (s, o) -> Optional.ofNullable((Data)o.get()).stream().map(arg_0 -> ((SerializedObject)s).withData(arg_0));
        }
        if (method.getReturnType().equals(Optional.class)) {
            ParameterizedType parameterizedType = (ParameterizedType)method.getGenericReturnType();
            Type type = parameterizedType.getActualTypeArguments()[0];
            if (type instanceof Class) {
                Class typeParameter = (Class)type;
                if (dataType.isAssignableFrom(typeParameter)) {
                    return (s, o) -> Stream.of(s.withData(new Data(() -> CastInspector.lambda$mapResult$13((Supplier)o), annotation.type(), annotation.revision() + annotation.revisionDelta(), s.data().getFormat())));
                }
            } else if (parameterizedType.getActualTypeArguments()[0] instanceof ParameterizedType && ((ParameterizedType)parameterizedType.getActualTypeArguments()[0]).getRawType().equals(Data.class)) {
                return (s, o) -> {
                    Optional optional;
                    Object patt0$temp = o.get();
                    return patt0$temp instanceof Optional && (optional = (Optional)patt0$temp).isPresent() ? optional.stream().map(arg_0 -> ((SerializedObject)s).withData(arg_0)) : Stream.empty();
                };
            }
        }
        if (method.getReturnType().equals(Stream.class)) {
            return (s, o) -> {
                Stream<Object> stream;
                Object patt0$temp = o.get();
                if (patt0$temp instanceof Stream) {
                    Stream stream2 = (Stream)patt0$temp;
                    stream = stream2.map(arg_0 -> ((SerializedObject)s).withData(arg_0));
                } else {
                    stream = Stream.empty();
                }
                return stream;
            };
        }
        throw new DeserializationException(String.format("Unexpected return type of upcaster method '%s'. Expected Data<%s>, %s, Optional<Data<%s>>, Optional<%s>, Stream<Data<%s>> or void", method, dataType.getName(), dataType.getName(), dataType.getName(), dataType.getName(), dataType.getName()));
    }

    private static /* synthetic */ Object lambda$mapResult$13(Supplier o) {
        Optional optional;
        Object patt0$temp = o.get();
        return patt0$temp instanceof Optional && (optional = (Optional)patt0$temp).isPresent() ? optional.get() : null;
    }
}

