/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.serialization.jackson;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.api.SerializedObject;
import io.fluxcapacitor.common.api.search.SerializedDocument;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.common.search.Inverter;
import io.fluxcapacitor.common.search.JacksonInverter;
import io.fluxcapacitor.common.serialization.JsonUtils;
import io.fluxcapacitor.javaclient.common.ClientUtils;
import io.fluxcapacitor.javaclient.common.serialization.AbstractSerializer;
import io.fluxcapacitor.javaclient.common.serialization.ContentFilter;
import io.fluxcapacitor.javaclient.common.serialization.DeserializationException;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingObject;
import io.fluxcapacitor.javaclient.common.serialization.jackson.JacksonContentFilter;
import io.fluxcapacitor.javaclient.persisting.search.DocumentSerializer;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.User;
import java.lang.reflect.Type;
import java.lang.runtime.SwitchBootstraps;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonSerializer
extends AbstractSerializer<JsonNode>
implements DocumentSerializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JacksonSerializer.class);
    public static JsonMapper defaultObjectMapper = JsonUtils.writer;
    private final ObjectMapper objectMapper;
    private final ContentFilter contentFilter;
    private final Function<String, JavaType> typeCache = ObjectUtils.memoize(this::getJavaType);
    private final Function<Type, String> typeStringCache = ObjectUtils.memoize(this::getCanonicalType);
    private final Inverter<JsonNode> inverter;

    public JacksonSerializer() {
        this(Collections.emptyList());
    }

    public JacksonSerializer(Collection<?> casterCandidates) {
        this(defaultObjectMapper, casterCandidates);
    }

    public JacksonSerializer(JsonMapper objectMapper) {
        this(objectMapper, Collections.emptyList());
    }

    public JacksonSerializer(JsonMapper objectMapper, Collection<?> casterCandidates) {
        this(objectMapper, casterCandidates, new JacksonInverter());
    }

    public JacksonSerializer(JsonMapper objectMapper, Collection<?> casterCandidates, JacksonInverter inverter) {
        super(casterCandidates, inverter, "application/json");
        this.objectMapper = objectMapper;
        this.contentFilter = new JacksonContentFilter((ObjectMapper)objectMapper.copy());
        this.inverter = inverter;
    }

    @Override
    protected String asString(Type type) {
        return this.typeStringCache.apply(type);
    }

    @Override
    protected byte[] doSerialize(Object object) throws Exception {
        return this.objectMapper.writeValueAsBytes(object);
    }

    @Override
    protected Object doDeserialize(Data<?> data, String type) throws Exception {
        Object object = data.getValue();
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonNode.class, byte[].class, String.class}, (Object)object, n)) {
            case 0 -> {
                JsonNode v = (JsonNode)object;
                yield this.objectMapper.convertValue((Object)v, this.typeCache.apply(type));
            }
            case 1 -> {
                byte[] v = (byte[])object;
                yield this.objectMapper.readValue(v, this.typeCache.apply(type));
            }
            case 2 -> {
                String v = (String)object;
                yield this.objectMapper.readValue(v, this.typeCache.apply(type));
            }
            case -1 -> null;
            default -> throw new IllegalArgumentException("Incompatible data value type: " + String.valueOf(data.getValue().getClass()));
        };
    }

    @Override
    protected JsonNode asIntermediateValue(Object input) {
        return input instanceof byte[] ? this.objectMapper.readTree((byte[])input) : (JsonNode)this.objectMapper.convertValue(input, JsonNode.class);
    }

    @Override
    protected boolean isKnownType(String type) {
        try {
            this.typeCache.apply(type);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    protected Stream<DeserializingObject<byte[], ?>> deserializeUnknownType(SerializedObject<?, ?> s) {
        SerializedObject jsonNode = s.withData(new Data(s.data().getValue(), JsonNode.class.getName(), 0, this.getFormat()));
        return Stream.of(new DeserializingObject(jsonNode, type -> {
            try {
                Object serializedValue;
                Object selector0$temp = serializedValue = jsonNode.data().getValue();
                int index$1 = 0;
                return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonNode.class, byte[].class}, (Object)selector0$temp, index$1)) {
                    case -1 -> this.convert((Object)null, type);
                    case 0 -> {
                        JsonNode json = (JsonNode)selector0$temp;
                        yield this.convert(json, type);
                    }
                    case 1 -> {
                        byte[] bytes = (byte[])selector0$temp;
                        yield this.convert(this.objectMapper.readTree(bytes), type);
                    }
                    default -> throw new UnsupportedOperationException("Unsupported data type: " + String.valueOf(serializedValue.getClass()));
                };
            }
            catch (Exception e) {
                throw new DeserializationException(String.format("Could not deserialize a %s to a %s. Invalid json?", type, s.data().getType()), e);
            }
        }));
    }

    protected JavaType getJavaType(String type) {
        return this.objectMapper.getTypeFactory().constructFromCanonical(type);
    }

    protected String getCanonicalType(Type type) {
        return this.objectMapper.constructType(type).toCanonical();
    }

    @Override
    public SerializedDocument toDocument(Object value, String id, String collection, Instant timestamp, Instant end, Metadata metadata) {
        return this.inverter.toDocument(value, this.getTypeString(value), ClientUtils.getRevisionNumber(value), id, collection, timestamp, end, metadata);
    }

    @Override
    public <T> T fromDocument(SerializedDocument document) {
        return this.deserialize((SerializedObject<byte[], ?>)document.getDocument());
    }

    @Override
    public <T> T fromDocument(SerializedDocument document, Class<T> type) {
        return this.deserialize((SerializedObject<byte[], ?>)document.getDocument(), type);
    }

    @Override
    public <V> V doConvert(Object value, Class<V> type) {
        return (V)this.objectMapper.convertValue(value, type);
    }

    @Override
    public Object doClone(Object value) {
        return ReflectionUtils.copyFields((Object)value, this.doConvert(this.objectMapper.createObjectNode(), value.getClass()));
    }

    @Generated
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Override
    @Generated
    public <T> T filterContent(T value, User viewer) {
        return this.contentFilter.filterContent(value, viewer);
    }
}

