/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.configuration;

import io.fluxcapacitor.common.application.DecryptingPropertySource;
import io.fluxcapacitor.common.application.DefaultPropertySource;
import io.fluxcapacitor.common.application.PropertySource;
import io.fluxcapacitor.common.encryption.Encryption;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import java.util.Optional;

public class ApplicationProperties {
    public static String getProperty(String name) {
        return ApplicationProperties.getPropertySource().get(name);
    }

    public static boolean getBooleanProperty(String name) {
        return ApplicationProperties.getBooleanProperty(name, false);
    }

    public static boolean getBooleanProperty(String name, boolean defaultValue) {
        return Optional.ofNullable(ApplicationProperties.getProperty(name)).map("true"::equalsIgnoreCase).orElse(defaultValue);
    }

    public static Integer getIntegerProperty(String name) {
        return ApplicationProperties.getIntegerProperty(name, null);
    }

    public static Integer getIntegerProperty(String name, Integer defaultValue) {
        return Optional.ofNullable(ApplicationProperties.getProperty(name)).map(Integer::valueOf).orElse(defaultValue);
    }

    public static String getProperty(String name, String defaultValue) {
        return Optional.ofNullable(ApplicationProperties.getProperty(name)).orElse(defaultValue);
    }

    public static String requireProperty(String name) {
        return Optional.ofNullable(ApplicationProperties.getProperty(name)).orElseThrow(() -> new IllegalStateException(String.format("Property for %s is missing", name)));
    }

    public static boolean containsProperty(String name) {
        return ApplicationProperties.getProperty(name) != null;
    }

    public static String substituteProperties(String template) {
        return ApplicationProperties.getPropertySource().substituteProperties(template);
    }

    public static Encryption getEncryption() {
        return ApplicationProperties.getPropertySource().getEncryption();
    }

    public static String encryptValue(String value) {
        return ApplicationProperties.getEncryption().encrypt(value);
    }

    public static String decryptValue(String encryptedValue) {
        return ApplicationProperties.getEncryption().decrypt(encryptedValue);
    }

    static DecryptingPropertySource getPropertySource() {
        return FluxCapacitor.getOptionally().map(FluxCapacitor::propertySource).map(p -> {
            DecryptingPropertySource dps;
            return p instanceof DecryptingPropertySource ? (dps = (DecryptingPropertySource)p) : new DecryptingPropertySource(p);
        }).orElseGet(() -> new DecryptingPropertySource((PropertySource)DefaultPropertySource.getInstance()));
    }
}

