/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.configuration.client;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.application.DefaultPropertySource;
import io.fluxcapacitor.common.serialization.compression.CompressionAlgorithm;
import io.fluxcapacitor.javaclient.common.websocket.ServiceUrlBuilder;
import io.fluxcapacitor.javaclient.configuration.client.AbstractClient;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.client.EventStoreClient;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.client.WebSocketEventStoreClient;
import io.fluxcapacitor.javaclient.persisting.keyvalue.client.KeyValueClient;
import io.fluxcapacitor.javaclient.persisting.keyvalue.client.WebsocketKeyValueClient;
import io.fluxcapacitor.javaclient.persisting.search.client.SearchClient;
import io.fluxcapacitor.javaclient.persisting.search.client.WebSocketSearchClient;
import io.fluxcapacitor.javaclient.publishing.client.GatewayClient;
import io.fluxcapacitor.javaclient.publishing.client.WebsocketGatewayClient;
import io.fluxcapacitor.javaclient.scheduling.client.SchedulingClient;
import io.fluxcapacitor.javaclient.scheduling.client.WebsocketSchedulingClient;
import io.fluxcapacitor.javaclient.tracking.client.CachingTrackingClient;
import io.fluxcapacitor.javaclient.tracking.client.TrackingClient;
import io.fluxcapacitor.javaclient.tracking.client.WebsocketTrackingClient;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;

public class WebSocketClient
extends AbstractClient {
    private final ClientConfig clientConfig;

    public static WebSocketClient newInstance(ClientConfig clientConfig) {
        return new WebSocketClient(clientConfig);
    }

    @Override
    public String name() {
        return this.clientConfig.getName();
    }

    @Override
    public String id() {
        return this.clientConfig.getId();
    }

    @Override
    public String applicationId() {
        return this.clientConfig.getApplicationId();
    }

    @Override
    protected GatewayClient createGatewayClient(MessageType messageType, String topic) {
        return new WebsocketGatewayClient(ServiceUrlBuilder.producerUrl(messageType, topic, this.clientConfig), this, messageType, topic);
    }

    @Override
    protected TrackingClient createTrackingClient(MessageType messageType, String topic) {
        TrackingClientConfig trackingConfig = this.clientConfig.getTrackingConfigs().get(messageType);
        WebsocketTrackingClient wsClient = new WebsocketTrackingClient(ServiceUrlBuilder.consumerUrl(messageType, topic, this.clientConfig), this, messageType, topic);
        return trackingConfig.getCacheSize() > 0 ? new CachingTrackingClient(wsClient, trackingConfig.getCacheSize()) : wsClient;
    }

    @Override
    protected EventStoreClient createEventStoreClient() {
        return new WebSocketEventStoreClient(ServiceUrlBuilder.eventSourcingUrl(this.clientConfig), this);
    }

    @Override
    protected SchedulingClient createSchedulingClient() {
        return new WebsocketSchedulingClient(ServiceUrlBuilder.schedulingUrl(this.clientConfig), this);
    }

    @Override
    protected KeyValueClient createKeyValueClient() {
        return new WebsocketKeyValueClient(ServiceUrlBuilder.keyValueUrl(this.clientConfig), this);
    }

    @Override
    protected SearchClient createSearchClient() {
        return new WebSocketSearchClient(ServiceUrlBuilder.searchUrl(this.clientConfig), this);
    }

    @Override
    public void shutDown() {
        super.shutDown();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @ConstructorProperties(value={"clientConfig"})
    @Generated
    protected WebSocketClient(ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    @Generated
    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public static final class ClientConfig {
        @NonNull
        private final String serviceBaseUrl;
        @NonNull
        private final String name;
        private final String applicationId;
        @NonNull
        private final String id;
        @NonNull
        private final CompressionAlgorithm compression;
        private final int eventSourcingSessions;
        private final int keyValueSessions;
        private final int searchSessions;
        private final Map<MessageType, Integer> gatewaySessions;
        private final Map<MessageType, TrackingClientConfig> trackingConfigs;
        private final Duration pingTimeout;
        private final Duration pingDelay;
        private final boolean disableMetrics;
        private final String projectId;
        private final String typeFilter;

        public ClientConfig withGatewaySessions(MessageType messageType, int count) {
            HashMap<MessageType, Integer> config = new HashMap<MessageType, Integer>(this.gatewaySessions);
            config.put(messageType, count);
            return this.toBuilder().gatewaySessions(config).build();
        }

        public ClientConfig withTrackingConfig(MessageType messageType, TrackingClientConfig trackingConfig) {
            HashMap<MessageType, TrackingClientConfig> config = new HashMap<MessageType, TrackingClientConfig>(this.trackingConfigs);
            config.put(messageType, trackingConfig);
            return this.toBuilder().trackingConfigs(config).build();
        }

        private static Map<MessageType, Integer> defaultGatewaySessions() {
            return Arrays.stream(MessageType.values()).collect(Collectors.toMap(Function.identity(), t -> 1));
        }

        private static Map<MessageType, TrackingClientConfig> defaultTrackingSessions() {
            return Arrays.stream(MessageType.values()).collect(Collectors.toMap(Function.identity(), t -> t == MessageType.RESULT ? TrackingClientConfig.builder().cacheSize(0).build() : TrackingClientConfig.builder().build()));
        }

        @Generated
        private static String $default$serviceBaseUrl() {
            return DefaultPropertySource.getInstance().get("FLUX_BASE_URL");
        }

        @Generated
        private static String $default$name() {
            return DefaultPropertySource.getInstance().get("FLUX_APPLICATION_NAME");
        }

        @Generated
        private static String $default$applicationId() {
            return DefaultPropertySource.getInstance().get("FLUX_APPLICATION_ID");
        }

        @Generated
        private static String $default$id() {
            return DefaultPropertySource.getInstance().get("FLUX_TASK_ID", UUID.randomUUID().toString());
        }

        @Generated
        private static CompressionAlgorithm $default$compression() {
            return CompressionAlgorithm.LZ4;
        }

        @Generated
        private static int $default$eventSourcingSessions() {
            return 2;
        }

        @Generated
        private static int $default$keyValueSessions() {
            return 2;
        }

        @Generated
        private static int $default$searchSessions() {
            return 2;
        }

        @Generated
        private static Map<MessageType, Integer> $default$gatewaySessions() {
            return ClientConfig.defaultGatewaySessions();
        }

        @Generated
        private static Map<MessageType, TrackingClientConfig> $default$trackingConfigs() {
            return ClientConfig.defaultTrackingSessions();
        }

        @Generated
        private static Duration $default$pingTimeout() {
            return Duration.ofSeconds(5L);
        }

        @Generated
        private static Duration $default$pingDelay() {
            return Duration.ofSeconds(10L);
        }

        @Generated
        private static String $default$projectId() {
            return DefaultPropertySource.getInstance().get("FLUX_PROJECT_ID");
        }

        @ConstructorProperties(value={"serviceBaseUrl", "name", "applicationId", "id", "compression", "eventSourcingSessions", "keyValueSessions", "searchSessions", "gatewaySessions", "trackingConfigs", "pingTimeout", "pingDelay", "disableMetrics", "projectId", "typeFilter"})
        @Generated
        ClientConfig(@NonNull String serviceBaseUrl, @NonNull String name, String applicationId, @NonNull String id, @NonNull CompressionAlgorithm compression, int eventSourcingSessions, int keyValueSessions, int searchSessions, Map<MessageType, Integer> gatewaySessions, Map<MessageType, TrackingClientConfig> trackingConfigs, Duration pingTimeout, Duration pingDelay, boolean disableMetrics, String projectId, String typeFilter) {
            if (serviceBaseUrl == null) {
                throw new NullPointerException("serviceBaseUrl is marked non-null but is null");
            }
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            if (compression == null) {
                throw new NullPointerException("compression is marked non-null but is null");
            }
            this.serviceBaseUrl = serviceBaseUrl;
            this.name = name;
            this.applicationId = applicationId;
            this.id = id;
            this.compression = compression;
            this.eventSourcingSessions = eventSourcingSessions;
            this.keyValueSessions = keyValueSessions;
            this.searchSessions = searchSessions;
            this.gatewaySessions = gatewaySessions;
            this.trackingConfigs = trackingConfigs;
            this.pingTimeout = pingTimeout;
            this.pingDelay = pingDelay;
            this.disableMetrics = disableMetrics;
            this.projectId = projectId;
            this.typeFilter = typeFilter;
        }

        @Generated
        public static ClientConfigBuilder builder() {
            return new ClientConfigBuilder();
        }

        @Generated
        public ClientConfigBuilder toBuilder() {
            return new ClientConfigBuilder().serviceBaseUrl(this.serviceBaseUrl).name(this.name).applicationId(this.applicationId).id(this.id).compression(this.compression).eventSourcingSessions(this.eventSourcingSessions).keyValueSessions(this.keyValueSessions).searchSessions(this.searchSessions).gatewaySessions(this.gatewaySessions).trackingConfigs(this.trackingConfigs).pingTimeout(this.pingTimeout).pingDelay(this.pingDelay).disableMetrics(this.disableMetrics).projectId(this.projectId).typeFilter(this.typeFilter);
        }

        @NonNull
        @Generated
        public String getServiceBaseUrl() {
            return this.serviceBaseUrl;
        }

        @NonNull
        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getApplicationId() {
            return this.applicationId;
        }

        @NonNull
        @Generated
        public String getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public CompressionAlgorithm getCompression() {
            return this.compression;
        }

        @Generated
        public int getEventSourcingSessions() {
            return this.eventSourcingSessions;
        }

        @Generated
        public int getKeyValueSessions() {
            return this.keyValueSessions;
        }

        @Generated
        public int getSearchSessions() {
            return this.searchSessions;
        }

        @Generated
        public Map<MessageType, Integer> getGatewaySessions() {
            return this.gatewaySessions;
        }

        @Generated
        public Map<MessageType, TrackingClientConfig> getTrackingConfigs() {
            return this.trackingConfigs;
        }

        @Generated
        public Duration getPingTimeout() {
            return this.pingTimeout;
        }

        @Generated
        public Duration getPingDelay() {
            return this.pingDelay;
        }

        @Generated
        public boolean isDisableMetrics() {
            return this.disableMetrics;
        }

        @Generated
        public String getProjectId() {
            return this.projectId;
        }

        @Generated
        public String getTypeFilter() {
            return this.typeFilter;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClientConfig)) {
                return false;
            }
            ClientConfig other = (ClientConfig)o;
            if (this.getEventSourcingSessions() != other.getEventSourcingSessions()) {
                return false;
            }
            if (this.getKeyValueSessions() != other.getKeyValueSessions()) {
                return false;
            }
            if (this.getSearchSessions() != other.getSearchSessions()) {
                return false;
            }
            if (this.isDisableMetrics() != other.isDisableMetrics()) {
                return false;
            }
            String this$serviceBaseUrl = this.getServiceBaseUrl();
            String other$serviceBaseUrl = other.getServiceBaseUrl();
            if (this$serviceBaseUrl == null ? other$serviceBaseUrl != null : !this$serviceBaseUrl.equals(other$serviceBaseUrl)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$applicationId = this.getApplicationId();
            String other$applicationId = other.getApplicationId();
            if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            CompressionAlgorithm this$compression = this.getCompression();
            CompressionAlgorithm other$compression = other.getCompression();
            if (this$compression == null ? other$compression != null : !this$compression.equals(other$compression)) {
                return false;
            }
            Map<MessageType, Integer> this$gatewaySessions = this.getGatewaySessions();
            Map<MessageType, Integer> other$gatewaySessions = other.getGatewaySessions();
            if (this$gatewaySessions == null ? other$gatewaySessions != null : !((Object)this$gatewaySessions).equals(other$gatewaySessions)) {
                return false;
            }
            Map<MessageType, TrackingClientConfig> this$trackingConfigs = this.getTrackingConfigs();
            Map<MessageType, TrackingClientConfig> other$trackingConfigs = other.getTrackingConfigs();
            if (this$trackingConfigs == null ? other$trackingConfigs != null : !((Object)this$trackingConfigs).equals(other$trackingConfigs)) {
                return false;
            }
            Duration this$pingTimeout = this.getPingTimeout();
            Duration other$pingTimeout = other.getPingTimeout();
            if (this$pingTimeout == null ? other$pingTimeout != null : !((Object)this$pingTimeout).equals(other$pingTimeout)) {
                return false;
            }
            Duration this$pingDelay = this.getPingDelay();
            Duration other$pingDelay = other.getPingDelay();
            if (this$pingDelay == null ? other$pingDelay != null : !((Object)this$pingDelay).equals(other$pingDelay)) {
                return false;
            }
            String this$projectId = this.getProjectId();
            String other$projectId = other.getProjectId();
            if (this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId)) {
                return false;
            }
            String this$typeFilter = this.getTypeFilter();
            String other$typeFilter = other.getTypeFilter();
            return !(this$typeFilter == null ? other$typeFilter != null : !this$typeFilter.equals(other$typeFilter));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getEventSourcingSessions();
            result = result * 59 + this.getKeyValueSessions();
            result = result * 59 + this.getSearchSessions();
            result = result * 59 + (this.isDisableMetrics() ? 79 : 97);
            String $serviceBaseUrl = this.getServiceBaseUrl();
            result = result * 59 + ($serviceBaseUrl == null ? 43 : $serviceBaseUrl.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $applicationId = this.getApplicationId();
            result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            CompressionAlgorithm $compression = this.getCompression();
            result = result * 59 + ($compression == null ? 43 : $compression.hashCode());
            Map<MessageType, Integer> $gatewaySessions = this.getGatewaySessions();
            result = result * 59 + ($gatewaySessions == null ? 43 : ((Object)$gatewaySessions).hashCode());
            Map<MessageType, TrackingClientConfig> $trackingConfigs = this.getTrackingConfigs();
            result = result * 59 + ($trackingConfigs == null ? 43 : ((Object)$trackingConfigs).hashCode());
            Duration $pingTimeout = this.getPingTimeout();
            result = result * 59 + ($pingTimeout == null ? 43 : ((Object)$pingTimeout).hashCode());
            Duration $pingDelay = this.getPingDelay();
            result = result * 59 + ($pingDelay == null ? 43 : ((Object)$pingDelay).hashCode());
            String $projectId = this.getProjectId();
            result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
            String $typeFilter = this.getTypeFilter();
            result = result * 59 + ($typeFilter == null ? 43 : $typeFilter.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WebSocketClient.ClientConfig(serviceBaseUrl=" + this.getServiceBaseUrl() + ", name=" + this.getName() + ", applicationId=" + this.getApplicationId() + ", id=" + this.getId() + ", compression=" + String.valueOf(this.getCompression()) + ", eventSourcingSessions=" + this.getEventSourcingSessions() + ", keyValueSessions=" + this.getKeyValueSessions() + ", searchSessions=" + this.getSearchSessions() + ", gatewaySessions=" + String.valueOf(this.getGatewaySessions()) + ", trackingConfigs=" + String.valueOf(this.getTrackingConfigs()) + ", pingTimeout=" + String.valueOf(this.getPingTimeout()) + ", pingDelay=" + String.valueOf(this.getPingDelay()) + ", disableMetrics=" + this.isDisableMetrics() + ", projectId=" + this.getProjectId() + ", typeFilter=" + this.getTypeFilter() + ")";
        }

        @Generated
        public static class ClientConfigBuilder {
            @Generated
            private boolean serviceBaseUrl$set;
            @Generated
            private String serviceBaseUrl$value;
            @Generated
            private boolean name$set;
            @Generated
            private String name$value;
            @Generated
            private boolean applicationId$set;
            @Generated
            private String applicationId$value;
            @Generated
            private boolean id$set;
            @Generated
            private String id$value;
            @Generated
            private boolean compression$set;
            @Generated
            private CompressionAlgorithm compression$value;
            @Generated
            private boolean eventSourcingSessions$set;
            @Generated
            private int eventSourcingSessions$value;
            @Generated
            private boolean keyValueSessions$set;
            @Generated
            private int keyValueSessions$value;
            @Generated
            private boolean searchSessions$set;
            @Generated
            private int searchSessions$value;
            @Generated
            private boolean gatewaySessions$set;
            @Generated
            private Map<MessageType, Integer> gatewaySessions$value;
            @Generated
            private boolean trackingConfigs$set;
            @Generated
            private Map<MessageType, TrackingClientConfig> trackingConfigs$value;
            @Generated
            private boolean pingTimeout$set;
            @Generated
            private Duration pingTimeout$value;
            @Generated
            private boolean pingDelay$set;
            @Generated
            private Duration pingDelay$value;
            @Generated
            private boolean disableMetrics;
            @Generated
            private boolean projectId$set;
            @Generated
            private String projectId$value;
            @Generated
            private String typeFilter;

            @Generated
            ClientConfigBuilder() {
            }

            @Generated
            public ClientConfigBuilder serviceBaseUrl(@NonNull String serviceBaseUrl) {
                if (serviceBaseUrl == null) {
                    throw new NullPointerException("serviceBaseUrl is marked non-null but is null");
                }
                this.serviceBaseUrl$value = serviceBaseUrl;
                this.serviceBaseUrl$set = true;
                return this;
            }

            @Generated
            public ClientConfigBuilder name(@NonNull String name) {
                if (name == null) {
                    throw new NullPointerException("name is marked non-null but is null");
                }
                this.name$value = name;
                this.name$set = true;
                return this;
            }

            @Generated
            public ClientConfigBuilder applicationId(String applicationId) {
                this.applicationId$value = applicationId;
                this.applicationId$set = true;
                return this;
            }

            @Generated
            public ClientConfigBuilder id(@NonNull String id) {
                if (id == null) {
                    throw new NullPointerException("id is marked non-null but is null");
                }
                this.id$value = id;
                this.id$set = true;
                return this;
            }

            @Generated
            public ClientConfigBuilder compression(@NonNull CompressionAlgorithm compression) {
                if (compression == null) {
                    throw new NullPointerException("compression is marked non-null but is null");
                }
                this.compression$value = compression;
                this.compression$set = true;
                return this;
            }

            @Generated
            public ClientConfigBuilder eventSourcingSessions(int eventSourcingSessions) {
                this.eventSourcingSessions$value = eventSourcingSessions;
                this.eventSourcingSessions$set = true;
                return this;
            }

            @Generated
            public ClientConfigBuilder keyValueSessions(int keyValueSessions) {
                this.keyValueSessions$value = keyValueSessions;
                this.keyValueSessions$set = true;
                return this;
            }

            @Generated
            public ClientConfigBuilder searchSessions(int searchSessions) {
                this.searchSessions$value = searchSessions;
                this.searchSessions$set = true;
                return this;
            }

            @Generated
            public ClientConfigBuilder gatewaySessions(Map<MessageType, Integer> gatewaySessions) {
                this.gatewaySessions$value = gatewaySessions;
                this.gatewaySessions$set = true;
                return this;
            }

            @Generated
            public ClientConfigBuilder trackingConfigs(Map<MessageType, TrackingClientConfig> trackingConfigs) {
                this.trackingConfigs$value = trackingConfigs;
                this.trackingConfigs$set = true;
                return this;
            }

            @Generated
            public ClientConfigBuilder pingTimeout(Duration pingTimeout) {
                this.pingTimeout$value = pingTimeout;
                this.pingTimeout$set = true;
                return this;
            }

            @Generated
            public ClientConfigBuilder pingDelay(Duration pingDelay) {
                this.pingDelay$value = pingDelay;
                this.pingDelay$set = true;
                return this;
            }

            @Generated
            public ClientConfigBuilder disableMetrics(boolean disableMetrics) {
                this.disableMetrics = disableMetrics;
                return this;
            }

            @Generated
            public ClientConfigBuilder projectId(String projectId) {
                this.projectId$value = projectId;
                this.projectId$set = true;
                return this;
            }

            @Generated
            public ClientConfigBuilder typeFilter(String typeFilter) {
                this.typeFilter = typeFilter;
                return this;
            }

            @Generated
            public ClientConfig build() {
                String serviceBaseUrl$value = this.serviceBaseUrl$value;
                if (!this.serviceBaseUrl$set) {
                    serviceBaseUrl$value = ClientConfig.$default$serviceBaseUrl();
                }
                String name$value = this.name$value;
                if (!this.name$set) {
                    name$value = ClientConfig.$default$name();
                }
                String applicationId$value = this.applicationId$value;
                if (!this.applicationId$set) {
                    applicationId$value = ClientConfig.$default$applicationId();
                }
                String id$value = this.id$value;
                if (!this.id$set) {
                    id$value = ClientConfig.$default$id();
                }
                CompressionAlgorithm compression$value = this.compression$value;
                if (!this.compression$set) {
                    compression$value = ClientConfig.$default$compression();
                }
                int eventSourcingSessions$value = this.eventSourcingSessions$value;
                if (!this.eventSourcingSessions$set) {
                    eventSourcingSessions$value = ClientConfig.$default$eventSourcingSessions();
                }
                int keyValueSessions$value = this.keyValueSessions$value;
                if (!this.keyValueSessions$set) {
                    keyValueSessions$value = ClientConfig.$default$keyValueSessions();
                }
                int searchSessions$value = this.searchSessions$value;
                if (!this.searchSessions$set) {
                    searchSessions$value = ClientConfig.$default$searchSessions();
                }
                Map<MessageType, Integer> gatewaySessions$value = this.gatewaySessions$value;
                if (!this.gatewaySessions$set) {
                    gatewaySessions$value = ClientConfig.$default$gatewaySessions();
                }
                Map<MessageType, TrackingClientConfig> trackingConfigs$value = this.trackingConfigs$value;
                if (!this.trackingConfigs$set) {
                    trackingConfigs$value = ClientConfig.$default$trackingConfigs();
                }
                Duration pingTimeout$value = this.pingTimeout$value;
                if (!this.pingTimeout$set) {
                    pingTimeout$value = ClientConfig.$default$pingTimeout();
                }
                Duration pingDelay$value = this.pingDelay$value;
                if (!this.pingDelay$set) {
                    pingDelay$value = ClientConfig.$default$pingDelay();
                }
                String projectId$value = this.projectId$value;
                if (!this.projectId$set) {
                    projectId$value = ClientConfig.$default$projectId();
                }
                return new ClientConfig(serviceBaseUrl$value, name$value, applicationId$value, id$value, compression$value, eventSourcingSessions$value, keyValueSessions$value, searchSessions$value, gatewaySessions$value, trackingConfigs$value, pingTimeout$value, pingDelay$value, this.disableMetrics, projectId$value, this.typeFilter);
            }

            @Generated
            public String toString() {
                return "WebSocketClient.ClientConfig.ClientConfigBuilder(serviceBaseUrl$value=" + this.serviceBaseUrl$value + ", name$value=" + this.name$value + ", applicationId$value=" + this.applicationId$value + ", id$value=" + this.id$value + ", compression$value=" + String.valueOf(this.compression$value) + ", eventSourcingSessions$value=" + this.eventSourcingSessions$value + ", keyValueSessions$value=" + this.keyValueSessions$value + ", searchSessions$value=" + this.searchSessions$value + ", gatewaySessions$value=" + String.valueOf(this.gatewaySessions$value) + ", trackingConfigs$value=" + String.valueOf(this.trackingConfigs$value) + ", pingTimeout$value=" + String.valueOf(this.pingTimeout$value) + ", pingDelay$value=" + String.valueOf(this.pingDelay$value) + ", disableMetrics=" + this.disableMetrics + ", projectId$value=" + this.projectId$value + ", typeFilter=" + this.typeFilter + ")";
            }
        }
    }

    public static final class TrackingClientConfig {
        private final int sessions;
        private final int cacheSize;

        @Generated
        private static int $default$sessions() {
            return 1;
        }

        @Generated
        private static int $default$cacheSize() {
            return 0;
        }

        @ConstructorProperties(value={"sessions", "cacheSize"})
        @Generated
        TrackingClientConfig(int sessions, int cacheSize) {
            this.sessions = sessions;
            this.cacheSize = cacheSize;
        }

        @Generated
        public static TrackingClientConfigBuilder builder() {
            return new TrackingClientConfigBuilder();
        }

        @Generated
        public TrackingClientConfigBuilder toBuilder() {
            return new TrackingClientConfigBuilder().sessions(this.sessions).cacheSize(this.cacheSize);
        }

        @Generated
        public int getSessions() {
            return this.sessions;
        }

        @Generated
        public int getCacheSize() {
            return this.cacheSize;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TrackingClientConfig)) {
                return false;
            }
            TrackingClientConfig other = (TrackingClientConfig)o;
            if (this.getSessions() != other.getSessions()) {
                return false;
            }
            return this.getCacheSize() == other.getCacheSize();
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSessions();
            result = result * 59 + this.getCacheSize();
            return result;
        }

        @Generated
        public String toString() {
            return "WebSocketClient.TrackingClientConfig(sessions=" + this.getSessions() + ", cacheSize=" + this.getCacheSize() + ")";
        }

        @Generated
        public static class TrackingClientConfigBuilder {
            @Generated
            private boolean sessions$set;
            @Generated
            private int sessions$value;
            @Generated
            private boolean cacheSize$set;
            @Generated
            private int cacheSize$value;

            @Generated
            TrackingClientConfigBuilder() {
            }

            @Generated
            public TrackingClientConfigBuilder sessions(int sessions) {
                this.sessions$value = sessions;
                this.sessions$set = true;
                return this;
            }

            @Generated
            public TrackingClientConfigBuilder cacheSize(int cacheSize) {
                this.cacheSize$value = cacheSize;
                this.cacheSize$set = true;
                return this;
            }

            @Generated
            public TrackingClientConfig build() {
                int sessions$value = this.sessions$value;
                if (!this.sessions$set) {
                    sessions$value = TrackingClientConfig.$default$sessions();
                }
                int cacheSize$value = this.cacheSize$value;
                if (!this.cacheSize$set) {
                    cacheSize$value = TrackingClientConfig.$default$cacheSize();
                }
                return new TrackingClientConfig(sessions$value, cacheSize$value);
            }

            @Generated
            public String toString() {
                return "WebSocketClient.TrackingClientConfig.TrackingClientConfigBuilder(sessions$value=" + this.sessions$value + ", cacheSize$value=" + this.cacheSize$value + ")";
            }
        }
    }
}

