/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.modeling;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.ThrowingConsumer;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.modeling.AggregateRoot;
import io.fluxcapacitor.javaclient.modeling.AppliedEvent;
import io.fluxcapacitor.javaclient.modeling.DelegatingEntity;
import io.fluxcapacitor.javaclient.modeling.Entity;
import io.fluxcapacitor.javaclient.modeling.EntityHelper;
import io.fluxcapacitor.javaclient.modeling.EventPublication;
import io.fluxcapacitor.javaclient.modeling.EventPublicationStrategy;
import io.fluxcapacitor.javaclient.modeling.ModifiableEntity;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.Apply;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import io.fluxcapacitor.javaclient.tracking.handling.Invocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;

public class ModifiableAggregateRoot<T>
extends DelegatingEntity<T>
implements AggregateRoot<T> {
    private static final ThreadLocal<Map<Object, ModifiableAggregateRoot<?>>> activeAggregates = ThreadLocal.withInitial(LinkedHashMap::new);
    private Entity<T> lastCommitted;
    private Entity<T> lastStable;
    private final boolean commitInBatch;
    private final EventPublication aggregateEventPublication;
    private final EventPublicationStrategy aggregatePublicationStrategy;
    private final EntityHelper entityHelper;
    private final Serializer serializer;
    private final DispatchInterceptor dispatchInterceptor;
    private final CommitHandler commitHandler;
    private final AtomicBoolean waitingForHandlerEnd = new AtomicBoolean();
    private final AtomicBoolean waitingForBatchEnd = new AtomicBoolean();
    private final List<AppliedEvent> applied = new ArrayList<AppliedEvent>();
    private final List<AppliedEvent> uncommitted = new ArrayList<AppliedEvent>();
    private final List<UnaryOperator<Entity<T>>> queued = new ArrayList<UnaryOperator<Entity<T>>>();
    private volatile boolean updating;
    private volatile boolean committing;
    private volatile boolean commitPending;

    public static <T> Optional<ModifiableAggregateRoot<T>> getIfActive(Object aggregateId) {
        return Optional.ofNullable(activeAggregates.get().get(aggregateId));
    }

    public static Map<String, Class<?>> getActiveAggregatesFor(@NonNull Object entityId) {
        if (entityId == null) {
            throw new NullPointerException("entityId is marked non-null but is null");
        }
        List candidates = activeAggregates.get().values().stream().filter(a -> a.getEntity(entityId).isPresent()).collect(Collectors.toList());
        Comparator<Entity> byPresent = Comparator.comparing(a -> a.getEntity(entityId).map(Entity::isPresent).orElse(false));
        Comparator<Entity> byOrder = Comparator.comparing(candidates::indexOf);
        return candidates.stream().sorted(byPresent.thenComparing(byOrder)).collect(Collectors.toMap(e -> e.id().toString(), Entity::type, (a, b) -> b, LinkedHashMap::new));
    }

    public static <T> Entity<T> load(Object aggregateId, Supplier<Entity<T>> loader, boolean commitInBatch, EventPublication eventPublication, EventPublicationStrategy publicationStrategy, EntityHelper entityHelper, Serializer serializer, DispatchInterceptor dispatchInterceptor, CommitHandler commitHandler) {
        return ModifiableAggregateRoot.getIfActive(aggregateId).orElseGet(() -> new ModifiableAggregateRoot((Entity)loader.get(), commitInBatch, eventPublication, publicationStrategy, entityHelper, serializer, dispatchInterceptor, commitHandler));
    }

    protected ModifiableAggregateRoot(Entity<T> delegate, boolean commitInBatch, EventPublication eventPublication, EventPublicationStrategy publicationStrategy, EntityHelper entityHelper, Serializer serializer, DispatchInterceptor dispatchInterceptor, CommitHandler commitHandler) {
        super(delegate);
        this.entityHelper = entityHelper;
        this.lastCommitted = delegate;
        this.lastStable = delegate;
        this.commitInBatch = commitInBatch;
        this.aggregateEventPublication = eventPublication;
        this.aggregatePublicationStrategy = publicationStrategy;
        this.serializer = serializer;
        this.dispatchInterceptor = dispatchInterceptor;
        this.commitHandler = commitHandler;
    }

    @Override
    public <E extends Exception> Entity<T> assertLegal(Object command) throws E {
        this.entityHelper.intercept(command, this).forEach(c -> this.entityHelper.assertLegal(c, this));
        return this;
    }

    @Override
    public Entity<T> assertAndApply(Object payloadOrMessage) {
        this.entityHelper.intercept(payloadOrMessage, this).forEach(m -> this.apply(Message.asMessage(m), true));
        return this;
    }

    @Override
    public Entity<T> update(UnaryOperator<T> function) {
        return this.handleUpdate(a -> a.update(function));
    }

    @Override
    public Entity<T> apply(Message message) {
        this.entityHelper.intercept(message, this).forEach(m -> this.apply(Message.asMessage(m), false));
        return this;
    }

    protected Entity<T> apply(Message message, boolean assertLegal) {
        return this.handleUpdate(a -> {
            Entity result;
            block9: {
                Optional<Apply> applyAnnotation;
                EventPublication eventPublication;
                if (assertLegal) {
                    this.entityHelper.assertLegal(message, (Entity<?>)a);
                }
                int hashCodeBefore = (eventPublication = (applyAnnotation = this.entityHelper.applyInvoker(new DeserializingMessage(message, MessageType.EVENT, null, this.serializer), (Entity<?>)a, true).map(HandlerInvoker::getMethodAnnotation)).map(Apply::eventPublication).filter(ep -> ep != EventPublication.DEFAULT).orElse(this.aggregateEventPublication)) == EventPublication.IF_MODIFIED ? (a.get() == null ? -1 : a.get().hashCode()) : -1;
                result = a.apply(message);
                switch (eventPublication) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case ALWAYS: 
                    case DEFAULT: {
                        break;
                    }
                    case IF_MODIFIED: {
                        if (!Objects.equals(a.get(), result.get()) || result.get() != null && result.get().hashCode() != hashCodeBefore) {
                            break;
                        }
                        break block9;
                    }
                    case NEVER: {
                        break block9;
                    }
                }
                Message intercepted = this.dispatchInterceptor.interceptDispatch(message, MessageType.EVENT, null);
                if (intercepted == null) {
                    return a;
                }
                EventPublicationStrategy publicationStrategy = applyAnnotation.map(Apply::publicationStrategy).filter(ep -> ep != EventPublicationStrategy.DEFAULT).orElse(this.aggregatePublicationStrategy);
                Message m = publicationStrategy == EventPublicationStrategy.PUBLISH_ONLY ? intercepted.addMetadata("$aggregateId", this.id().toString(), "$aggregateType", this.type().getName()) : intercepted.addMetadata("$aggregateId", this.id().toString(), "$aggregateType", this.type().getName(), "$sequenceNumber", String.valueOf(this.getDelegate().sequenceNumber() + 1L));
                SerializedMessage serializedEvent = this.dispatchInterceptor.modifySerializedMessage(m.serialize(this.serializer), m, MessageType.EVENT, null);
                if (serializedEvent == null) {
                    return a;
                }
                this.applied.add(new AppliedEvent(new DeserializingMessage(serializedEvent, type -> this.serializer.convert(m.getPayload(), type), MessageType.EVENT, null), publicationStrategy));
            }
            return result;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Entity<T> handleUpdate(UnaryOperator<Entity<T>> update) {
        if (this.updating) {
            this.queued.add(update);
            return this;
        }
        try {
            this.updating = true;
            boolean firstUpdate = this.waitingForHandlerEnd.compareAndSet(false, true);
            if (firstUpdate) {
                activeAggregates.get().putIfAbsent(this.id(), this);
            }
            try {
                this.delegate = (Entity)update.apply(this.getDelegate());
            }
            finally {
                if (firstUpdate) {
                    Invocation.whenHandlerCompletes((r, e) -> this.whenHandlerCompletes((Throwable)e));
                }
            }
        }
        finally {
            this.updating = false;
        }
        while (!this.queued.isEmpty()) {
            this.queued.removeFirst().apply(this);
        }
        return this;
    }

    protected void whenHandlerCompletes(Throwable error) {
        this.waitingForHandlerEnd.set(false);
        if (error == null) {
            this.uncommitted.addAll(this.applied);
            this.lastStable = this.delegate;
        } else {
            this.delegate = this.lastStable;
        }
        this.applied.clear();
        if (!this.commitInBatch) {
            this.commit();
            activeAggregates.get().remove(this.id(), this);
        } else if (this.waitingForBatchEnd.compareAndSet(false, true)) {
            DeserializingMessage.whenBatchCompletes((ThrowingConsumer<Throwable>)((ThrowingConsumer)this::whenBatchCompletes));
        }
    }

    protected void whenBatchCompletes(Throwable error) {
        this.waitingForBatchEnd.set(false);
        this.commit();
        activeAggregates.get().remove(this.id(), this);
    }

    @Override
    public Entity<T> commit() {
        if (this.committing) {
            this.commitPending = true;
            return this;
        }
        try {
            this.committing = true;
            this.commitPending = false;
            this.uncommitted.addAll(this.applied);
            this.applied.clear();
            this.lastStable = this.delegate;
            ArrayList<AppliedEvent> events = new ArrayList<AppliedEvent>(this.uncommitted);
            this.uncommitted.clear();
            Entity<T> before = this.lastCommitted;
            this.lastCommitted = this.lastStable;
            this.commitHandler.handle(this.lastStable, events, before);
        }
        finally {
            this.committing = false;
        }
        while (this.commitPending) {
            this.commit();
        }
        return this;
    }

    @Override
    public Collection<? extends Entity<?>> entities() {
        return super.entities().stream().map(e -> new ModifiableEntity(e, this)).collect(Collectors.toList());
    }

    @Override
    public Entity<T> previous() {
        Entity previous = this.getDelegate().previous();
        return previous == null ? null : new ModifiableEntity(previous, this);
    }

    @Override
    @Generated
    public String toString() {
        return "ModifiableAggregateRoot()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModifiableAggregateRoot)) {
            return false;
        }
        ModifiableAggregateRoot other = (ModifiableAggregateRoot)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ModifiableAggregateRoot;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @FunctionalInterface
    public static interface CommitHandler {
        public void handle(Entity<?> var1, List<AppliedEvent> var2, Entity<?> var3);
    }
}

