/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.search;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.api.Metadata;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;

public interface IndexOperation {
    default public CompletableFuture<Void> index() {
        return this.index(Guarantee.STORED);
    }

    default public void indexAndForget() {
        this.index(Guarantee.NONE);
    }

    default public void indexAndWait() {
        this.indexAndWait(Guarantee.STORED);
    }

    default public void indexAndWait(Guarantee guarantee) {
        this.index(guarantee).get();
    }

    public CompletableFuture<Void> index(Guarantee var1);

    public IndexOperation id(@NonNull Object var1);

    public IndexOperation collection(@NonNull Object var1);

    public IndexOperation start(Instant var1);

    public IndexOperation end(Instant var1);

    default public IndexOperation timestamp(Instant timestamp) {
        return this.start(timestamp).end(timestamp);
    }

    default public IndexOperation period(Instant start, Instant end) {
        return this.start(start).end(end);
    }

    default public IndexOperation addMetadata(@NonNull Metadata metadata) {
        if (metadata == null) {
            throw new NullPointerException("metadata is marked non-null but is null");
        }
        return this.metadata(this.metadata().with(metadata));
    }

    default public IndexOperation addMetadata(@NonNull Object key, Object value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.metadata(this.metadata().with(key, value));
    }

    default public IndexOperation addMetadata(@NonNull Map<String, ?> values) {
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        return this.metadata(this.metadata().with(values));
    }

    public IndexOperation metadata(Metadata var1);

    public IndexOperation ifNotExists(boolean var1);

    public Instant start();

    public Instant end();

    public Object id();

    public Metadata metadata();

    public boolean ifNotExists();

    public IndexOperation copy();
}

