/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.search.client;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.api.search.CreateAuditTrail;
import io.fluxcapacitor.common.api.search.DocumentStats;
import io.fluxcapacitor.common.api.search.DocumentUpdate;
import io.fluxcapacitor.common.api.search.FacetStats;
import io.fluxcapacitor.common.api.search.GetDocument;
import io.fluxcapacitor.common.api.search.GetSearchHistogram;
import io.fluxcapacitor.common.api.search.HasDocument;
import io.fluxcapacitor.common.api.search.SearchDocuments;
import io.fluxcapacitor.common.api.search.SearchHistogram;
import io.fluxcapacitor.common.api.search.SearchQuery;
import io.fluxcapacitor.common.api.search.SerializedDocument;
import io.fluxcapacitor.javaclient.persisting.search.SearchHit;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;

public interface SearchClient
extends AutoCloseable {
    public CompletableFuture<Void> index(List<SerializedDocument> var1, Guarantee var2, boolean var3);

    public Stream<SearchHit<SerializedDocument>> search(SearchDocuments var1, int var2);

    public boolean documentExists(HasDocument var1);

    public Optional<SerializedDocument> fetch(GetDocument var1);

    public CompletableFuture<Void> delete(SearchQuery var1, Guarantee var2);

    public CompletableFuture<Void> delete(String var1, String var2, Guarantee var3);

    public CompletableFuture<Void> createAuditTrail(CreateAuditTrail var1);

    default public CompletableFuture<Void> deleteCollection(String collection) {
        return this.deleteCollection(collection, Guarantee.STORED);
    }

    public CompletableFuture<Void> deleteCollection(String var1, Guarantee var2);

    public List<DocumentStats> fetchStatistics(SearchQuery var1, List<String> var2, List<String> var3);

    public SearchHistogram fetchHistogram(GetSearchHistogram var1);

    public List<FacetStats> fetchFacetStats(SearchQuery var1);

    public CompletableFuture<Void> bulkUpdate(Collection<DocumentUpdate> var1, Guarantee var2);

    @Override
    public void close();
}

