/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.scheduling;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.configuration.ApplicationProperties;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import io.fluxcapacitor.javaclient.scheduling.CancelPeriodic;
import io.fluxcapacitor.javaclient.scheduling.CronExpression;
import io.fluxcapacitor.javaclient.scheduling.Periodic;
import io.fluxcapacitor.javaclient.scheduling.Schedule;
import io.fluxcapacitor.javaclient.tracking.IndexUtils;
import io.fluxcapacitor.javaclient.tracking.handling.HandleSchedule;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerInterceptor;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.User;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulingInterceptor
implements DispatchInterceptor,
HandlerInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchedulingInterceptor.class);
    private static final Function<String, Optional<CronExpression>> cronExpression = ObjectUtils.memoize(pattern -> "-".equals(pattern = ApplicationProperties.substituteProperties(pattern)) ? Optional.empty() : Optional.of(CronExpression.parseCronExpression(pattern)));

    @Override
    public Handler<DeserializingMessage> wrap(Handler<DeserializingMessage> handler) {
        List methods = ReflectionUtils.getAnnotatedMethods((Class)handler.getTargetClass(), HandleSchedule.class);
        for (Method method : methods) {
            Periodic periodic = method.getAnnotation(Periodic.class);
            if (method.getParameterCount() <= 0) continue;
            Class<?> type = method.getParameters()[0].getType();
            periodic = periodic == null ? (Periodic)ReflectionUtils.getTypeAnnotation(type, Periodic.class) : periodic;
            try {
                this.initializePeriodicSchedule(type, periodic);
            }
            catch (Exception e) {
                log.error("Failed to initialize periodic schedule on method {}. Continuing...", (Object)method, (Object)e);
            }
        }
        return HandlerInterceptor.super.wrap(handler);
    }

    protected void initializePeriodicSchedule(Class<?> payloadType, Periodic periodic) {
        if (periodic == null) {
            return;
        }
        if (periodic.cron().isBlank() && periodic.delay() <= 0L) {
            throw new IllegalStateException(String.format("Periodic annotation on type %s is invalid. Period should be a positive number of  milliseconds.", payloadType));
        }
        if (periodic.autoStart()) {
            Object payload;
            FluxCapacitor fluxCapacitor = FluxCapacitor.get();
            Instant firstDeadline = this.firstDeadline(periodic, fluxCapacitor.clock().instant());
            if (firstDeadline == null) {
                return;
            }
            String scheduleId = periodic.scheduleId().isEmpty() ? payloadType.getName() : periodic.scheduleId();
            try {
                payload = ((Constructor)ReflectionUtils.ensureAccessible(payloadType.getConstructor(new Class[0]))).newInstance(new Object[0]);
            }
            catch (Exception e) {
                log.error("No default constructor found on @Periodic type: {}. Add a public default constructor or initialize this periodic schedule by hand", payloadType, (Object)e);
                return;
            }
            Metadata metadata = Optional.ofNullable(fluxCapacitor.userProvider()).flatMap(p -> Optional.ofNullable(p.getSystemUser()).map(u -> p.addToMetadata(Metadata.empty(), (User)u))).orElse(Metadata.empty());
            fluxCapacitor.scheduler().schedule(new Schedule(payload, metadata, scheduleId, firstDeadline), true);
        }
    }

    protected Instant firstDeadline(Periodic periodic, Instant now) {
        if (periodic.initialDelay() >= 0L) {
            return now.plusMillis(periodic.timeUnit().toMillis(periodic.initialDelay()));
        }
        return this.nextDeadline(periodic, now);
    }

    protected Instant nextDeadline(Periodic periodic, Instant now) {
        if (periodic.cron().isBlank()) {
            return now.plusMillis(periodic.timeUnit().toMillis(periodic.delay()));
        }
        return cronExpression.apply(periodic.cron()).map(e -> e.nextTimeAfter(now.atZone(ZoneId.of(periodic.timeZone()))).toInstant()).orElse(null);
    }

    @Override
    public Message interceptDispatch(Message message, MessageType messageType, String topic) {
        if (messageType == MessageType.SCHEDULE) {
            message = message.withMetadata(message.getMetadata().with((Object)Schedule.scheduleIdMetadataKey, (Object)((Schedule)message).getScheduleId()));
        }
        return message;
    }

    @Override
    public Function<DeserializingMessage, Object> interceptHandling(Function<DeserializingMessage, Object> function, HandlerInvoker invoker) {
        return schedule -> {
            if (schedule.getMessageType() == MessageType.SCHEDULE) {
                Object result;
                long deadline = IndexUtils.millisFromIndex(schedule.getIndex());
                Periodic periodic = Optional.ofNullable(invoker.getMethod()).map(method -> method.getAnnotation(Periodic.class)).or(() -> Optional.ofNullable((Periodic)ReflectionUtils.getTypeAnnotation(schedule.getPayloadClass(), Periodic.class))).orElse(null);
                if (periodic != null && !periodic.cron().isBlank() && cronExpression.apply(periodic.cron()).isEmpty()) {
                    log.warn("Periodic scheduling is disabled for {}. Ignoring schedule {}.", schedule.getPayloadClass(), (Object)schedule.getMessageId());
                    return null;
                }
                Instant now = Instant.ofEpochMilli(deadline);
                try {
                    result = function.apply((DeserializingMessage)schedule);
                }
                catch (Throwable e) {
                    return this.handleExceptionalResult(e, (DeserializingMessage)schedule, now, periodic);
                }
                return this.handleResult(result, (DeserializingMessage)schedule, now, periodic);
            }
            return function.apply((DeserializingMessage)schedule);
        };
    }

    protected Object handleResult(Object result, DeserializingMessage schedule, Instant now, Periodic periodic) {
        if (result instanceof CompletionStage) {
            CompletionStage f = (CompletionStage)result;
            f.whenComplete((r, e) -> {
                if (e == null) {
                    this.handleResult(r, schedule, now, periodic);
                } else {
                    try {
                        this.handleExceptionalResult((Throwable)e, schedule, now, periodic);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            return result;
        }
        if (result instanceof TemporalAmount) {
            this.schedule(schedule, now.plus((TemporalAmount)result));
        } else if (result instanceof TemporalAccessor) {
            this.schedule(schedule, Instant.from((TemporalAccessor)result));
        } else if (result instanceof Schedule) {
            this.schedule((Schedule)result);
        } else if (result != null) {
            Metadata metadata = schedule.getMetadata();
            Object nextPayload = result;
            if (result instanceof Message) {
                metadata = ((Message)result).getMetadata();
                nextPayload = ((Message)result).getPayload();
            }
            if (nextPayload != null && schedule.getPayloadClass().isAssignableFrom(nextPayload.getClass())) {
                if (periodic == null) {
                    Instant dispatched = schedule.getTimestamp();
                    Duration previousDelay = Duration.between(dispatched, now);
                    if (previousDelay.compareTo(Duration.ZERO) > 0) {
                        this.schedule(nextPayload, metadata, now.plus(previousDelay));
                    } else {
                        log.info("Delay between the time this schedule was created and scheduled is <= 0, rescheduling with delay of 1 minute");
                        this.schedule(nextPayload, metadata, now.plus(Duration.of(1L, ChronoUnit.MINUTES)));
                    }
                } else {
                    this.schedule(nextPayload, metadata, this.nextDeadline(periodic, now));
                }
            } else if (periodic != null) {
                this.schedule(schedule, this.nextDeadline(periodic, now));
            }
        } else if (periodic != null) {
            this.schedule(schedule, this.nextDeadline(periodic, now));
        }
        return result;
    }

    protected Object handleExceptionalResult(Throwable result, DeserializingMessage schedule, Instant now, Periodic periodic) {
        if (result instanceof CancelPeriodic) {
            String scheduleId = Optional.ofNullable(schedule.getMetadata().get((Object)Schedule.scheduleIdMetadataKey)).or(() -> Optional.ofNullable(periodic).map(Periodic::scheduleId)).orElseGet(() -> schedule.getPayloadClass().getName());
            log.info("Periodic schedule {} will be cancelled.", (Object)scheduleId);
            FluxCapacitor.get().scheduler().cancelSchedule(scheduleId);
            return null;
        }
        if (periodic != null && periodic.continueOnError()) {
            if (periodic.delayAfterError() >= 0L) {
                this.schedule(schedule, now.plusMillis(periodic.timeUnit().toMillis(periodic.delayAfterError())));
            } else {
                this.schedule(schedule, this.nextDeadline(periodic, now));
            }
        }
        throw result;
    }

    private void schedule(DeserializingMessage message, Instant instant) {
        this.schedule(message.getPayload(), message.getMetadata(), instant);
    }

    private void schedule(Object payload, Metadata metadata, Instant instant) {
        if (instant != null) {
            this.schedule(new Schedule(payload, metadata, metadata.getOrDefault((Object)Schedule.scheduleIdMetadataKey, FluxCapacitor.currentIdentityProvider().nextTechnicalId()), instant));
        }
    }

    private void schedule(Schedule schedule) {
        try {
            FluxCapacitor.get().scheduler().schedule(schedule);
        }
        catch (Exception e) {
            log.error("Failed to reschedule a {}", schedule.getPayloadClass(), (Object)e);
        }
    }
}

