/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling;

import io.fluxcapacitor.common.MemoizingSupplier;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.handling.DefaultHandler;
import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.common.handling.HandlerConfiguration;
import io.fluxcapacitor.common.handling.HandlerFilter;
import io.fluxcapacitor.common.handling.HandlerInspector;
import io.fluxcapacitor.common.handling.HandlerMatcher;
import io.fluxcapacitor.common.handling.MessageFilter;
import io.fluxcapacitor.common.handling.ParameterResolver;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.common.ClientUtils;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.modeling.HandlerRepository;
import io.fluxcapacitor.javaclient.tracking.TrackSelf;
import io.fluxcapacitor.javaclient.tracking.handling.HandleCommand;
import io.fluxcapacitor.javaclient.tracking.handling.HandleCustom;
import io.fluxcapacitor.javaclient.tracking.handling.HandleCustomFilter;
import io.fluxcapacitor.javaclient.tracking.handling.HandleDocument;
import io.fluxcapacitor.javaclient.tracking.handling.HandleDocumentFilter;
import io.fluxcapacitor.javaclient.tracking.handling.HandleError;
import io.fluxcapacitor.javaclient.tracking.handling.HandleEvent;
import io.fluxcapacitor.javaclient.tracking.handling.HandleMetrics;
import io.fluxcapacitor.javaclient.tracking.handling.HandleNotification;
import io.fluxcapacitor.javaclient.tracking.handling.HandleQuery;
import io.fluxcapacitor.javaclient.tracking.handling.HandleResult;
import io.fluxcapacitor.javaclient.tracking.handling.HandleSchedule;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerDecorator;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerFactory;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerInterceptor;
import io.fluxcapacitor.javaclient.tracking.handling.PayloadFilter;
import io.fluxcapacitor.javaclient.tracking.handling.SegmentFilter;
import io.fluxcapacitor.javaclient.tracking.handling.Stateful;
import io.fluxcapacitor.javaclient.tracking.handling.StatefulHandler;
import io.fluxcapacitor.javaclient.web.HandleWeb;
import io.fluxcapacitor.javaclient.web.HandleWebResponse;
import io.fluxcapacitor.javaclient.web.WebHandlerMatcher;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;

public class DefaultHandlerFactory
implements HandlerFactory {
    private final MessageType messageType;
    private final HandlerDecorator defaultDecorator;
    private final List<ParameterResolver<? super DeserializingMessage>> parameterResolvers;
    private final MessageFilter<? super DeserializingMessage> messageFilter;
    private final Class<? extends Annotation> handlerAnnotation;
    private final Function<Class<?>, HandlerRepository> handlerRepositorySupplier;

    public DefaultHandlerFactory(MessageType messageType, HandlerDecorator defaultDecorator, List<ParameterResolver<? super DeserializingMessage>> parameterResolvers, Function<Class<?>, HandlerRepository> handlerRepositorySupplier) {
        this.messageType = messageType;
        this.defaultDecorator = defaultDecorator;
        this.parameterResolvers = parameterResolvers;
        this.handlerRepositorySupplier = handlerRepositorySupplier;
        this.handlerAnnotation = this.getHandlerAnnotation(messageType);
        this.messageFilter = this.computeMessageFilter();
    }

    @Override
    public Optional<Handler<DeserializingMessage>> createHandler(Object target, HandlerFilter handlerFilter, List<HandlerInterceptor> extraInterceptors) {
        Class<?> targetClass = HandlerFactory.getTargetClass(target);
        HandlerDecorator handlerDecorator = (HandlerDecorator)ObjectUtils.concat((Stream[])new Stream[]{extraInterceptors.stream(), Stream.of(this.defaultDecorator)}).reduce(HandlerDecorator::andThen).orElseThrow();
        return Optional.of(this.handlerAnnotation).map(a -> HandlerConfiguration.builder().methodAnnotation(a).handlerFilter(handlerFilter).messageFilter(this.messageFilter).build()).filter(config -> HandlerInspector.hasHandlerMethods((Class)targetClass, (HandlerConfiguration)config)).map(config -> this.buildHandler(target, (HandlerConfiguration<DeserializingMessage>)config)).map(handlerDecorator::wrap);
    }

    protected Handler<DeserializingMessage> buildHandler(@NonNull Object target, HandlerConfiguration<DeserializingMessage> config) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        Class clazz = ReflectionUtils.ifClass((Object)target);
        if (clazz instanceof Class) {
            Class targetClass = clazz;
            Stateful handler = (Stateful)ReflectionUtils.getTypeAnnotation((Class)targetClass, Stateful.class);
            if (handler != null) {
                return new StatefulHandler(targetClass, this.createHandlerMatcher(targetClass, config), this.handlerRepositorySupplier.apply(targetClass));
            }
            Optional<Annotation> trackSelf = Optional.ofNullable(ReflectionUtils.getTypeAnnotation((Class)targetClass, TrackSelf.class)).or(() -> Optional.ofNullable(targetClass.getPackage()).flatMap(p -> ReflectionUtils.getPackageAnnotation((Package)p, TrackSelf.class)));
            if (trackSelf.isPresent()) {
                MessageFilter selfFilter = (message, method, handlerAnnotation) -> targetClass.isAssignableFrom(message.getPayloadClass());
                config = config.toBuilder().messageFilter(selfFilter.and(config.messageFilter())).build();
                return this.createDefaultHandler(targetClass, DeserializingMessage::getPayload, (HandlerConfiguration<DeserializingMessage>)config);
            }
            MemoizingSupplier<Object> instanceSupplier = ClientUtils.memoize(() -> ReflectionUtils.asInstance((Object)targetClass));
            return this.createDefaultHandler(targetClass, m -> targetClass.equals(m.getPayloadClass()) ? m.getPayload() : instanceSupplier.get(), config);
        }
        return this.createDefaultHandler(target.getClass(), m -> target, config);
    }

    protected Handler<DeserializingMessage> createDefaultHandler(Class<?> targetClass, Function<DeserializingMessage, ?> targetSupplier, HandlerConfiguration<DeserializingMessage> config) {
        return new DefaultHandler(targetClass, targetSupplier, this.createHandlerMatcher(targetClass, config));
    }

    protected Class<? extends Annotation> getHandlerAnnotation(MessageType messageType) {
        return switch (messageType) {
            default -> throw new MatchException(null, null);
            case MessageType.COMMAND -> HandleCommand.class;
            case MessageType.EVENT -> HandleEvent.class;
            case MessageType.NOTIFICATION -> HandleNotification.class;
            case MessageType.QUERY -> HandleQuery.class;
            case MessageType.RESULT -> HandleResult.class;
            case MessageType.ERROR -> HandleError.class;
            case MessageType.SCHEDULE -> HandleSchedule.class;
            case MessageType.METRICS -> HandleMetrics.class;
            case MessageType.WEBREQUEST -> HandleWeb.class;
            case MessageType.WEBRESPONSE -> HandleWebResponse.class;
            case MessageType.DOCUMENT -> HandleDocument.class;
            case MessageType.CUSTOM -> HandleCustom.class;
        };
    }

    protected HandlerMatcher<Object, DeserializingMessage> createHandlerMatcher(Class<?> targetClass, HandlerConfiguration<DeserializingMessage> config) {
        return switch (this.messageType) {
            case MessageType.WEBREQUEST -> WebHandlerMatcher.create(targetClass, this.parameterResolvers, config);
            default -> HandlerInspector.inspect(targetClass, this.parameterResolvers, config);
        };
    }

    protected MessageFilter<? super DeserializingMessage> computeMessageFilter() {
        MessageFilter defaultFilter = new PayloadFilter().and(new SegmentFilter());
        MessageFilter result = switch (this.messageType) {
            case MessageType.CUSTOM -> defaultFilter.and((MessageFilter)new HandleCustomFilter());
            case MessageType.DOCUMENT -> defaultFilter.and((MessageFilter)new HandleDocumentFilter());
            default -> defaultFilter;
        };
        return this.parameterResolvers.stream().flatMap(r -> r instanceof MessageFilter ? Stream.of((MessageFilter)r) : Stream.empty()).reduce(MessageFilter::and).map(f -> f.and(result)).orElse(result);
    }

    @ConstructorProperties(value={"messageType", "defaultDecorator", "parameterResolvers", "messageFilter", "handlerAnnotation", "handlerRepositorySupplier"})
    @Generated
    public DefaultHandlerFactory(MessageType messageType, HandlerDecorator defaultDecorator, List<ParameterResolver<? super DeserializingMessage>> parameterResolvers, MessageFilter<? super DeserializingMessage> messageFilter, Class<? extends Annotation> handlerAnnotation, Function<Class<?>, HandlerRepository> handlerRepositorySupplier) {
        this.messageType = messageType;
        this.defaultDecorator = defaultDecorator;
        this.parameterResolvers = parameterResolvers;
        this.messageFilter = messageFilter;
        this.handlerAnnotation = handlerAnnotation;
        this.handlerRepositorySupplier = handlerRepositorySupplier;
    }
}

