/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling;

import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.common.ClientUtils;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.modeling.SearchParameters;
import io.fluxcapacitor.javaclient.persisting.search.DocumentStore;
import io.fluxcapacitor.javaclient.tracking.handling.HandleDocument;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerDecorator;
import java.beans.ConstructorProperties;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.time.Instant;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;

public class DocumentHandlerDecorator
implements HandlerDecorator {
    static final Function<Executable, Optional<String>> collectionSupplier = ClientUtils.memoize(m -> ReflectionUtils.getMethodAnnotation((Executable)m, HandleDocument.class).map(a -> ClientUtils.getTopic(a, m)));
    private final Supplier<DocumentStore> documentStoreSupplier;

    @Override
    public Handler<DeserializingMessage> wrap(Handler<DeserializingMessage> handler) {
        return new DocumentHandler(handler);
    }

    @ConstructorProperties(value={"documentStoreSupplier"})
    @Generated
    public DocumentHandlerDecorator(Supplier<DocumentStore> documentStoreSupplier) {
        this.documentStoreSupplier = documentStoreSupplier;
    }

    protected class DocumentHandler
    implements Handler<DeserializingMessage> {
        private final Handler<DeserializingMessage> delegate;

        public Optional<HandlerInvoker> getInvoker(DeserializingMessage message) {
            return this.delegate.getInvoker((Object)message).flatMap(i -> {
                Method m;
                Executable patt0$temp;
                return !i.isPassive() && (patt0$temp = i.getMethod()) instanceof Method && (m = (Method)patt0$temp).getReturnType().isAssignableFrom(message.getPayloadClass()) ? collectionSupplier.apply(i.getMethod()).map(topic -> new DocumentHandlerInvoker((HandlerInvoker)i, (String)topic, message)) : Optional.of(i);
            });
        }

        public Class<?> getTargetClass() {
            return this.delegate.getTargetClass();
        }

        @ConstructorProperties(value={"delegate"})
        @Generated
        public DocumentHandler(Handler<DeserializingMessage> delegate) {
            this.delegate = delegate;
        }

        protected class DocumentHandlerInvoker
        extends HandlerInvoker.DelegatingHandlerInvoker {
            private final DeserializingMessage message;
            private final String collection;

            public DocumentHandlerInvoker(HandlerInvoker delegate, String collection, DeserializingMessage message) {
                super(delegate);
                this.message = message;
                this.collection = collection;
            }

            public Object invoke(BiFunction<Object, Object, Object> combiner) {
                Object result = this.delegate.invoke(combiner);
                this.handleResult(result);
                return result;
            }

            private void handleResult(Object result) {
                DocumentStore store = DocumentHandlerDecorator.this.documentStoreSupplier.get();
                if (result == null) {
                    store.deleteDocument(this.message.getMessageId(), this.collection);
                } else if (ClientUtils.getRevisionNumber(result) > this.message.getSerializedObject().getOriginalRevision()) {
                    SearchParameters searchParams;
                    SearchParameters searchParameters = ClientUtils.getSearchParameters(result.getClass());
                    if (searchParameters instanceof SearchParameters && ((searchParams = searchParameters).getTimestampPath() != null || searchParams.getEndPath() != null)) {
                        store.index(result, (Object)this.message.getMessageId(), this.collection);
                    } else {
                        Instant start = Optional.ofNullable(this.message.getMetadata().get((Object)"$start")).map(Long::valueOf).map(Instant::ofEpochMilli).orElse(null);
                        Instant end = Optional.ofNullable(this.message.getMetadata().get((Object)"$end")).map(Long::valueOf).map(Instant::ofEpochMilli).orElse(null);
                        store.index(result, (Object)this.message.getMessageId(), (Object)this.collection, start, end);
                    }
                }
            }
        }
    }
}

