/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.common.handling.HandlerFilter;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.ClientUtils;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerFactory;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerRegistry;
import io.fluxcapacitor.javaclient.tracking.handling.Invocation;
import io.fluxcapacitor.javaclient.tracking.handling.LocalHandler;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalHandlerRegistry
implements HandlerRegistry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalHandlerRegistry.class);
    private final HandlerFactory handlerFactory;
    private final List<Handler<DeserializingMessage>> localHandlers = new CopyOnWriteArrayList<Handler<DeserializingMessage>>();
    @NonNull
    private HandlerFilter selfHandlerFilter = (t, m) -> !ClientUtils.isSelfTracking(t, m);
    private final Function<Class<?>, Optional<Handler<DeserializingMessage>>> selfHandlers = ObjectUtils.memoize(payloadType -> this.getHandlerFactory().createHandler(payloadType, this.getSelfHandlerFilter(), List.of()));

    @Override
    public boolean hasLocalHandlers() {
        return !this.localHandlers.isEmpty();
    }

    @Override
    public Registration registerHandler(Object target, HandlerFilter handlerFilter) {
        if (target instanceof Handler) {
            this.localHandlers.add((Handler<DeserializingMessage>)((Handler)target));
            return () -> this.localHandlers.remove(target);
        }
        Optional<Handler<DeserializingMessage>> handler = this.handlerFactory.createHandler(target, handlerFilter, Collections.emptyList());
        handler.ifPresent(this.localHandlers::add);
        return () -> handler.ifPresent(this.localHandlers::remove);
    }

    @Override
    public Optional<CompletableFuture<Object>> handle(DeserializingMessage message) {
        List<Handler<DeserializingMessage>> localHandlers = this.getLocalHandlers(message);
        if (localHandlers.isEmpty()) {
            return Optional.empty();
        }
        return message.apply(m -> {
            boolean handled = false;
            boolean logMessage = false;
            boolean request = m.getMessageType().isRequest();
            CompletableFuture future = new CompletableFuture();
            for (Handler handler : localHandlers) {
                Optional optionalInvoker = handler.getInvoker(m);
                if (!optionalInvoker.isPresent()) continue;
                HandlerInvoker invoker = (HandlerInvoker)optionalInvoker.get();
                boolean passive = invoker.isPassive();
                if (handled && request && !passive) continue;
                try {
                    Object result = Invocation.performInvocation(() -> ((HandlerInvoker)invoker).invoke());
                    if (!passive && !future.isDone()) {
                        if (result instanceof CompletableFuture) {
                            future = (CompletableFuture)result;
                        } else {
                            future.complete(result);
                        }
                    }
                    if (!passive) {
                        handled = true;
                    }
                    logMessage = logMessage || this.logMessage(invoker);
                }
                catch (Throwable e) {
                    try {
                        if (passive) {
                            log.error("Passive handler {} failed to handle a {}", new Object[]{invoker, m.getPayloadClass(), e});
                        } else {
                            future.completeExceptionally(e);
                        }
                        if (!passive) {
                            handled = true;
                        }
                        logMessage = logMessage || this.logMessage(invoker);
                    }
                    catch (Throwable throwable) {
                        if (!passive) {
                            handled = true;
                        }
                        logMessage = logMessage || this.logMessage(invoker);
                        throw throwable;
                    }
                }
            }
            try {
                Optional optional = handled ? Optional.of(future) : Optional.empty();
                return optional;
            }
            finally {
                if (logMessage) {
                    FluxCapacitor.getOptionally().ifPresent(fc -> fc.client().getGatewayClient(m.getMessageType()).append(Guarantee.NONE, message.getSerializedObject()));
                }
            }
        });
    }

    protected List<Handler<DeserializingMessage>> getLocalHandlers(DeserializingMessage message) {
        if (!message.getMessageType().isRequest()) {
            return this.localHandlers;
        }
        return message.apply(m -> this.selfHandlers.apply(m.getPayloadClass()).map(h -> Stream.concat(this.localHandlers.stream(), Stream.of(h)).toList()).orElse(this.localHandlers));
    }

    protected boolean logMessage(HandlerInvoker invoker) {
        return ClientUtils.getLocalHandlerAnnotation(invoker.getTargetClass(), invoker.getMethod()).map(LocalHandler::logMessage).orElse(false);
    }

    @ConstructorProperties(value={"handlerFactory"})
    @Generated
    public LocalHandlerRegistry(HandlerFactory handlerFactory) {
        this.handlerFactory = handlerFactory;
    }

    @Generated
    public HandlerFactory getHandlerFactory() {
        return this.handlerFactory;
    }

    @Generated
    public List<Handler<DeserializingMessage>> getLocalHandlers() {
        return this.localHandlers;
    }

    @Override
    @Generated
    public void setSelfHandlerFilter(@NonNull HandlerFilter selfHandlerFilter) {
        if (selfHandlerFilter == null) {
            throw new NullPointerException("selfHandlerFilter is marked non-null but is null");
        }
        this.selfHandlerFilter = selfHandlerFilter;
    }

    @NonNull
    @Generated
    public HandlerFilter getSelfHandlerFilter() {
        return this.selfHandlerFilter;
    }
}

