/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling;

import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.common.handling.HandlerMatcher;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.common.ClientUtils;
import io.fluxcapacitor.javaclient.common.Entry;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.modeling.EntityId;
import io.fluxcapacitor.javaclient.modeling.HandlerRepository;
import io.fluxcapacitor.javaclient.modeling.Id;
import io.fluxcapacitor.javaclient.publishing.routing.RoutingKey;
import io.fluxcapacitor.javaclient.tracking.Tracker;
import io.fluxcapacitor.javaclient.tracking.handling.Association;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatefulHandler
implements Handler<DeserializingMessage> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatefulHandler.class);
    private final Class<?> targetClass;
    private final HandlerMatcher<Object, DeserializingMessage> handlerMatcher;
    private final HandlerRepository repository;
    private final AtomicReference<Object> associationProperties = new AtomicReference();
    private final Function<Executable, Map<String, AssociationValue>> methodAssociationProperties = ClientUtils.memoize(m -> ReflectionUtils.getAnnotation((AnnotatedElement)m, Association.class).map(association -> {
        Map associations = Arrays.stream(association.value()).collect(Collectors.toMap(Function.identity(), v -> AssociationValue.valueOf(association), (a, b) -> a));
        if (associations.isEmpty()) {
            log.warn("@Association on {} does not define a property. This is probably a mistake.", m);
        }
        return associations;
    }).orElseGet(Collections::emptyMap));
    private final Function<Executable, Boolean> alwaysAssociateMethods = ClientUtils.memoize(m -> ReflectionUtils.getAnnotation((AnnotatedElement)m, Association.class).filter(Association::always).isPresent());

    public Optional<HandlerInvoker> getInvoker(DeserializingMessage message) {
        List<Entry> matches;
        boolean alwaysInvoke;
        if (!this.handlerMatcher.canHandle((Object)message)) {
            return Optional.empty();
        }
        boolean alwaysMatch = this.handlerMatcher.matchingMethods((Object)message).anyMatch(this.alwaysAssociateMethods::apply);
        boolean bl = alwaysInvoke = alwaysMatch && this.handlerMatcher.matchingMethods((Object)message).allMatch(ReflectionUtils::isStatic);
        Collection<Entry<Object>> collection = alwaysInvoke ? List.of() : (matches = alwaysMatch ? this.repository.getAll() : this.repository.findByAssociation(this.associations(message)));
        if (matches.isEmpty()) {
            return this.handlerMatcher.getInvoker(null, (Object)message).filter(i -> {
                if (this.alreadyFiltered((HandlerInvoker)i)) {
                    return true;
                }
                String routingKey = ReflectionUtils.getAnnotatedProperty(this.targetClass, EntityId.class).map(ReflectionUtils::getPropertyName).flatMap(message::getRoutingKey).orElseGet(message::getMessageId);
                return this.canTrackerHandle(message, routingKey);
            }).map(i -> new StatefulHandlerInvoker((HandlerInvoker)i, null, message));
        }
        ArrayList invokers = new ArrayList();
        for (Entry entry : matches) {
            this.handlerMatcher.getInvoker(entry.getValue(), (Object)message).filter(i -> this.alreadyFiltered((HandlerInvoker)i) || this.canTrackerHandle(message, entry.getId()) != false).map(i -> new StatefulHandlerInvoker((HandlerInvoker)i, entry, message)).ifPresent(invokers::add);
        }
        return HandlerInvoker.join(invokers);
    }

    protected boolean alreadyFiltered(HandlerInvoker i) {
        return ReflectionUtils.getMethodAnnotation((Executable)i.getMethod(), RoutingKey.class).isPresent();
    }

    protected Boolean canTrackerHandle(DeserializingMessage message, String routingKey) {
        return Tracker.current().filter(tracker -> tracker.getConfiguration().ignoreSegment()).map(tracker -> tracker.canHandle(message, routingKey)).orElse(true);
    }

    protected Map<Object, String> associations(DeserializingMessage message) {
        return Optional.ofNullable(message.getPayload()).stream().flatMap(payload -> Stream.concat(this.handlerMatcher.matchingMethods((Object)message).flatMap(e -> this.methodAssociationProperties.apply((Executable)e).entrySet().stream()), this.getAssociationProperties().entrySet().stream()).filter(entry -> this.includedPayload(payload, (AssociationValue)entry.getValue())).flatMap(entry -> ReflectionUtils.readProperty((String)((String)entry.getKey()), (Object)payload).or(() -> ((AssociationValue)entry.getValue()).isExcludeMetadata() ? Optional.empty() : Optional.ofNullable(message.getMetadata().get(entry.getKey()))).map(v -> {
            Object object;
            if (v instanceof Id) {
                Id id = (Id)v;
                object = id.getFunctionalId();
            } else {
                object = v;
            }
            return object;
        }).map(v -> Map.entry(v, ((AssociationValue)entry.getValue()).getPath())).stream())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a.isBlank() ? b : a));
    }

    protected boolean includedPayload(Object payload, AssociationValue association) {
        Class<?> payloadType = payload.getClass();
        if (!association.includedClasses.isEmpty() && association.includedClasses.stream().noneMatch(c -> c.isAssignableFrom(payloadType))) {
            return false;
        }
        return association.excludedClasses.stream().noneMatch(c -> c.isAssignableFrom(payloadType));
    }

    public String toString() {
        return "StatefulHandler[%s]".formatted(this.targetClass);
    }

    @Generated
    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    @Generated
    public HandlerMatcher<Object, DeserializingMessage> getHandlerMatcher() {
        return this.handlerMatcher;
    }

    @Generated
    public HandlerRepository getRepository() {
        return this.repository;
    }

    @Generated
    public Function<Executable, Map<String, AssociationValue>> getMethodAssociationProperties() {
        return this.methodAssociationProperties;
    }

    @Generated
    public Function<Executable, Boolean> getAlwaysAssociateMethods() {
        return this.alwaysAssociateMethods;
    }

    @ConstructorProperties(value={"targetClass", "handlerMatcher", "repository"})
    @Generated
    public StatefulHandler(Class<?> targetClass, HandlerMatcher<Object, DeserializingMessage> handlerMatcher, HandlerRepository repository) {
        this.targetClass = targetClass;
        this.handlerMatcher = handlerMatcher;
        this.repository = repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public Map<String, AssociationValue> getAssociationProperties() {
        Object $value = this.associationProperties.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.associationProperties;
            synchronized (atomicReference) {
                $value = this.associationProperties.get();
                if ($value == null) {
                    Map<String, AssociationValue> actualValue = ReflectionUtils.getAnnotatedProperties(this.getTargetClass(), Association.class).stream().flatMap(member -> ReflectionUtils.getAnnotation((AnnotatedElement)member, Association.class).stream().flatMap(association -> {
                        String propertyName = ReflectionUtils.getPropertyName((AccessibleObject)member);
                        return (association.value().length > 0 ? Arrays.stream(association.value()) : Stream.of(propertyName)).map(v -> {
                            AssociationValue associationValue = AssociationValue.valueOf(association);
                            if (associationValue.getPath().isBlank()) {
                                associationValue = associationValue.toBuilder().path(propertyName).build();
                            }
                            return Map.entry(v, associationValue);
                        });
                    })).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a));
                    $value = actualValue == null ? this.associationProperties : actualValue;
                    this.associationProperties.set($value);
                }
            }
        }
        return (Map)($value == this.associationProperties ? null : $value);
    }

    protected static final class AssociationValue {
        private final List<String> value;
        private final String path;
        private final List<Class<?>> includedClasses;
        private final List<Class<?>> excludedClasses;
        private final boolean excludeMetadata;
        private final boolean always;

        public static AssociationValue valueOf(Association association) {
            return (AssociationValue)ReflectionUtils.convertAnnotation((Annotation)association, AssociationValue.class);
        }

        public String getPath() {
            return this.path == null ? "" : this.path;
        }

        @ConstructorProperties(value={"value", "path", "includedClasses", "excludedClasses", "excludeMetadata", "always"})
        @Generated
        AssociationValue(List<String> value, String path, List<Class<?>> includedClasses, List<Class<?>> excludedClasses, boolean excludeMetadata, boolean always) {
            this.value = value;
            this.path = path;
            this.includedClasses = includedClasses;
            this.excludedClasses = excludedClasses;
            this.excludeMetadata = excludeMetadata;
            this.always = always;
        }

        @Generated
        public static AssociationValueBuilder builder() {
            return new AssociationValueBuilder();
        }

        @Generated
        public AssociationValueBuilder toBuilder() {
            return new AssociationValueBuilder().value(this.value).path(this.path).includedClasses(this.includedClasses).excludedClasses(this.excludedClasses).excludeMetadata(this.excludeMetadata).always(this.always);
        }

        @Generated
        public List<String> getValue() {
            return this.value;
        }

        @Generated
        public List<Class<?>> getIncludedClasses() {
            return this.includedClasses;
        }

        @Generated
        public List<Class<?>> getExcludedClasses() {
            return this.excludedClasses;
        }

        @Generated
        public boolean isExcludeMetadata() {
            return this.excludeMetadata;
        }

        @Generated
        public boolean isAlways() {
            return this.always;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AssociationValue)) {
                return false;
            }
            AssociationValue other = (AssociationValue)o;
            if (this.isExcludeMetadata() != other.isExcludeMetadata()) {
                return false;
            }
            if (this.isAlways() != other.isAlways()) {
                return false;
            }
            List<String> this$value = this.getValue();
            List<String> other$value = other.getValue();
            if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            List<Class<?>> this$includedClasses = this.getIncludedClasses();
            List<Class<?>> other$includedClasses = other.getIncludedClasses();
            if (this$includedClasses == null ? other$includedClasses != null : !((Object)this$includedClasses).equals(other$includedClasses)) {
                return false;
            }
            List<Class<?>> this$excludedClasses = this.getExcludedClasses();
            List<Class<?>> other$excludedClasses = other.getExcludedClasses();
            return !(this$excludedClasses == null ? other$excludedClasses != null : !((Object)this$excludedClasses).equals(other$excludedClasses));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isExcludeMetadata() ? 79 : 97);
            result = result * 59 + (this.isAlways() ? 79 : 97);
            List<String> $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            List<Class<?>> $includedClasses = this.getIncludedClasses();
            result = result * 59 + ($includedClasses == null ? 43 : ((Object)$includedClasses).hashCode());
            List<Class<?>> $excludedClasses = this.getExcludedClasses();
            result = result * 59 + ($excludedClasses == null ? 43 : ((Object)$excludedClasses).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "StatefulHandler.AssociationValue(value=" + String.valueOf(this.getValue()) + ", path=" + this.getPath() + ", includedClasses=" + String.valueOf(this.getIncludedClasses()) + ", excludedClasses=" + String.valueOf(this.getExcludedClasses()) + ", excludeMetadata=" + this.isExcludeMetadata() + ", always=" + this.isAlways() + ")";
        }

        @Generated
        public static class AssociationValueBuilder {
            @Generated
            private List<String> value;
            @Generated
            private String path;
            @Generated
            private List<Class<?>> includedClasses;
            @Generated
            private List<Class<?>> excludedClasses;
            @Generated
            private boolean excludeMetadata;
            @Generated
            private boolean always;

            @Generated
            AssociationValueBuilder() {
            }

            @Generated
            public AssociationValueBuilder value(List<String> value) {
                this.value = value;
                return this;
            }

            @Generated
            public AssociationValueBuilder path(String path) {
                this.path = path;
                return this;
            }

            @Generated
            public AssociationValueBuilder includedClasses(List<Class<?>> includedClasses) {
                this.includedClasses = includedClasses;
                return this;
            }

            @Generated
            public AssociationValueBuilder excludedClasses(List<Class<?>> excludedClasses) {
                this.excludedClasses = excludedClasses;
                return this;
            }

            @Generated
            public AssociationValueBuilder excludeMetadata(boolean excludeMetadata) {
                this.excludeMetadata = excludeMetadata;
                return this;
            }

            @Generated
            public AssociationValueBuilder always(boolean always) {
                this.always = always;
                return this;
            }

            @Generated
            public AssociationValue build() {
                return new AssociationValue(this.value, this.path, this.includedClasses, this.excludedClasses, this.excludeMetadata, this.always);
            }

            @Generated
            public String toString() {
                return "StatefulHandler.AssociationValue.AssociationValueBuilder(value=" + String.valueOf(this.value) + ", path=" + this.path + ", includedClasses=" + String.valueOf(this.includedClasses) + ", excludedClasses=" + String.valueOf(this.excludedClasses) + ", excludeMetadata=" + this.excludeMetadata + ", always=" + this.always + ")";
            }
        }
    }

    protected class StatefulHandlerInvoker
    extends HandlerInvoker.DelegatingHandlerInvoker {
        private final Entry<?> currentEntry;
        private final DeserializingMessage message;

        public StatefulHandlerInvoker(HandlerInvoker delegate, Entry<?> currentEntry, DeserializingMessage message) {
            super(delegate);
            this.currentEntry = currentEntry;
            this.message = message;
        }

        public Object invoke(BiFunction<Object, Object, Object> combiner) {
            Object result = this.delegate.invoke(combiner);
            this.handleResult(result);
            return result;
        }

        protected void handleResult(Object result) {
            Executable executable;
            if (result instanceof Collection) {
                Collection collection = (Collection)result;
                collection.forEach(this::handleResult);
            } else if (this.getTargetClass().isInstance(result)) {
                if (this.currentEntry == null || !Objects.equals(this.currentEntry.getValue(), result)) {
                    StatefulHandler.this.repository.put(this.computeId(result), result).get();
                }
            } else if (result == null && this.expectResult() && (executable = this.getMethod()) instanceof Method) {
                Method m = (Method)executable;
                if ((this.getTargetClass().isAssignableFrom(m.getReturnType()) || m.getReturnType().isAssignableFrom(this.getTargetClass())) && this.currentEntry != null) {
                    StatefulHandler.this.repository.delete(this.currentEntry.getId()).get();
                }
            }
        }

        protected Object computeId(Object handler) {
            return ReflectionUtils.getAnnotatedPropertyValue((Object)handler, EntityId.class).or(() -> Optional.ofNullable(this.currentEntry).map(Entry::getId)).orElseGet(this.message::getMessageId);
        }
    }
}

