/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.web;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.handling.ParameterResolver;
import io.fluxcapacitor.common.reflection.ParameterRegistry;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.common.HasMessage;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.web.DefaultWebRequestContext;
import io.fluxcapacitor.javaclient.web.WebParam;
import io.fluxcapacitor.javaclient.web.WebParameterSource;
import io.micrometer.common.util.StringUtils;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Parameter;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;

public class WebParamParameterResolver
implements ParameterResolver<HasMessage> {
    public Function<HasMessage, Object> resolve(Parameter p, Annotation methodAnnotation) {
        return m -> {
            DefaultWebRequestContext context = DefaultWebRequestContext.getWebRequestContext((DeserializingMessage)m);
            Optional field = ReflectionUtils.getAnnotationAs((AnnotatedElement)p, WebParam.class, ParamField.class);
            return field.map(f -> {
                String name;
                String value = f.getValue();
                if (StringUtils.isBlank((String)value)) {
                    if (p.isNamePresent()) {
                        name = p.getName();
                    } else {
                        ParameterRegistry registry = ParameterRegistry.of(p.getDeclaringExecutable().getDeclaringClass());
                        name = registry.getParameterName(p);
                    }
                } else {
                    name = value;
                }
                return context.getParameter(name, f.getType());
            }).map(v -> v.as(p.getType())).orElse(null);
        };
    }

    public boolean matches(Parameter parameter, Annotation methodAnnotation, HasMessage value) {
        DeserializingMessage m;
        return value instanceof DeserializingMessage && (m = (DeserializingMessage)value).getMessageType() == MessageType.WEBREQUEST && ReflectionUtils.isAnnotationPresent((Parameter)parameter, WebParam.class);
    }

    @Generated
    public WebParamParameterResolver() {
    }

    static final class ParamField {
        private final String value;
        private final WebParameterSource type;

        @ConstructorProperties(value={"value", "type"})
        @Generated
        public ParamField(String value, WebParameterSource type) {
            this.value = value;
            this.type = type;
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public WebParameterSource getType() {
            return this.type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamField)) {
                return false;
            }
            ParamField other = (ParamField)o;
            String this$value = this.getValue();
            String other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            WebParameterSource this$type = this.getType();
            WebParameterSource other$type = other.getType();
            return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            WebParameterSource $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WebParamParameterResolver.ParamField(value=" + this.getValue() + ", type=" + String.valueOf((Object)this.getType()) + ")";
        }
    }
}

