/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.web;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerDecorator;
import io.fluxcapacitor.javaclient.web.HttpRequestMethod;
import io.fluxcapacitor.javaclient.web.WebPattern;
import io.fluxcapacitor.javaclient.web.WebRequest;
import io.fluxcapacitor.javaclient.web.WebUtils;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.BiFunction;
import lombok.Generated;

public class WebsocketHandlerDecorator
implements HandlerDecorator {
    private final Set<String> websocketPaths = new CopyOnWriteArraySet<String>();

    @Override
    public Handler<DeserializingMessage> wrap(Handler<DeserializingMessage> handler) {
        List<WebPattern> methods = ReflectionUtils.getAllMethods((Class)handler.getTargetClass()).stream().flatMap(m -> WebUtils.getWebPatterns(m).stream()).filter(p -> p.getMethod().isWebsocket()).toList();
        if (!methods.isEmpty()) {
            methods.stream().filter(p -> p.getMethod() == HttpRequestMethod.WS_HANDSHAKE).map(WebPattern::getPath).distinct().forEach(this.websocketPaths::add);
            List<String> pathsRequiringHandshake = methods.stream().map(WebPattern::getPath).distinct().filter(this.websocketPaths::add).toList();
            if (!pathsRequiringHandshake.isEmpty()) {
                return new WebsocketHandshakeHandler(handler, pathsRequiringHandshake);
            }
        }
        return handler;
    }

    protected static class WebsocketHandshakeHandler
    implements Handler<DeserializingMessage> {
        private final Handler<DeserializingMessage> delegate;
        private final Collection<String> paths;
        private final HandlerInvoker handshakeInvoker;

        public WebsocketHandshakeHandler(Handler<DeserializingMessage> delegate, Collection<String> paths) {
            this.delegate = delegate;
            this.paths = paths;
            this.handshakeInvoker = new HandshakeInvoker(delegate.getTargetClass());
        }

        public Optional<HandlerInvoker> getInvoker(DeserializingMessage message) {
            return this.delegate.getInvoker((Object)message).or(() -> this.matches(message) ? Optional.of(this.handshakeInvoker) : Optional.empty());
        }

        protected boolean matches(DeserializingMessage message) {
            return message.getMessageType() == MessageType.WEBREQUEST && WebRequest.getMethod(message.getMetadata()) == HttpRequestMethod.WS_HANDSHAKE && this.paths.contains(WebRequest.getUrl(message.getMetadata()));
        }

        public Class<?> getTargetClass() {
            return this.delegate.getTargetClass();
        }
    }

    protected static class HandshakeInvoker
    implements HandlerInvoker {
        private final Class<?> targetClass;
        private final Executable method = HandshakeInvoker.getInvokeMethod();

        private static Method getInvokeMethod() {
            return HandshakeInvoker.class.getMethod("invoke", new Class[0]);
        }

        public Class<?> getTargetClass() {
            return this.targetClass;
        }

        public Executable getMethod() {
            return this.method;
        }

        public <A extends Annotation> A getMethodAnnotation() {
            return null;
        }

        public boolean expectResult() {
            return false;
        }

        public boolean isPassive() {
            return false;
        }

        public Object invoke(BiFunction<Object, Object, Object> combiner) {
            return null;
        }

        @ConstructorProperties(value={"targetClass"})
        @Generated
        public HandshakeInvoker(Class<?> targetClass) {
            this.targetClass = targetClass;
        }
    }
}

