/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.fluxcapacitor.common.serialization.JsonUtils;
import java.io.ByteArrayOutputStream;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class SearchUtils {
    private static final Pattern dotPattern = Pattern.compile("(?<!\\\\)\\.");
    private static final Map<String, Integer> arrayIndices = IntStream.range(0, 1000).boxed().collect(Collectors.toMap(Object::toString, Function.identity()));
    private static final DateTimeFormatter ISO_FULL = new DateTimeFormatterBuilder().parseCaseInsensitive().appendInstant(3).toFormatter();
    public static final String letterOrNumber = "\\p{L}0-9";
    public static final Pattern termPattern = Pattern.compile(String.format("\"[^\"]*\"|[%1$s][^\\s]*[%1$s]|[%1$s]", "\\p{L}0-9"), 8);
    private static final Map<String, Predicate<String>> globPatternCache = new ConcurrentHashMap<String, Predicate<String>>();

    public static String formatValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Instant) {
            Instant instant = (Instant)value;
            return ISO_FULL.format(instant);
        }
        return value.toString();
    }

    public static String normalize(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        return StringUtils.stripAccents(text).trim().toLowerCase();
    }

    public static byte[] normalizeJson(byte[] data) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try (JsonParser p = JsonUtils.writer.createParser(data);
             JsonGenerator generator = JsonUtils.writer.createGenerator(stream, JsonEncoding.UTF8);){
            JsonToken token = p.nextToken();
            while (token != null) {
                if (token == JsonToken.VALUE_STRING) {
                    generator.writeString(SearchUtils.normalize(p.getText()));
                } else {
                    generator.copyCurrentEventExact(p);
                }
                token = p.nextToken();
            }
        }
        return stream.toByteArray();
    }

    public static Predicate<String> getGlobMatcher(String pattern) {
        return globPatternCache.computeIfAbsent(pattern, p -> SearchUtils.tryGetSimpleGlobMatcher(pattern).orElseGet(() -> {
            StringBuilder sb = new StringBuilder(p.length());
            int inGroup = 0;
            int inClass = 0;
            int firstIndexInClass = -1;
            char[] arr = p.toCharArray();
            block16: for (int i = 0; i < arr.length; ++i) {
                char ch = arr[i];
                switch (ch) {
                    case '\\': {
                        if (++i >= arr.length) {
                            sb.append('\\');
                            continue block16;
                        }
                        char next = arr[i];
                        switch (next) {
                            case ',': {
                                break;
                            }
                            case 'E': 
                            case 'Q': {
                                sb.append('\\');
                            }
                            default: {
                                sb.append('\\');
                            }
                        }
                        sb.append(next);
                        continue block16;
                    }
                    case '*': {
                        if (inClass == 0) {
                            sb.append(".*");
                            continue block16;
                        }
                        sb.append('*');
                        continue block16;
                    }
                    case '?': {
                        if (inClass == 0) {
                            sb.append('.');
                            continue block16;
                        }
                        sb.append('?');
                        continue block16;
                    }
                    case '[': {
                        ++inClass;
                        firstIndexInClass = i + 1;
                        sb.append('[');
                        continue block16;
                    }
                    case ']': {
                        --inClass;
                        sb.append(']');
                        continue block16;
                    }
                    case '$': 
                    case '%': 
                    case '(': 
                    case ')': 
                    case '+': 
                    case '.': 
                    case '@': 
                    case '^': 
                    case '|': {
                        if (inClass == 0 || firstIndexInClass == i && ch == '^') {
                            sb.append('\\');
                        }
                        sb.append(ch);
                        continue block16;
                    }
                    case '!': {
                        if (firstIndexInClass == i) {
                            sb.append('^');
                            continue block16;
                        }
                        sb.append('!');
                        continue block16;
                    }
                    case '{': {
                        ++inGroup;
                        sb.append('(');
                        continue block16;
                    }
                    case '}': {
                        --inGroup;
                        sb.append(')');
                        continue block16;
                    }
                    case ',': {
                        if (inGroup > 0) {
                            sb.append('|');
                            continue block16;
                        }
                        sb.append(',');
                        continue block16;
                    }
                    default: {
                        sb.append(ch);
                    }
                }
            }
            return Pattern.compile(sb.toString()).asMatchPredicate();
        }));
    }

    private static Optional<Predicate<String>> tryGetSimpleGlobMatcher(String pattern) {
        boolean postfix = pattern.endsWith("**");
        pattern = postfix ? pattern.substring(0, pattern.length() - 2) : pattern;
        boolean prefix = pattern.startsWith("**");
        String finalPattern = prefix ? pattern.substring(2) : pattern;
        for (char globCharacter : "*?{\\".toCharArray()) {
            if (finalPattern.indexOf(globCharacter) < 0) continue;
            return Optional.empty();
        }
        return postfix ? (prefix ? Optional.of(s -> s.contains(finalPattern)) : Optional.of(s -> s.startsWith(finalPattern))) : (prefix ? Optional.of(s -> s.endsWith(finalPattern)) : Optional.of(s -> s.equals(finalPattern)));
    }

    public static boolean isInteger(String fieldName) {
        if (StringUtils.isNumeric(fieldName)) {
            try {
                Integer.parseInt(fieldName);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static Object asIntegerOrString(String fieldName) {
        if (StringUtils.isNumeric(fieldName)) {
            Integer result = arrayIndices.get(fieldName);
            if (result != null) {
                return result;
            }
            try {
                return Integer.valueOf(fieldName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return fieldName;
    }

    public static List<String> splitInTerms(String query) {
        ArrayList<String> parts = new ArrayList<String>();
        Matcher matcher = termPattern.matcher(query.trim());
        while (matcher.find()) {
            String group = matcher.group().trim();
            if (group.isEmpty() || group.equals("\"")) continue;
            if (group.startsWith("\"") && group.endsWith("\"")) {
                group = group.substring(1, group.length() - 1);
            }
            parts.add(group);
        }
        return parts;
    }

    public static Object asPrimitive(Object value) {
        if (value instanceof String || value instanceof Number || value instanceof Boolean || value == null) {
            return value;
        }
        return value.toString();
    }

    public static String normalizePath(String queryPath) {
        return queryPath == null ? null : dotPattern.matcher(queryPath).replaceAll("/");
    }

    public static String escapeFieldName(String fieldName) {
        fieldName = ((String)fieldName).replace("/", "\\/");
        if (StringUtils.isNumeric((CharSequence)(fieldName = ((String)fieldName).replace("\"", "\\\"")))) {
            try {
                Integer.valueOf((String)fieldName);
                fieldName = "\"" + (String)fieldName + "\"";
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return fieldName;
    }

    public static String unescapeFieldName(String fieldName) {
        if (fieldName.startsWith("\"") && fieldName.endsWith("\"")) {
            fieldName = fieldName.substring(1, fieldName.length() - 1);
        }
        fieldName = fieldName.replace("\\/", "/");
        fieldName = fieldName.replace("\\\"", "\"");
        return fieldName;
    }
}

