/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.api.search;

import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.common.api.search.FacetEntry;
import io.fluxcapacitor.common.search.DefaultDocumentSerializer;
import io.fluxcapacitor.common.search.Document;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import lombok.Generated;

public final class SerializedDocument {
    private final String id;
    private final Long timestamp;
    private final Long end;
    private final String collection;
    private final Supplier<Data<byte[]>> data;
    private final Supplier<Document> document;
    private final String summary;
    private final Set<FacetEntry> facets;

    @ConstructorProperties(value={"id", "timestamp", "end", "collection", "document", "summary", "facets"})
    public SerializedDocument(String id, Long timestamp, Long end, String collection, Data<byte[]> document, String summary, Set<FacetEntry> facets) {
        this(id, timestamp, end, collection, () -> document, null, summary, facets);
    }

    public SerializedDocument(Document document) {
        this(document.getId(), Optional.ofNullable(document.getTimestamp()).map(Instant::toEpochMilli).orElse(null), Optional.ofNullable(document.getEnd()).map(Instant::toEpochMilli).orElse(null), document.getCollection(), null, () -> document, Optional.ofNullable(document.getSummary()).map(Supplier::get).orElse(null), document.getFacets());
    }

    private SerializedDocument(String id, Long timestamp, Long end, String collection, Supplier<Data<byte[]>> data, Supplier<Document> document, String summary, Set<FacetEntry> facets) {
        if (data == null && document == null) {
            throw new IllegalStateException("Either the serialized data or deserialized document should be supplied");
        }
        this.id = id;
        this.timestamp = timestamp;
        this.end = end;
        this.collection = collection;
        this.data = data == null ? ObjectUtils.memoize(() -> DefaultDocumentSerializer.INSTANCE.serialize((Document)document.get())) : data;
        this.document = document == null ? ObjectUtils.memoize(() -> DefaultDocumentSerializer.INSTANCE.deserialize((Data)data.get()).toBuilder().facets(facets).build()) : document;
        this.summary = summary;
        this.facets = facets;
    }

    public Long getEnd() {
        return this.end == null || this.timestamp == null || this.end > this.timestamp ? this.end : this.timestamp;
    }

    public Data<byte[]> getDocument() {
        return this.data.get();
    }

    public Document deserializeDocument() {
        return this.document.get();
    }

    @Generated
    public static SerializedDocumentBuilder builder() {
        return new SerializedDocumentBuilder();
    }

    @Generated
    public SerializedDocumentBuilder toBuilder() {
        return new SerializedDocumentBuilder().id(this.id).timestamp(this.timestamp).end(this.end).collection(this.collection).data(this.data).document(this.document).summary(this.summary).facets(this.facets);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public String getCollection() {
        return this.collection;
    }

    @Generated
    public String getSummary() {
        return this.summary;
    }

    @Generated
    public Set<FacetEntry> getFacets() {
        return this.facets;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SerializedDocument)) {
            return false;
        }
        SerializedDocument other = (SerializedDocument)o;
        Long this$timestamp = this.getTimestamp();
        Long other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        Long this$end = this.getEnd();
        Long other$end = other.getEnd();
        if (this$end == null ? other$end != null : !((Object)this$end).equals(other$end)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$collection = this.getCollection();
        String other$collection = other.getCollection();
        if (this$collection == null ? other$collection != null : !this$collection.equals(other$collection)) {
            return false;
        }
        String this$summary = this.getSummary();
        String other$summary = other.getSummary();
        if (this$summary == null ? other$summary != null : !this$summary.equals(other$summary)) {
            return false;
        }
        Set<FacetEntry> this$facets = this.getFacets();
        Set<FacetEntry> other$facets = other.getFacets();
        return !(this$facets == null ? other$facets != null : !((Object)this$facets).equals(other$facets));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        Long $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $collection = this.getCollection();
        result = result * 59 + ($collection == null ? 43 : $collection.hashCode());
        String $summary = this.getSummary();
        result = result * 59 + ($summary == null ? 43 : $summary.hashCode());
        Set<FacetEntry> $facets = this.getFacets();
        result = result * 59 + ($facets == null ? 43 : ((Object)$facets).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SerializedDocument(id=" + this.getId() + ", timestamp=" + this.getTimestamp() + ", end=" + this.getEnd() + ", collection=" + this.getCollection() + ", summary=" + this.getSummary() + ", facets=" + String.valueOf(this.getFacets()) + ")";
    }

    @Generated
    public SerializedDocument withData(Supplier<Data<byte[]>> data) {
        return this.data == data ? this : new SerializedDocument(this.id, this.timestamp, this.end, this.collection, data, this.document, this.summary, this.facets);
    }

    @Generated
    public static class SerializedDocumentBuilder {
        @Generated
        private String id;
        @Generated
        private Long timestamp;
        @Generated
        private Long end;
        @Generated
        private String collection;
        @Generated
        private Supplier<Data<byte[]>> data;
        @Generated
        private Supplier<Document> document;
        @Generated
        private String summary;
        @Generated
        private Set<FacetEntry> facets;

        @Generated
        SerializedDocumentBuilder() {
        }

        @Generated
        public SerializedDocumentBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public SerializedDocumentBuilder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Generated
        public SerializedDocumentBuilder end(Long end) {
            this.end = end;
            return this;
        }

        @Generated
        public SerializedDocumentBuilder collection(String collection) {
            this.collection = collection;
            return this;
        }

        @Generated
        public SerializedDocumentBuilder data(Supplier<Data<byte[]>> data) {
            this.data = data;
            return this;
        }

        @Generated
        public SerializedDocumentBuilder document(Supplier<Document> document) {
            this.document = document;
            return this;
        }

        @Generated
        public SerializedDocumentBuilder summary(String summary) {
            this.summary = summary;
            return this;
        }

        @Generated
        public SerializedDocumentBuilder facets(Set<FacetEntry> facets) {
            this.facets = facets;
            return this;
        }

        @Generated
        public SerializedDocument build() {
            return new SerializedDocument(this.id, this.timestamp, this.end, this.collection, this.data, this.document, this.summary, this.facets);
        }

        @Generated
        public String toString() {
            return "SerializedDocument.SerializedDocumentBuilder(id=" + this.id + ", timestamp=" + this.timestamp + ", end=" + this.end + ", collection=" + this.collection + ", data=" + String.valueOf(this.data) + ", document=" + String.valueOf(this.document) + ", summary=" + this.summary + ", facets=" + String.valueOf(this.facets) + ")";
        }
    }
}

