/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.application;

import io.fluxcapacitor.common.ObjectUtils;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AutoClosing {
    private final AtomicBoolean stopped = new AtomicBoolean();

    protected AutoClosing() {
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutDown, ObjectUtils.newThreadName(this.getClass().getSimpleName() + "-shutdown")));
    }

    private void shutDown() {
        if (this.stopped.compareAndSet(false, true)) {
            this.onShutdown();
        }
    }

    protected boolean isStopped() {
        return this.stopped.get();
    }

    protected abstract void onShutdown();
}

