/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.serialization.compression;

import io.fluxcapacitor.common.serialization.compression.CompressionAlgorithm;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipException;
import lombok.NonNull;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;

public class CompressionUtils {
    private static final LZ4Compressor lz4Compressor = LZ4Factory.fastestInstance().fastCompressor();
    private static final LZ4FastDecompressor lz4Decompressor = LZ4Factory.fastestInstance().fastDecompressor();

    public static byte[] compress(byte[] uncompressed) {
        return CompressionUtils.compress(uncompressed, CompressionAlgorithm.LZ4);
    }

    public static byte[] compress(byte[] uncompressed, @NonNull CompressionAlgorithm algorithm) {
        if (algorithm == null) {
            throw new NullPointerException("algorithm is marked non-null but is null");
        }
        return switch (algorithm) {
            default -> throw new MatchException(null, null);
            case CompressionAlgorithm.NONE -> {
                byte[] var2_2;
                yield var2_2 = uncompressed;
            }
            case CompressionAlgorithm.LZ4 -> {
                byte[] compressed = lz4Compressor.compress(uncompressed);
                byte[] var2_3 = ByteBuffer.allocate(compressed.length + 4).putInt(uncompressed.length).put(compressed).array();
                yield var2_3;
            }
            case CompressionAlgorithm.GZIP -> {
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                try (GZIPOutputStream zipStream = new GZIPOutputStream(byteStream);){
                    zipStream.write(uncompressed);
                }
                byte[] var2_4 = byteStream.toByteArray();
                yield var2_4;
            }
        };
    }

    public static byte[] decompress(byte[] compressed) {
        return CompressionUtils.decompress(compressed, CompressionAlgorithm.LZ4);
    }

    public static byte[] decompress(byte[] compressed, @NonNull CompressionAlgorithm algorithm) {
        byte[] byArray;
        if (algorithm == null) {
            throw new NullPointerException("algorithm is marked non-null but is null");
        }
        switch (algorithm) {
            default: {
                throw new MatchException(null, null);
            }
            case NONE: {
                byte[] byArray2;
                byArray = byArray2 = compressed;
                break;
            }
            case LZ4: {
                ByteBuffer buffer = ByteBuffer.wrap(compressed);
                ByteBuffer result = ByteBuffer.allocate(buffer.getInt());
                lz4Decompressor.decompress(buffer, result);
                byte[] byArray3 = result.array();
                byArray = byArray3;
                break;
            }
            case GZIP: {
                byte[] byArray4;
                GZIPInputStream gzipStream = new GZIPInputStream(new ByteArrayInputStream(compressed));
                try {
                    byArray4 = gzipStream.readAllBytes();
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            gzipStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (ZipException ignored) {
                        byte[] byArray5;
                        byArray = byArray5 = compressed;
                    }
                }
                gzipStream.close();
                byArray = byArray4;
                break;
            }
        }
        return byArray;
    }
}

