/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.tracking;

import io.fluxcapacitor.common.Monitored;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.tracking.HasMessageStore;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public interface MessageStore
extends AutoCloseable,
Monitored<List<SerializedMessage>>,
HasMessageStore {
    default public CompletableFuture<Void> append(SerializedMessage ... messages) {
        return this.append(Arrays.asList(messages));
    }

    public CompletableFuture<Void> append(List<SerializedMessage> var1);

    default public List<SerializedMessage> getBatch(Long minIndex, int maxSize) {
        return this.getBatch(minIndex, maxSize, false);
    }

    public List<SerializedMessage> getBatch(Long var1, int var2, boolean var3);

    default public <T extends MessageStore> T unwrap(Class<T> type) {
        if (type.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    default public void close() {
    }

    @Override
    default public MessageStore getMessageStore() {
        return this;
    }
}

