/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.filter.LevelFilter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Context;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.ClientUtils;
import io.fluxcapacitor.javaclient.common.logging.ConsoleError;
import io.fluxcapacitor.javaclient.common.logging.ConsoleWarning;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FluxCapacitorLogbackAppender
extends AppenderBase<ILoggingEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FluxCapacitorLogbackAppender.class);

    public static void attach() {
        Context loggerContext = (Context)((Object)LoggerFactory.getILoggerFactory());
        FluxCapacitorLogbackAppender appender = new FluxCapacitorLogbackAppender();
        LevelFilter filter = new LevelFilter();
        filter.setLevel(Level.WARN);
        appender.addFilter(filter);
        appender.setContext(loggerContext);
        appender.start();
        ch.qos.logback.classic.Logger rootLogger = FluxCapacitorLogbackAppender.getRootLogger();
        rootLogger.addAppender(appender);
    }

    public static void detach() {
        ch.qos.logback.classic.Logger rootLogger = FluxCapacitorLogbackAppender.getRootLogger();
        Iterator<Appender<ILoggingEvent>> iterator2 = rootLogger.iteratorForAppenders();
        ArrayList<Appender<ILoggingEvent>> appenders = new ArrayList<Appender<ILoggingEvent>>();
        while (iterator2.hasNext()) {
            Appender<ILoggingEvent> appender = iterator2.next();
            if (!(appender instanceof FluxCapacitorLogbackAppender)) continue;
            appenders.add(appender);
        }
        appenders.forEach(rootLogger::detachAppender);
    }

    @Override
    protected void append(ILoggingEvent event) {
        try {
            if (!event.getLevel().isGreaterOrEqual(Level.WARN)) {
                return;
            }
            Optional<Throwable> throwable = Optional.ofNullable((ThrowableProxy)event.getThrowableProxy()).map(ThrowableProxy::getThrowable);
            if (this.ignoreEvent(event)) {
                String errorMessage = "Ignoring error: %s".formatted(event.getFormattedMessage());
                throwable.ifPresentOrElse(e -> log.info(errorMessage, (Throwable)e), () -> log.info(errorMessage));
                return;
            }
            Metadata metadata = Optional.ofNullable(DeserializingMessage.getCurrent()).map(DeserializingMessage::getMetadata).orElse(Metadata.empty());
            metadata = metadata.with("stackTrace", String.format("[%s] %s %s - %s%s", event.getThreadName(), event.getLevel(), event.getLoggerName(), event.getFormattedMessage(), throwable.map(e -> "\n" + ExceptionUtils.getStackTrace(e)).orElse("")), "level", event.getLevel().toString(), "loggerName", event.getLoggerName(), "messageTemplate", event.getMessage());
            if (throwable.isPresent()) {
                Throwable e2 = throwable.get();
                metadata = metadata.with("error", e2.getClass().getSimpleName(), "message", event.getFormattedMessage(), "errorMessage", StringUtils.isBlank(e2.getMessage()) ? event.getFormattedMessage() : e2.getMessage());
                StackTraceElement[] stackTraceElements = Optional.ofNullable(e2.getStackTrace()).filter(s -> ((StackTraceElement[])s).length > 0).orElse(null);
                if (stackTraceElements != null) {
                    metadata = metadata.with((Object)"traceElement", (Object)stackTraceElements[0].toString());
                }
            } else {
                metadata = metadata.with("message", event.getFormattedMessage(), "errorMessage", event.getFormattedMessage());
            }
            FluxCapacitor.get().errorGateway().report(event.getLevel() == Level.WARN ? new ConsoleWarning() : new ConsoleError(), metadata);
        }
        catch (Throwable e3) {
            log.info("Failed to publish console error", e3);
        }
    }

    protected boolean ignoreEvent(ILoggingEvent event) {
        return Optional.ofNullable(event.getMarkerList()).map(markers -> markers.stream().anyMatch(m -> m.contains(ClientUtils.ignoreMarker))).orElse(false);
    }

    private static ch.qos.logback.classic.Logger getRootLogger() {
        return (ch.qos.logback.classic.Logger)LoggerFactory.getLogger("ROOT");
    }
}

