/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.serialization;

import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.common.api.SerializedObject;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.common.serialization.Revision;
import io.fluxcapacitor.javaclient.common.serialization.DeserializationException;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingObject;
import io.fluxcapacitor.javaclient.common.serialization.SerializationException;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.common.serialization.UnknownTypeStrategy;
import io.fluxcapacitor.javaclient.common.serialization.casting.Caster;
import io.fluxcapacitor.javaclient.common.serialization.casting.CasterChain;
import io.fluxcapacitor.javaclient.common.serialization.casting.Converter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSerializer<I>
implements Serializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractSerializer.class);
    private final Caster<SerializedObject<byte[], ?>> upcasterChain;
    private final Caster<Data<I>> downcasterChain;
    private final String format;
    private final Map<String, String> typeCasters = new ConcurrentHashMap<String, String>();

    protected AbstractSerializer(Collection<?> casterCandidates, Converter<I> converter, String format) {
        this.upcasterChain = CasterChain.createUpcaster(casterCandidates, converter);
        this.downcasterChain = CasterChain.create(casterCandidates, converter.getDataType(), true);
        this.format = format;
    }

    @Override
    public Data<byte[]> serialize(Object object, String format) {
        if (format == null) {
            format = this.format;
        }
        try {
            if (object instanceof Data) {
                Data data = (Data)object;
                if (data.getValue() instanceof byte[]) {
                    return data;
                }
                return new Data<byte[]>(this.serialize(data.getValue(), format).getValue(), data.getType(), data.getRevision(), format);
            }
            if (Objects.equals(this.format, format)) {
                return new Data<byte[]>(this.doSerialize(object), this.getTypeString(object), this.getRevisionNumber(object), format);
            }
            return this.serializeToOtherFormat(object, format);
        }
        catch (Exception e) {
            throw new SerializationException(String.format("Could not serialize a %s (format %s)", this.formatValue(object), format), e);
        }
    }

    private String formatValue(Object value) {
        String string;
        if (value == null) {
            string = "null";
        } else {
            Class<?> clazz = ReflectionUtils.ifClass(value);
            if (clazz instanceof Class) {
                Class<?> c = clazz;
                string = c.getName();
            } else {
                string = value.getClass().getName();
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Data<byte[]> serializeToOtherFormat(Object object, String format) {
        Data<byte[]> data;
        if (object instanceof String) {
            return new Data<byte[]>(((String)object).getBytes(StandardCharsets.UTF_8), this.asString((Type)((Object)String.class)), 0, format);
        }
        if (object instanceof byte[]) {
            return new Data<byte[]>((byte[])object, this.asString((Type)((Object)byte[].class)), 0, format);
        }
        if (!(object instanceof InputStream)) throw new UnsupportedOperationException();
        try (InputStream inputStream = (InputStream)object;){
            data = new Data<byte[]>(inputStream.readAllBytes(), this.asString((Type)((Object)byte[].class)), 0, format);
            if (inputStream == null) return data;
        }
        return data;
    }

    protected Type getType(Object object) {
        List<Class<?>> values2;
        Map map;
        List<Class<?>> keys2;
        if (object == null) {
            return Void.class;
        }
        Class<?> type = object.getClass();
        if (Collection.class.isAssignableFrom(type)) {
            List<Class<?>> children = ReflectionUtils.determineCommonAncestors((Collection)object);
            if (!children.isEmpty()) {
                return TypeUtils.parameterize(type, children.getFirst());
            }
        } else if (Map.class.isAssignableFrom(type) && !(keys2 = ReflectionUtils.determineCommonAncestors((map = (Map)object).keySet())).isEmpty() && !(values2 = ReflectionUtils.determineCommonAncestors(map.values())).isEmpty()) {
            return TypeUtils.parameterize(type, keys2.getFirst(), values2.getFirst());
        }
        return type;
    }

    protected String asString(Type type) {
        return type.getTypeName();
    }

    protected String getTypeString(Object object) {
        return this.asString(this.getType(object));
    }

    protected Optional<Revision> getRevision(Object object) {
        return Optional.ofNullable(object).map(o -> o.getClass().getAnnotation(Revision.class));
    }

    protected int getRevisionNumber(Object object) {
        return this.getRevision(object).map(Revision::value).orElse(0);
    }

    protected abstract byte[] doSerialize(Object var1) throws Exception;

    public <S extends SerializedObject<byte[], S>> Stream<DeserializingObject<byte[], S>> deserialize(Stream<S> dataStream, UnknownTypeStrategy unknownTypeStrategy) {
        return this.upcasterChain.cast(dataStream).map(s -> {
            String upcastedType;
            String type = s.data().getType();
            return Objects.equals(type, upcastedType = this.upcastType(type)) ? s : s.withData(s.data().withType(upcastedType));
        }).flatMap(s -> {
            if (!Objects.equals(this.format, s.data().getFormat())) {
                return this.deserializeOtherFormat((SerializedObject<byte[], ?>)s);
            }
            if (!this.isKnownType(s.data().getType())) {
                if (unknownTypeStrategy == UnknownTypeStrategy.FAIL) {
                    throw new DeserializationException(String.format("Could not deserialize object. The serialized type is unknown: %s (rev. %d)", s.data().getType(), s.data().getRevision()));
                }
                if (unknownTypeStrategy == UnknownTypeStrategy.IGNORE) {
                    return Stream.empty();
                }
                return this.deserializeUnknownType((SerializedObject<byte[], ?>)s);
            }
            return Stream.of(new DeserializingObject((SerializedObject)s, type -> {
                try {
                    return Object.class.equals(type) ? this.doDeserialize(s.data(), s.data().getType()) : this.doDeserialize(s.data(), this.asString((Type)type));
                }
                catch (Exception e) {
                    throw new DeserializationException("Could not deserialize a " + s.data().getType(), e);
                }
            }));
        });
    }

    @Override
    public <V> V convert(Object value, Class<V> type) {
        if (type == null || Object.class.equals(type)) {
            return (V)value;
        }
        return this.doConvert(value, type);
    }

    @Override
    public <V> V clone(Object value) {
        if (value == null || value.getClass().isPrimitive() || value instanceof String) {
            return (V)value;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (value instanceof List) {
                return (V)new ArrayList(collection);
            }
            if (value instanceof SortedSet) {
                return (V)new TreeSet(collection);
            }
            if (value instanceof Set) {
                return (V)new LinkedHashSet(collection);
            }
            return (V)new LinkedList(collection);
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            if (value instanceof SortedMap) {
                return (V)new TreeMap(map);
            }
            return (V)new LinkedHashMap(map);
        }
        return (V)this.doClone(value);
    }

    @Override
    public Serializer registerTypeCaster(String oldType, String newType) {
        this.typeCasters.put(oldType, newType);
        return this;
    }

    @Override
    public String upcastType(String type) {
        if (type == null) {
            return null;
        }
        String result = this.typeCasters.get(type);
        if (result == null || Objects.equals(result, type)) {
            return type;
        }
        return this.upcastType(result);
    }

    @Override
    public Object downcast(Object object, int desiredRevision) {
        return this.downcastIntermediate(new Data<I>(this.asIntermediateValue(object), this.asString(this.getType(object)), (int)this.getRevision(object).map(Revision::value).orElse(0), this.format), desiredRevision);
    }

    @Override
    public Object downcast(Data<?> object, int desiredRevision) {
        return this.downcastIntermediate(new Data<I>(this.asIntermediateValue(object.getValue()), object.getType(), object.getRevision(), this.format), desiredRevision);
    }

    @Nullable
    private Object downcastIntermediate(Data<I> data, int desiredRevision) {
        List<Object> result = this.downcasterChain.cast(Stream.of(data), desiredRevision).map(Data::getValue).filter(Objects::nonNull).toList();
        return switch (result.size()) {
            case 0 -> null;
            case 1 -> result.getFirst();
            default -> result;
        };
    }

    protected abstract Object doClone(Object var1);

    protected abstract <V> V doConvert(Object var1, Class<V> var2);

    protected boolean isKnownType(String type) {
        return type != null && ReflectionUtils.classExists(type);
    }

    protected Stream<DeserializingObject<byte[], ?>> deserializeOtherFormat(SerializedObject<byte[], ?> s) {
        return Stream.of(new DeserializingObject(s, type -> {
            try {
                if (Object.class.equals(type)) {
                    return s.data().getValue();
                }
                if (byte[].class.isAssignableFrom((Class<?>)type)) {
                    return s.data().getValue();
                }
                if (String.class.isAssignableFrom((Class<?>)type)) {
                    return new String((byte[])s.data().getValue());
                }
                if (InputStream.class.isAssignableFrom((Class<?>)type)) {
                    return new ByteArrayInputStream((byte[])s.data().getValue());
                }
                return this.doDeserialize(s.data(), this.asString((Type)type));
            }
            catch (Exception e) {
                throw new DeserializationException("Could not deserialize a " + s.data().getType(), e);
            }
        }));
    }

    protected Stream<DeserializingObject<byte[], ?>> deserializeUnknownType(SerializedObject<byte[], ?> serializedObject) {
        return Stream.empty();
    }

    protected abstract Object doDeserialize(Data<byte[]> var1, String var2) throws Exception;

    protected abstract I asIntermediateValue(Object var1);

    @Generated
    public String getFormat() {
        return this.format;
    }
}

