/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.serialization;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.api.SerializedObject;
import io.fluxcapacitor.javaclient.common.serialization.ContentFilter;
import io.fluxcapacitor.javaclient.common.serialization.DeserializationException;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingObject;
import io.fluxcapacitor.javaclient.common.serialization.UnknownTypeStrategy;
import java.util.List;
import java.util.stream.Stream;

public interface Serializer
extends ContentFilter {
    default public Data<byte[]> serialize(Object object) {
        return this.serialize(object, null);
    }

    public Data<byte[]> serialize(Object var1, String var2);

    default public <T> T deserialize(SerializedObject<byte[], ?> data) {
        List<DeserializingObject<byte[], SerializedObject<byte[], ?>>> list = this.deserialize(Stream.of(data), UnknownTypeStrategy.FAIL).toList();
        if (list.size() != 1) {
            throw new DeserializationException(String.format("Invalid deserialization result for a '%s'. Expected a single object but got %s", data, list.stream().map(Object::getClass).toList()));
        }
        return (T)list.getFirst().getPayload();
    }

    public <I extends SerializedObject<byte[], I>> Stream<DeserializingObject<byte[], I>> deserialize(Stream<I> var1, UnknownTypeStrategy var2);

    default public Stream<DeserializingMessage> deserializeMessages(Stream<SerializedMessage> dataStream, MessageType messageType) {
        return this.deserializeMessages(dataStream, messageType, UnknownTypeStrategy.AS_INTERMEDIATE);
    }

    default public Stream<DeserializingMessage> deserializeMessages(Stream<SerializedMessage> dataStream, MessageType messageType, UnknownTypeStrategy unknownTypeStrategy) {
        return this.deserialize(dataStream, unknownTypeStrategy).map(s -> new DeserializingMessage((DeserializingObject<byte[], SerializedMessage>)s, messageType));
    }

    default public DeserializingMessage deserializeMessage(SerializedMessage message, MessageType messageType) {
        return this.deserializeMessages(Stream.of(message), messageType).findAny().orElseThrow();
    }

    public <V> V convert(Object var1, Class<V> var2);

    public <V> V clone(Object var1);

    public Serializer registerTypeCaster(String var1, String var2);

    public String upcastType(String var1);

    public Object downcast(Object var1, int var2);

    public Object downcast(Data<?> var1, int var2);
}

