/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.websocket;

import io.fluxcapacitor.common.ConsistentHashing;
import jakarta.websocket.Session;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionPool
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SessionPool.class);
    private final Map<Integer, Session> sessionMap;
    private final int size;
    private final AtomicInteger counter = new AtomicInteger();
    private final Supplier<Session> sessionFactory;
    private final AtomicBoolean shuttingDown = new AtomicBoolean();

    public SessionPool(int size, Supplier<Session> sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.size = size;
        this.sessionMap = new ConcurrentHashMap<Integer, Session>();
    }

    public Session get() {
        return this.get(this.counter.getAndAccumulate(1, (i, inc) -> {
            int newIndex = i + inc;
            return newIndex >= this.size ? 0 : newIndex;
        }));
    }

    public Session get(String routingKey) {
        if (routingKey == null) {
            return this.get();
        }
        return this.get(ConsistentHashing.computeSegment(routingKey, this.size));
    }

    protected Session get(int index) {
        return this.sessionMap.compute(index, (i, s) -> {
            while (SessionPool.isClosed(s)) {
                if (this.shuttingDown.get()) {
                    throw new IllegalStateException("Cannot provide session. This client has closed");
                }
                s = this.sessionFactory.get();
            }
            return s;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.shuttingDown.compareAndSet(false, true)) {
            AtomicBoolean atomicBoolean = this.shuttingDown;
            synchronized (atomicBoolean) {
                this.sessionMap.values().forEach(session -> {
                    if (!SessionPool.isClosed(session)) {
                        try {
                            session.close();
                        }
                        catch (Exception e) {
                            log.warn("Failed to closed websocket session connected to endpoint {}. Reason: {}", (Object)session.getRequestURI(), (Object)e.getMessage());
                        }
                    }
                });
            }
        }
    }

    private static boolean isClosed(Session session) {
        try {
            return session == null || !session.isOpen();
        }
        catch (Exception e) {
            log.error("Failed to check if session is open", e);
            return true;
        }
    }
}

