/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.configuration.spring;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.util.ClassUtils;

@Target(value={ElementType.METHOD, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Conditional(value={Condition.class})
public @interface ConditionalOnMissingBean {
    public Class<?> value() default void.class;

    @Order
    public static class Condition
    implements org.springframework.context.annotation.Condition {
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            String[] beanNames;
            if (metadata instanceof MethodMetadata) {
                Class type = (Class)metadata.getAllAnnotationAttributes(ConditionalOnMissingBean.class.getName()).getFirst((Object)"value");
                if (Void.TYPE.equals(type)) {
                    type = ClassUtils.forName((String)((MethodMetadata)metadata).getReturnTypeName(), (ClassLoader)context.getClassLoader());
                }
                return BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)context.getBeanFactory(), (Class)type).length == 0;
            }
            Class type = (Class)metadata.getAllAnnotationAttributes(ConditionalOnMissingBean.class.getName()).getFirst((Object)"value");
            if (Void.TYPE.equals(type)) {
                type = ClassUtils.forName((String)metadata.getAnnotations().get(ConditionalOnMissingBean.class).getSource().toString(), (ClassLoader)context.getClassLoader());
            }
            return (beanNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)context.getBeanFactory(), (Class)type)).length == 0;
        }
    }
}

