/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.modeling;

import io.fluxcapacitor.common.api.search.Constraint;
import io.fluxcapacitor.common.api.search.constraints.MatchConstraint;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.ClientUtils;
import io.fluxcapacitor.javaclient.common.Entry;
import io.fluxcapacitor.javaclient.modeling.HandlerRepository;
import io.fluxcapacitor.javaclient.persisting.search.DocumentStore;
import io.fluxcapacitor.javaclient.tracking.handling.Stateful;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHandlerRepository
implements HandlerRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultHandlerRepository.class);
    private final DocumentStore documentStore;
    private final String collection;
    private final Class<?> type;
    private final Function<Object, Instant> timestampFunction;
    private final Function<Object, Instant> endFunction;

    public static Function<Class<?>, HandlerRepository> repositorySupplier(DocumentStore documentStore) {
        return ClientUtils.memoize(type -> new DefaultHandlerRepository(documentStore, ClientUtils.getSearchParameters(type).getCollection(), (Class<?>)type, (Stateful)ReflectionUtils.getTypeAnnotation(type, Stateful.class)));
    }

    public DefaultHandlerRepository(DocumentStore documentStore, String collection, Class<?> type, Stateful annotation) {
        this.documentStore = documentStore;
        this.collection = collection;
        this.type = type;
        AtomicBoolean warnedAboutMissingTimePath = new AtomicBoolean();
        this.timestampFunction = Optional.of(annotation).map(Stateful::timestampPath).filter(path -> !path.isBlank()).map(path -> handler -> ReflectionUtils.readProperty(path, handler).map(t -> Instant.from((TemporalAccessor)t)).orElseGet(() -> {
            if (handler != null) {
                if (ReflectionUtils.hasProperty(path, handler)) {
                    return null;
                }
                if (warnedAboutMissingTimePath.compareAndSet(false, true)) {
                    log.warn("Type {} does not declare a timestamp property at '{}'", (Object)handler.getClass().getSimpleName(), path);
                }
            }
            return FluxCapacitor.currentTime();
        })).orElseGet(() -> handler -> FluxCapacitor.currentTime());
        AtomicBoolean warnedAboutMissingEndPath = new AtomicBoolean();
        this.endFunction = Optional.of(annotation).map(Stateful::endPath).filter(path -> !path.isBlank()).map(path -> handler -> ReflectionUtils.readProperty(path, handler).map(t -> Instant.from((TemporalAccessor)t)).orElseGet(() -> {
            if (handler != null) {
                if (ReflectionUtils.hasProperty(path, handler)) {
                    return null;
                }
                if (warnedAboutMissingEndPath.compareAndSet(false, true)) {
                    log.warn("Type {} does not declare an end timestamp property at '{}'", (Object)handler.getClass().getSimpleName(), path);
                }
            }
            return FluxCapacitor.currentTime();
        })).orElse(this.timestampFunction);
    }

    public Collection<? extends Entry<Object>> findByAssociation(Map<String, String> associations) {
        if (associations.isEmpty()) {
            return Collections.emptyList();
        }
        Constraint[] constraints = (Constraint[])associations.entrySet().stream().map(e -> MatchConstraint.match(e.getKey(), (String)e.getValue())).toArray(Constraint[]::new);
        return this.documentStore.search(this.collection).any(constraints).streamHits().filter(h -> this.type.isAssignableFrom(h.getValue().getClass())).toList();
    }

    @Override
    public Collection<? extends Entry<?>> getAll() {
        return this.documentStore.search(this.collection).streamHits().filter(h -> this.type.isAssignableFrom(h.getValue().getClass())).toList();
    }

    @Override
    public Entry<?> get(final Object id) {
        return this.documentStore.fetchDocument(id, this.collection).map(v -> new Entry<Object>(this){

            @Override
            public String getId() {
                return id.toString();
            }

            @Override
            public Object getValue() {
                return v;
            }
        }).orElse(null);
    }

    @Override
    public CompletableFuture<?> set(Object value, Object id) {
        return this.documentStore.index(value, id, (Object)this.collection, this.timestampFunction.apply(value), this.endFunction.apply(value));
    }

    @Override
    public CompletableFuture<?> delete(Object id) {
        return this.documentStore.deleteDocument(id, this.collection);
    }
}

