/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.eventsourcing;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.javaclient.common.serialization.DeserializationException;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.modeling.Entity;
import io.fluxcapacitor.javaclient.modeling.ImmutableAggregateRoot;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.EventSourcingException;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.EventStore;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.SnapshotStore;
import io.fluxcapacitor.javaclient.persisting.keyvalue.client.KeyValueClient;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSnapshotStore
implements SnapshotStore {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultSnapshotStore.class);
    private final KeyValueClient keyValueClient;
    private final Serializer serializer;
    private final EventStore eventStore;

    @Override
    public <T> CompletableFuture<Void> storeSnapshot(Entity<T> snapshot) {
        try {
            return this.keyValueClient.putValue(this.snapshotKey(snapshot.id()), this.serializer.serialize(ImmutableAggregateRoot.from(snapshot, null, null, this.eventStore)), Guarantee.STORED);
        }
        catch (Exception e) {
            throw new EventSourcingException(String.format("Failed to store a snapshot: %s", snapshot), e);
        }
    }

    @Override
    public <T> Optional<Entity<T>> getSnapshot(Object aggregateId) {
        try {
            return Optional.ofNullable(this.keyValueClient.getValue(this.snapshotKey(aggregateId))).map(this.serializer::deserialize);
        }
        catch (DeserializationException e) {
            log.warn("Failed to deserialize snapshot for {}. Deleting snapshot.", aggregateId, (Object)e);
            this.deleteSnapshot(aggregateId);
            return Optional.empty();
        }
        catch (Exception e) {
            throw new EventSourcingException(String.format("Failed to obtain snapshot for aggregate %s", aggregateId), e);
        }
    }

    @Override
    public CompletableFuture<Void> deleteSnapshot(Object aggregateId) {
        try {
            return this.keyValueClient.deleteValue(this.snapshotKey(aggregateId), Guarantee.STORED);
        }
        catch (Exception e) {
            throw new EventSourcingException(String.format("Failed to delete snapshot for aggregate %s", aggregateId), e);
        }
    }

    protected String snapshotKey(Object aggregateId) {
        return "$snapshot_" + String.valueOf(aggregateId);
    }

    @ConstructorProperties(value={"keyValueClient", "serializer", "eventStore"})
    @Generated
    public DefaultSnapshotStore(KeyValueClient keyValueClient, Serializer serializer, EventStore eventStore) {
        this.keyValueClient = keyValueClient;
        this.serializer = serializer;
        this.eventStore = eventStore;
    }
}

