/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.eventsourcing.client;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.api.modeling.GetAggregateIds;
import io.fluxcapacitor.common.api.modeling.GetRelationships;
import io.fluxcapacitor.common.api.modeling.Relationship;
import io.fluxcapacitor.common.api.modeling.RepairRelationships;
import io.fluxcapacitor.common.api.modeling.UpdateRelationships;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.AggregateEventStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public interface EventStoreClient
extends AutoCloseable {
    default public CompletableFuture<Void> storeEvents(String aggregateId, List<SerializedMessage> events, boolean storeOnly) {
        return this.storeEvents(aggregateId, events, storeOnly, Guarantee.STORED);
    }

    public CompletableFuture<Void> storeEvents(String var1, List<SerializedMessage> var2, boolean var3, Guarantee var4);

    default public AggregateEventStream<SerializedMessage> getEvents(String aggregateId) {
        return this.getEvents(aggregateId, -1L);
    }

    default public AggregateEventStream<SerializedMessage> getEvents(String aggregateId, long lastSequenceNumber) {
        return this.getEvents(aggregateId, lastSequenceNumber, -1);
    }

    public AggregateEventStream<SerializedMessage> getEvents(String var1, long var2, int var4);

    default public CompletableFuture<Void> deleteEvents(String aggregateId) {
        return this.deleteEvents(aggregateId, Guarantee.STORED);
    }

    public CompletableFuture<Void> deleteEvents(String var1, Guarantee var2);

    public CompletableFuture<Void> updateRelationships(UpdateRelationships var1);

    public CompletableFuture<Void> repairRelationships(RepairRelationships var1);

    default public Map<String, String> getAggregatesFor(String entityId) {
        return this.getAggregateIds(new GetAggregateIds(entityId));
    }

    public Map<String, String> getAggregateIds(GetAggregateIds var1);

    default public List<Relationship> getRelationships(String entityId) {
        return this.getRelationships(new GetRelationships(entityId));
    }

    public List<Relationship> getRelationships(GetRelationships var1);

    @Override
    public void close();
}

