/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.keyvalue.client;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.javaclient.persisting.keyvalue.client.KeyValueClient;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

public class InMemoryKeyValueStore
implements KeyValueClient {
    private final Map<String, Data<byte[]>> values;

    public InMemoryKeyValueStore() {
        this(new ConcurrentHashMap<String, Data<byte[]>>());
    }

    protected InMemoryKeyValueStore(Map<String, Data<byte[]>> map) {
        this.values = map;
    }

    @Override
    public CompletableFuture<Void> putValue(String key, Data<byte[]> value, Guarantee guarantee) {
        this.values.put(key, value);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Boolean> putValueIfAbsent(String key, Data<byte[]> value) {
        return CompletableFuture.completedFuture(this.values.putIfAbsent(key, value) == null);
    }

    @Override
    public Data<byte[]> getValue(String key) {
        return this.values.get(key);
    }

    @Override
    public CompletableFuture<Void> deleteValue(String key, Guarantee guarantee) {
        this.values.remove(key);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public void close() {
    }
}

