/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.search;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.api.search.BulkUpdate;
import io.fluxcapacitor.common.api.search.SearchQuery;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.ClientUtils;
import io.fluxcapacitor.javaclient.modeling.EntityId;
import io.fluxcapacitor.javaclient.modeling.SearchParameters;
import io.fluxcapacitor.javaclient.persisting.search.DocumentSerializer;
import io.fluxcapacitor.javaclient.persisting.search.Search;
import jakarta.validation.constraints.NotNull;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Stream;
import lombok.NonNull;

public interface DocumentStore {
    default public CompletableFuture<Void> index(@NonNull Object object) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (object.getClass().isArray() && !((Class)object.getClass().arrayType()).isPrimitive()) {
            object = Arrays.asList((Object[])object);
        }
        if (object instanceof Collection) {
            Collection collection = object;
            return CompletableFuture.allOf((CompletableFuture[])collection.stream().map(this::index).toArray(CompletableFuture[]::new));
        }
        Class<?> type = object.getClass();
        SearchParameters searchParams = Optional.ofNullable(ClientUtils.getSearchParameters(type)).orElse(SearchParameters.defaultSearchParameters);
        String collection = Optional.ofNullable(searchParams.getCollection()).orElseGet(type::getSimpleName);
        Instant begin = ReflectionUtils.readProperty(searchParams.getTimestampPath(), object).orElse(null);
        Instant end = ReflectionUtils.hasProperty(searchParams.getEndPath(), object) ? (Instant)ReflectionUtils.readProperty(searchParams.getEndPath(), object).orElse(null) : begin;
        String id = ReflectionUtils.getAnnotatedPropertyValue(object, EntityId.class).map(Object::toString).orElseGet(() -> FluxCapacitor.currentIdentityProvider().nextTechnicalId());
        return this.index(object, (Object)id, (Object)collection, begin, end);
    }

    default public CompletableFuture<Void> index(@NonNull Object object, Object collection) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (object.getClass().isArray() && !((Class)object.getClass().arrayType()).isPrimitive()) {
            object = Arrays.asList((Object[])object);
        }
        if (object instanceof Collection) {
            Collection col = object;
            return CompletableFuture.allOf((CompletableFuture[])col.stream().map(v -> this.index(v, collection)).toArray(CompletableFuture[]::new));
        }
        Class<?> type = object.getClass();
        SearchParameters searchParams = Optional.ofNullable(ClientUtils.getSearchParameters(type)).orElse(SearchParameters.defaultSearchParameters);
        Instant begin = ReflectionUtils.readProperty(searchParams.getTimestampPath(), object).orElse(null);
        Instant end = ReflectionUtils.hasProperty(searchParams.getEndPath(), object) ? (Instant)ReflectionUtils.readProperty(searchParams.getEndPath(), object).orElse(null) : begin;
        String id = ReflectionUtils.getAnnotatedPropertyValue(object, EntityId.class).map(Object::toString).orElseGet(() -> FluxCapacitor.currentIdentityProvider().nextTechnicalId());
        return this.index(object, (Object)id, collection, begin, end);
    }

    default public CompletableFuture<Void> index(@NonNull Object object, Object id, Object collection) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        return this.index(object, id, collection, null);
    }

    default public CompletableFuture<Void> index(@NonNull Object object, Object id, Object collection, Instant timestamp) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        return this.index(object, id, collection, timestamp, timestamp, Guarantee.STORED, false);
    }

    default public CompletableFuture<Void> index(@NonNull Object object, Object id, Object collection, Instant begin, Instant end) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        return this.index(object, id, collection, begin, end, Guarantee.STORED, false);
    }

    public CompletableFuture<Void> index(@NotNull Object var1, Object var2, Object var3, Instant var4, Instant var5, Guarantee var6, boolean var7);

    default public CompletableFuture<Void> index(Collection<?> objects, Object collection) {
        return this.index(objects, collection, (? super T v) -> ReflectionUtils.getAnnotatedPropertyValue(v, EntityId.class).map(Object::toString).orElseGet(() -> FluxCapacitor.currentIdentityProvider().nextTechnicalId()));
    }

    default public <T> CompletableFuture<Void> index(Collection<? extends T> objects, Object collection, Function<? super T, ?> idFunction) {
        return this.index(objects, collection, idFunction, (? super T v) -> null);
    }

    default public CompletableFuture<Void> index(Collection<?> objects, Object collection, String idPath, String timestampPath) {
        return this.index(objects, collection, idPath, timestampPath, timestampPath, Guarantee.STORED, false);
    }

    default public CompletableFuture<Void> index(Collection<?> objects, Object collection, String idPath, String beginPath, String endPath) {
        return this.index(objects, collection, idPath, beginPath, endPath, Guarantee.STORED, false);
    }

    public CompletableFuture<Void> index(Collection<?> var1, Object var2, String var3, String var4, String var5, Guarantee var6, boolean var7);

    default public <T> CompletableFuture<Void> index(Collection<? extends T> objects, Object collection, Function<? super T, ?> idFunction, Function<? super T, Instant> timestampFunction) {
        return this.index(objects, collection, idFunction, timestampFunction, timestampFunction, Guarantee.STORED, false);
    }

    default public <T> CompletableFuture<Void> index(Collection<? extends T> objects, Object collection, Function<? super T, ?> idFunction, Function<? super T, Instant> beginFunction, Function<? super T, Instant> endFunction) {
        return this.index(objects, collection, idFunction, beginFunction, endFunction, Guarantee.STORED, false);
    }

    public <T> CompletableFuture<Void> index(Collection<? extends T> var1, Object var2, Function<? super T, ?> var3, Function<? super T, Instant> var4, Function<? super T, Instant> var5, Guarantee var6, boolean var7);

    default public CompletableFuture<Void> indexIfNotExists(Object object, Object collection) {
        return this.indexIfNotExists(object instanceof Collection ? (List<Object>)object : Collections.singletonList(object), collection);
    }

    default public CompletableFuture<Void> indexIfNotExists(Object object, Object id, Object collection) {
        return this.indexIfNotExists(object, id, collection, null);
    }

    default public CompletableFuture<Void> indexIfNotExists(Object object, Object id, Object collection, Instant timestamp) {
        return this.index(object, id, collection, timestamp, timestamp, Guarantee.STORED, true);
    }

    default public CompletableFuture<Void> indexIfNotExists(Object object, Object id, Object collection, Instant begin, Instant end) {
        return this.index(object, id, collection, begin, end, Guarantee.STORED, true);
    }

    default public <T> CompletableFuture<Void> indexIfNotExists(Collection<? extends T> objects, Object collection) {
        return this.indexIfNotExists(objects, collection, (? super T v) -> ReflectionUtils.getAnnotatedPropertyValue(v, EntityId.class).map(Object::toString).orElseGet(() -> FluxCapacitor.currentIdentityProvider().nextTechnicalId()));
    }

    default public <T> CompletableFuture<Void> indexIfNotExists(Collection<? extends T> objects, Object collection, Function<? super T, ?> idFunction) {
        return this.indexIfNotExists(objects, collection, idFunction, (? super T v) -> null);
    }

    default public <T> CompletableFuture<Void> indexIfNotExists(Collection<? extends T> objects, Object collection, String idPath, String timestampPath) {
        return this.index(objects, collection, idPath, timestampPath, timestampPath, Guarantee.STORED, true);
    }

    default public <T> CompletableFuture<Void> indexIfNotExists(Collection<? extends T> objects, Object collection, String idPath, String beginPath, String endPath) {
        return this.index(objects, collection, idPath, beginPath, endPath, Guarantee.STORED, true);
    }

    default public <T> CompletableFuture<Void> indexIfNotExists(Collection<? extends T> objects, Object collection, Function<? super T, ?> idFunction, Function<? super T, Instant> timestampFunction) {
        return this.index(objects, collection, idFunction, timestampFunction, timestampFunction, Guarantee.STORED, true);
    }

    default public <T> CompletableFuture<Void> indexIfNotExists(Collection<? extends T> objects, Object collection, Function<? super T, ?> idFunction, Function<? super T, Instant> beginFunction, Function<? super T, Instant> endFunction) {
        return this.index(objects, collection, idFunction, beginFunction, endFunction, Guarantee.STORED, true);
    }

    default public CompletableFuture<Void> bulkUpdate(Collection<? extends BulkUpdate> updates) {
        return this.bulkUpdate(updates, Guarantee.STORED);
    }

    public CompletableFuture<Void> bulkUpdate(Collection<? extends BulkUpdate> var1, Guarantee var2);

    default public Search search(@NonNull Object collection) {
        Stream<Object> stream;
        if (collection == null) {
            throw new NullPointerException("collection is marked non-null but is null");
        }
        if (collection instanceof Collection) {
            Collection list = (Collection)collection;
            stream = list.stream();
        } else {
            stream = Stream.of(collection);
        }
        List<String> collections = stream.map(this::determineCollection).toList();
        return this.search(SearchQuery.builder().collections(collections));
    }

    public Search search(SearchQuery.Builder var1);

    public <T> Optional<T> fetchDocument(Object var1, Object var2);

    public <T> Optional<T> fetchDocument(Object var1, Object var2, Class<T> var3);

    public CompletableFuture<Void> deleteDocument(Object var1, Object var2);

    public CompletableFuture<Void> deleteCollection(Object var1);

    public CompletableFuture<Void> createAuditTrail(Object var1, Duration var2);

    default public String determineCollection(@NonNull Object c) {
        String string;
        if (c == null) {
            throw new NullPointerException("c is marked non-null but is null");
        }
        Class<?> clazz = ReflectionUtils.ifClass(c);
        if (clazz instanceof Class) {
            Class<?> type = clazz;
            string = ClientUtils.getSearchParameters(type).getCollection();
        } else {
            string = c.toString();
        }
        return string;
    }

    public DocumentSerializer getSerializer();
}

