/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.publishing;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import io.fluxcapacitor.javaclient.publishing.GatewayException;
import io.fluxcapacitor.javaclient.publishing.ResultGateway;
import io.fluxcapacitor.javaclient.publishing.client.GatewayClient;
import io.fluxcapacitor.javaclient.tracking.handling.ResponseMapper;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;

public class DefaultResultGateway
implements ResultGateway {
    private final GatewayClient client;
    private final Serializer serializer;
    private final DispatchInterceptor dispatchInterceptor;
    private final ResponseMapper responseMapper;

    @Override
    public CompletableFuture<Void> respond(Object payload, Metadata metadata, String target, Integer requestId, Guarantee guarantee) {
        try {
            SerializedMessage serializedMessage = this.interceptDispatch(payload, metadata);
            if (serializedMessage == null) {
                return CompletableFuture.completedFuture(null);
            }
            serializedMessage.setTarget(target);
            serializedMessage.setRequestId(requestId);
            return this.client.append(guarantee, serializedMessage);
        }
        catch (Exception e) {
            throw new GatewayException(String.format("Failed to send response %s", payload == null || ReflectionUtils.ifClass(payload) != null ? Objects.toString(payload) : payload.getClass()), e);
        }
    }

    protected SerializedMessage interceptDispatch(Object payload, Metadata metadata) {
        SerializedMessage serializedMessage;
        Message message = this.dispatchInterceptor.interceptDispatch(this.responseMapper.map(payload, metadata), MessageType.RESULT);
        SerializedMessage serializedMessage2 = serializedMessage = message == null ? null : this.dispatchInterceptor.modifySerializedMessage(message.serialize(this.serializer), message, MessageType.RESULT);
        if (serializedMessage != null) {
            this.dispatchInterceptor.monitorDispatch(message, MessageType.RESULT);
        }
        return serializedMessage;
    }

    @ConstructorProperties(value={"client", "serializer", "dispatchInterceptor", "responseMapper"})
    @Generated
    public DefaultResultGateway(GatewayClient client, Serializer serializer, DispatchInterceptor dispatchInterceptor, ResponseMapper responseMapper) {
        this.client = client;
        this.serializer = serializer;
        this.dispatchInterceptor = dispatchInterceptor;
        this.responseMapper = responseMapper;
    }
}

