/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.publishing.correlation;

import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.publishing.correlation.CorrelationDataProvider;
import io.fluxcapacitor.javaclient.tracking.Tracker;
import io.fluxcapacitor.javaclient.tracking.handling.Invocation;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public enum DefaultCorrelationDataProvider implements CorrelationDataProvider
{
    INSTANCE;

    private final String applicationIdKey = "$applicationId";
    private final String clientIdKey = "$clientId";
    private final String clientNameKey = "$clientName";
    private final String consumerKey = "$consumer";
    private final String trackerKey = "$tracker";
    private final String correlationIdKey = "$correlationId";
    private final String traceIdKey = "$traceId";
    private final String triggerKey = "$trigger";
    private final String triggerTypeKey = "$triggerType";
    private final String invocationKey = "$invocation";

    @Override
    public Map<String, String> getCorrelationData(DeserializingMessage currentMessage) {
        HashMap<String, String> result = new HashMap<String, String>();
        FluxCapacitor.getOptionally().ifPresent(f -> {
            Optional.ofNullable(f.client().applicationId()).ifPresent(applicationId -> result.put("$applicationId", (String)applicationId));
            result.put("$clientId", f.client().id());
            result.put("$clientName", f.client().name());
        });
        Tracker.current().ifPresent(t -> {
            result.put("$consumer", t.getName());
            result.put("$tracker", t.getTrackerId());
        });
        Optional.ofNullable(currentMessage).ifPresent(m -> {
            String correlationId = Optional.ofNullable(m.getIndex()).map(Object::toString).orElse(m.getMessageId());
            result.put(this.correlationIdKey, correlationId);
            result.put("$traceId", currentMessage.getMetadata().getOrDefault("$traceId", correlationId));
            result.put("$trigger", m.getType());
            result.put("$triggerType", m.getMessageType().name());
            result.putAll(currentMessage.getMetadata().getTraceEntries());
        });
        Optional.ofNullable(Invocation.getCurrent()).ifPresent(i -> result.put("$invocation", i.getId()));
        return result;
    }

    @Generated
    public String getApplicationIdKey() {
        return this.applicationIdKey;
    }

    @Generated
    public String getClientIdKey() {
        return this.clientIdKey;
    }

    @Generated
    public String getClientNameKey() {
        return this.clientNameKey;
    }

    @Generated
    public String getConsumerKey() {
        return this.consumerKey;
    }

    @Generated
    public String getTrackerKey() {
        return this.trackerKey;
    }

    @Generated
    public String getCorrelationIdKey() {
        return this.correlationIdKey;
    }

    @Generated
    public String getTraceIdKey() {
        return this.traceIdKey;
    }

    @Generated
    public String getTriggerKey() {
        return this.triggerKey;
    }

    @Generated
    public String getTriggerTypeKey() {
        return this.triggerTypeKey;
    }

    @Generated
    public String getInvocationKey() {
        return this.invocationKey;
    }
}

