/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.scheduling;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.api.scheduling.SerializedSchedule;
import io.fluxcapacitor.common.handling.HandlerFilter;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.modeling.Entity;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import io.fluxcapacitor.javaclient.scheduling.Schedule;
import io.fluxcapacitor.javaclient.scheduling.ScheduledCommand;
import io.fluxcapacitor.javaclient.scheduling.Scheduler;
import io.fluxcapacitor.javaclient.scheduling.SchedulerException;
import io.fluxcapacitor.javaclient.scheduling.client.SchedulingClient;
import io.fluxcapacitor.javaclient.tracking.IndexUtils;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerRegistry;
import io.fluxcapacitor.javaclient.tracking.handling.HasLocalHandlers;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import lombok.Generated;

public class DefaultScheduler
implements Scheduler,
HasLocalHandlers {
    private final SchedulingClient client;
    private final Serializer serializer;
    private final DispatchInterceptor dispatchInterceptor;
    private final DispatchInterceptor commandDispatchInterceptor;
    private final HandlerRegistry localHandlerRegistry;

    @Override
    public CompletableFuture<Void> schedule(Schedule message, boolean ifAbsent, Guarantee guarantee) {
        if (Entity.isLoading()) {
            return CompletableFuture.completedFuture(null);
        }
        if ((message = (Schedule)this.dispatchInterceptor.interceptDispatch(message, MessageType.SCHEDULE)) == null) {
            return CompletableFuture.completedFuture(null);
        }
        SerializedMessage serializedMessage = this.dispatchInterceptor.modifySerializedMessage(message.serialize(this.serializer), message, MessageType.SCHEDULE);
        if (serializedMessage == null) {
            return CompletableFuture.completedFuture(null);
        }
        this.dispatchInterceptor.monitorDispatch(message, MessageType.SCHEDULE);
        return this.client.schedule(guarantee, new SerializedSchedule(message.getScheduleId(), message.getDeadline().toEpochMilli(), serializedMessage, ifAbsent));
    }

    @Override
    public CompletableFuture<Void> scheduleCommand(Schedule schedule, boolean ifAbsent, Guarantee guarantee) {
        if (Entity.isLoading()) {
            return CompletableFuture.completedFuture(null);
        }
        Schedule commandMessage = schedule.withMessageId(FluxCapacitor.currentIdentityProvider().nextTechnicalId());
        Message intercepted = this.commandDispatchInterceptor.interceptDispatch(commandMessage, MessageType.COMMAND);
        if (intercepted == null) {
            return CompletableFuture.completedFuture(null);
        }
        SerializedMessage serializedCommand = this.commandDispatchInterceptor.modifySerializedMessage((commandMessage = commandMessage.withPayload(intercepted.getPayload()).withMetadata(intercepted.getMetadata())).serialize(this.serializer), commandMessage, MessageType.COMMAND);
        if (serializedCommand == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.schedule(schedule.withPayload(new ScheduledCommand(serializedCommand)).addMetadata("$commandType", (Object)schedule.getPayloadClass().getName()), ifAbsent, guarantee);
    }

    @Override
    public void cancelSchedule(String scheduleId) {
        try {
            if (Entity.isLoading()) {
                return;
            }
            this.client.cancelSchedule(scheduleId).get();
        }
        catch (Exception e) {
            throw new SchedulerException(String.format("Failed to cancel schedule with id %s", scheduleId), e);
        }
    }

    @Override
    public Optional<Schedule> getSchedule(String scheduleId) {
        return Optional.ofNullable(this.client.getSchedule(scheduleId)).flatMap(s -> this.serializer.deserializeMessages(Stream.of(s.getMessage()), MessageType.SCHEDULE).findFirst().map(DeserializingMessage::toMessage).map(m -> new Schedule(m.getPayload(), m.getMetadata(), m.getMessageId(), m.getTimestamp(), s.getScheduleId(), Instant.ofEpochMilli(s.getTimestamp()))));
    }

    public void handleLocally(Schedule schedule) {
        SerializedMessage serializedMessage = schedule.serialize(this.serializer);
        serializedMessage.setIndex(IndexUtils.indexFromTimestamp(schedule.getDeadline()));
        Optional<CompletableFuture<Object>> result = this.localHandlerRegistry.handle(new DeserializingMessage(serializedMessage, type -> this.serializer.convert(schedule.getPayload(), type), MessageType.SCHEDULE));
        if (result.isPresent()) {
            result.get().get();
        }
    }

    @ConstructorProperties(value={"client", "serializer", "dispatchInterceptor", "commandDispatchInterceptor", "localHandlerRegistry"})
    @Generated
    public DefaultScheduler(SchedulingClient client, Serializer serializer, DispatchInterceptor dispatchInterceptor, DispatchInterceptor commandDispatchInterceptor, HandlerRegistry localHandlerRegistry) {
        this.client = client;
        this.serializer = serializer;
        this.dispatchInterceptor = dispatchInterceptor;
        this.commandDispatchInterceptor = commandDispatchInterceptor;
        this.localHandlerRegistry = localHandlerRegistry;
    }

    @Generated
    public Optional<CompletableFuture<Object>> handle(DeserializingMessage message) {
        return this.localHandlerRegistry.handle(message);
    }

    @Generated
    public HandlerRegistry andThen(HandlerRegistry next) {
        return this.localHandlerRegistry.andThen(next);
    }

    @Generated
    public HandlerRegistry orThen(HandlerRegistry next) {
        return this.localHandlerRegistry.orThen(next);
    }

    @Override
    @Generated
    public Registration registerHandler(Object target) {
        return this.localHandlerRegistry.registerHandler(target);
    }

    @Override
    @Generated
    public void setSelfHandlerFilter(HandlerFilter selfHandlerFilter) {
        this.localHandlerRegistry.setSelfHandlerFilter(selfHandlerFilter);
    }

    @Override
    @Generated
    public Registration registerHandler(Object target, HandlerFilter handlerFilter) {
        return this.localHandlerRegistry.registerHandler(target, handlerFilter);
    }
}

