/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.scheduling;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.UnknownTypeStrategy;
import io.fluxcapacitor.javaclient.scheduling.ScheduledCommand;
import io.fluxcapacitor.javaclient.tracking.Consumer;
import io.fluxcapacitor.javaclient.tracking.handling.HandleSchedule;
import java.util.stream.Stream;

@Consumer(name="ScheduledCommandHandler", typeFilter="io.fluxcapacitor.javaclient.scheduling.ScheduledCommand")
public class ScheduledCommandHandler {
    @HandleSchedule
    void handle(ScheduledCommand schedule) {
        SerializedMessage command = schedule.getCommand();
        command.setTimestamp(FluxCapacitor.currentTime().toEpochMilli());
        Object[] commands = FluxCapacitor.get().serializer().deserializeMessages(Stream.of(command), MessageType.COMMAND, UnknownTypeStrategy.IGNORE).map(DeserializingMessage::toMessage).toArray();
        if (commands.length != 0) {
            FluxCapacitor.sendAndForgetCommands(commands);
        } else {
            FluxCapacitor.get().client().getGatewayClient(MessageType.COMMAND).append(Guarantee.NONE, command);
        }
    }
}

