/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.scheduling;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.scheduling.CronExpression;
import io.fluxcapacitor.javaclient.scheduling.Periodic;
import io.fluxcapacitor.javaclient.scheduling.Schedule;
import io.fluxcapacitor.javaclient.scheduling.SchedulerException;
import io.micrometer.common.util.StringUtils;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public interface Scheduler {
    default public String schedulePeriodic(Object value) {
        return this.schedulePeriodic(value, null);
    }

    default public String schedulePeriodic(Object value, String scheduleId) {
        Class<?> clazz;
        if (value instanceof Message) {
            Message m = (Message)value;
            clazz = m.getPayloadClass();
        } else {
            clazz = value.getClass();
        }
        Periodic periodic = (Periodic)ReflectionUtils.getTypeAnnotation(clazz, Periodic.class);
        if (periodic == null) {
            throw new IllegalArgumentException("Could not determine when to schedule this value");
        }
        Instant nextDeadline = Optional.ofNullable(Scheduler.nextDeadline(periodic.cron(), periodic.timeZone())).orElseGet(() -> FluxCapacitor.currentTime().plusMillis(periodic.timeUnit().toMillis(periodic.initialDelay() < 0L ? periodic.delay() : periodic.initialDelay())));
        this.schedule(value, Optional.ofNullable(scheduleId).or(() -> Optional.of(periodic.scheduleId()).filter(s -> !s.isBlank())).orElseGet(FluxCapacitor::generateId), nextDeadline);
        return scheduleId;
    }

    default public String schedule(Object schedule, Instant deadline) {
        String scheduleId = FluxCapacitor.currentIdentityProvider().nextTechnicalId();
        this.schedule(schedule, scheduleId, deadline);
        return scheduleId;
    }

    default public String schedule(Object schedule, Duration delay) {
        return this.schedule(schedule, FluxCapacitor.currentTime().plus(delay));
    }

    default public void schedule(Object schedule, String scheduleId, Duration delay) {
        this.schedule(schedule, scheduleId, FluxCapacitor.currentTime().plus(delay));
    }

    default public void schedule(Object schedulePayload, Metadata metadata, String scheduleId, Instant deadline) {
        this.schedule((Object)new Message(schedulePayload, metadata), scheduleId, deadline);
    }

    default public void schedule(Object schedulePayload, Metadata metadata, String scheduleId, Duration delay) {
        this.schedule((Object)new Message(schedulePayload, metadata), scheduleId, delay);
    }

    default public void schedule(Object schedule, String scheduleId, Instant deadline) {
        if (schedule instanceof Message) {
            Message message = (Message)schedule;
            this.schedule(new Schedule(message.getPayload(), message.getMetadata(), message.getMessageId(), message.getTimestamp(), scheduleId, deadline));
        } else {
            this.schedule(new Schedule(schedule, scheduleId, deadline));
        }
    }

    default public void schedule(Schedule message) {
        this.schedule(message, false);
    }

    default public void schedule(Schedule message, boolean ifAbsent) {
        try {
            this.schedule(message, ifAbsent, Guarantee.SENT).get();
        }
        catch (Throwable e) {
            throw new SchedulerException(String.format("Failed to schedule message %s for %s", message.getPayload(), message.getDeadline()), e);
        }
    }

    public CompletableFuture<Void> schedule(Schedule var1, boolean var2, Guarantee var3);

    default public String scheduleCommand(Object schedule, Instant deadline) {
        String scheduleId = FluxCapacitor.currentIdentityProvider().nextTechnicalId();
        this.scheduleCommand(schedule, scheduleId, deadline);
        return scheduleId;
    }

    default public String scheduleCommand(Object schedule, Duration delay) {
        return this.scheduleCommand(schedule, FluxCapacitor.currentTime().plus(delay));
    }

    default public void scheduleCommand(Object schedule, String scheduleId, Duration delay) {
        this.scheduleCommand(schedule, scheduleId, FluxCapacitor.currentTime().plus(delay));
    }

    default public void scheduleCommand(Object schedulePayload, Metadata metadata, String scheduleId, Instant deadline) {
        this.scheduleCommand((Object)new Message(schedulePayload, metadata), scheduleId, deadline);
    }

    default public void scheduleCommand(Object schedulePayload, Metadata metadata, String scheduleId, Duration delay) {
        this.scheduleCommand((Object)new Message(schedulePayload, metadata), scheduleId, delay);
    }

    default public void scheduleCommand(Object schedule, String scheduleId, Instant deadline) {
        if (schedule instanceof Message) {
            Message message = (Message)schedule;
            this.scheduleCommand(new Schedule(message.getPayload(), message.getMetadata(), message.getMessageId(), message.getTimestamp(), scheduleId, deadline));
        } else {
            this.scheduleCommand(new Schedule(schedule, scheduleId, deadline));
        }
    }

    default public void scheduleCommand(Schedule message) {
        this.scheduleCommand(message, false);
    }

    default public void scheduleCommand(Schedule message, boolean ifAbsent) {
        try {
            this.scheduleCommand(message, ifAbsent, Guarantee.SENT).get();
        }
        catch (Throwable e) {
            throw new SchedulerException(String.format("Failed to schedule command %s for %s", message.getPayload(), message.getDeadline()), e);
        }
    }

    public CompletableFuture<Void> scheduleCommand(Schedule var1, boolean var2, Guarantee var3);

    public void cancelSchedule(String var1);

    public Optional<Schedule> getSchedule(String var1);

    private static Instant nextDeadline(String cronSchedule, String timeZone) {
        if (StringUtils.isBlank((String)cronSchedule)) {
            return null;
        }
        return CronExpression.parseCronExpression(cronSchedule).nextTimeAfter(FluxCapacitor.currentTime().atZone(ZoneId.of(timeZone))).toInstant();
    }
}

