/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.common.handling.HandlerFilter;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.ClientUtils;
import io.fluxcapacitor.javaclient.common.exception.FunctionalException;
import io.fluxcapacitor.javaclient.common.exception.TechnicalException;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.publishing.ResultGateway;
import io.fluxcapacitor.javaclient.tracking.BatchInterceptor;
import io.fluxcapacitor.javaclient.tracking.BatchProcessingException;
import io.fluxcapacitor.javaclient.tracking.ConsumerConfiguration;
import io.fluxcapacitor.javaclient.tracking.Tracking;
import io.fluxcapacitor.javaclient.tracking.TrackingException;
import io.fluxcapacitor.javaclient.tracking.client.DefaultTracker;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerFactory;
import io.fluxcapacitor.javaclient.tracking.handling.Invocation;
import io.fluxcapacitor.javaclient.web.WebRequest;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTracking
implements Tracking {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTracking.class);
    @Generated
    private final Object $lock = new Object[0];
    private final HandlerFilter handlerFilter = ClientUtils::isTrackingHandler;
    private final MessageType messageType;
    private final ResultGateway resultGateway;
    private final List<ConsumerConfiguration> configurations;
    private final List<? extends BatchInterceptor> generalBatchInterceptors;
    private final Serializer serializer;
    private final HandlerFactory handlerFactory;
    private final Set<ConsumerConfiguration> startedConfigurations = new HashSet<ConsumerConfiguration>();
    private final Collection<CompletableFuture<?>> outstandingRequests = new CopyOnWriteArrayList();
    private final AtomicReference<Registration> shutdownFunction = new AtomicReference<Registration>(Registration.noOp());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Registration start(FluxCapacitor fluxCapacitor, List<?> handlers) {
        Object object = this.$lock;
        synchronized (object) {
            return fluxCapacitor.apply(fc -> {
                Map<ConsumerConfiguration, List> consumers = this.assignHandlersToConsumers(handlers).entrySet().stream().flatMap(e -> {
                    List converted = ((List)e.getValue()).stream().flatMap(target -> {
                        if (target instanceof Handler) {
                            return Stream.of((Handler)target);
                        }
                        return this.handlerFactory.createHandler(target, this.handlerFilter, ((ConsumerConfiguration)e.getKey()).getHandlerInterceptors()).stream();
                    }).collect(Collectors.toList());
                    return converted.isEmpty() ? Stream.empty() : Stream.of(new AbstractMap.SimpleEntry((ConsumerConfiguration)e.getKey(), converted));
                }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                if (!Collections.disjoint(consumers.keySet(), this.startedConfigurations)) {
                    throw new TrackingException("Failed to start tracking. Consumers for some handlers have already started tracking.");
                }
                this.startedConfigurations.addAll(consumers.keySet());
                Registration registration = consumers.entrySet().stream().map(e -> this.startTracking((ConsumerConfiguration)e.getKey(), (List)e.getValue(), (FluxCapacitor)fc)).reduce(Registration::merge).orElse(Registration.noOp());
                this.shutdownFunction.updateAndGet(r -> r.merge(registration));
                return registration;
            });
        }
    }

    private Map<ConsumerConfiguration, List<Object>> assignHandlersToConsumers(List<?> handlers) {
        ArrayList unassignedHandlers = new ArrayList(handlers);
        LinkedHashMap configurations = Stream.concat(ConsumerConfiguration.configurations(handlers.stream().map(HandlerFactory::getTargetClass).collect(Collectors.toList())), this.configurations.stream()).sorted(Comparator.comparing(ConsumerConfiguration::exclusive)).map(config -> config.toBuilder().batchInterceptors(this.generalBatchInterceptors).build()).collect(Collectors.toMap(ConsumerConfiguration::getName, Function.identity(), (a, b) -> {
            if (a.equals(b)) {
                return a.toBuilder().handlerFilter(a.getHandlerFilter().or(b.getHandlerFilter())).build();
            }
            throw new IllegalStateException(String.format("Consumer name %s is already in use", a.getName()));
        }, LinkedHashMap::new));
        Map<ConsumerConfiguration, List<Object>> result = configurations.values().stream().map(config -> {
            List<Object> matches = unassignedHandlers.stream().filter(h -> config.getHandlerFilter().test(h)).toList();
            if (config.exclusive()) {
                unassignedHandlers.removeAll(matches);
            }
            return Map.entry(config, matches);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        unassignedHandlers.removeAll(result.values().stream().flatMap(Collection::stream).distinct().toList());
        unassignedHandlers.forEach(h -> {
            throw new TrackingException(String.format("Failed to find consumer for %s", h));
        });
        return result;
    }

    protected Registration startTracking(ConsumerConfiguration configuration, List<Handler<DeserializingMessage>> handlers, FluxCapacitor fluxCapacitor) {
        return DefaultTracker.start(this.createConsumer(configuration, handlers), this.messageType, configuration, fluxCapacitor);
    }

    protected Consumer<List<SerializedMessage>> createConsumer(ConsumerConfiguration config, List<Handler<DeserializingMessage>> handlers) {
        return serializedMessages -> {
            try {
                DeserializingMessage.handleBatch(this.serializer.deserializeMessages(serializedMessages.stream(), this.messageType)).forEach(m -> handlers.forEach(h -> this.tryHandle((DeserializingMessage)m, (Handler<DeserializingMessage>)h, config, true)));
            }
            catch (BatchProcessingException e) {
                throw e;
            }
            catch (Throwable e) {
                config.getErrorHandler().handleError(e, String.format("Failed to handle batch of consumer %s", config.getName()), () -> DeserializingMessage.handleBatch(this.serializer.deserializeMessages(serializedMessages.stream(), this.messageType)).forEach(m -> handlers.forEach(h -> this.tryHandle((DeserializingMessage)m, (Handler<DeserializingMessage>)h, config, false))));
            }
        };
    }

    protected void tryHandle(DeserializingMessage message, Handler<DeserializingMessage> handler, ConsumerConfiguration config, boolean reportResult) {
        this.getInvoker(message, handler, config).ifPresent(h -> {
            Object result;
            try {
                result = this.handle(message, (HandlerInvoker)h, handler, config);
            }
            catch (Throwable e) {
                try {
                    this.stopTracker(message, handler, e);
                    return;
                }
                finally {
                    if (reportResult) {
                        this.reportResult(e, (HandlerInvoker)h, message, config);
                    }
                }
            }
            try {
                if (reportResult) {
                    this.reportResult(result, (HandlerInvoker)h, message, config);
                }
            }
            catch (Throwable e) {
                this.stopTracker(message, handler, e);
            }
        });
    }

    protected Optional<HandlerInvoker> getInvoker(DeserializingMessage message, Handler<DeserializingMessage> handler, ConsumerConfiguration config) {
        try {
            return handler.getInvoker(message);
        }
        catch (Throwable e) {
            try {
                Object retryResult = config.getErrorHandler().handleError(e, String.format("Failed to check if handler %s is able to handle %s", handler, message), () -> handler.getInvoker(message));
                return retryResult instanceof Optional ? (Optional)retryResult : Optional.empty();
            }
            catch (Throwable e2) {
                this.stopTracker(message, handler, e2);
                return Optional.empty();
            }
        }
    }

    protected Object handle(DeserializingMessage message, HandlerInvoker h, Handler<DeserializingMessage> handler, ConsumerConfiguration config) {
        try {
            CompletionStage<Object> result = Invocation.performInvocation(h::invoke);
            return result instanceof CompletionStage ? ((CompletionStage)result).exceptionally(e -> message.apply(m -> this.processError((Throwable)e, message, h, handler, config))) : result;
        }
        catch (Throwable e2) {
            return this.processError(e2, message, h, handler, config);
        }
    }

    protected Object processError(Throwable e, DeserializingMessage message, HandlerInvoker h, Handler<DeserializingMessage> handler, ConsumerConfiguration config) {
        return config.getErrorHandler().handleError(ObjectUtils.unwrapException(e), String.format("Handler %s failed to handle a %s", handler, message), () -> Invocation.performInvocation(h::invoke));
    }

    protected void reportResult(Object result, HandlerInvoker h, DeserializingMessage message, ConsumerConfiguration config) {
        if (result instanceof CompletionStage) {
            CompletionStage s = (CompletionStage)result;
            s.whenComplete((r, e) -> {
                try {
                    message.run(m -> this.reportResult(Optional.ofNullable(e).orElse((Throwable)r), h, message, config));
                }
                finally {
                    if (e != null) {
                        this.close();
                    }
                }
            });
        } else if (this.shouldSendResponse(h, message, result, config)) {
            if (result instanceof Throwable && !((result = ObjectUtils.unwrapException((Throwable)result)) instanceof FunctionalException)) {
                result = new TechnicalException(String.format("Handler %s failed to handle a %s", h.getMethod(), message), (Throwable)result);
            }
            SerializedMessage request = message.getSerializedObject();
            try {
                this.resultGateway.respond(result, request.getSource(), request.getRequestId());
            }
            catch (Throwable e2) {
                Object response = result;
                config.getErrorHandler().handleError(e2, String.format("Failed to send result of a %s from handler %s", message, h.getMethod()), () -> this.resultGateway.respond(response, request.getSource(), request.getRequestId()));
            }
        }
    }

    protected boolean shouldSendResponse(HandlerInvoker invoker, DeserializingMessage request, Object result, ConsumerConfiguration config) {
        if (!request.getMessageType().isRequest() || config.passive() || invoker.isPassive()) {
            return false;
        }
        if (request.getMessageType() == MessageType.WEBREQUEST) {
            switch (WebRequest.getMethod(request.getMetadata())) {
                case WS_HANDSHAKE: 
                case WS_OPEN: 
                case WS_MESSAGE: {
                    return true;
                }
            }
        }
        return request.getSerializedObject().getRequestId() != null;
    }

    protected void stopTracker(DeserializingMessage message, Handler<DeserializingMessage> handler, Throwable e) {
        throw e instanceof BatchProcessingException ? new BatchProcessingException(String.format("Handler %s failed to handle a %s", handler, message), e.getCause(), ((BatchProcessingException)e).getMessageIndex()) : new BatchProcessingException(message.getIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.$lock;
        synchronized (object) {
            this.shutdownFunction.get().merge(() -> ClientUtils.waitForResults(Duration.ofSeconds(2L), this.outstandingRequests)).cancel();
        }
    }

    @ConstructorProperties(value={"messageType", "resultGateway", "configurations", "generalBatchInterceptors", "serializer", "handlerFactory"})
    @Generated
    public DefaultTracking(MessageType messageType, ResultGateway resultGateway, List<ConsumerConfiguration> configurations, List<? extends BatchInterceptor> generalBatchInterceptors, Serializer serializer, HandlerFactory handlerFactory) {
        this.messageType = messageType;
        this.resultGateway = resultGateway;
        this.configurations = configurations;
        this.generalBatchInterceptors = generalBatchInterceptors;
        this.serializer = serializer;
        this.handlerFactory = handlerFactory;
    }
}

