/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking;

import io.fluxcapacitor.javaclient.common.exception.FunctionalException;
import io.fluxcapacitor.javaclient.tracking.ErrorHandler;
import java.beans.ConstructorProperties;
import java.util.concurrent.Callable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrowingErrorHandler
implements ErrorHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThrowingErrorHandler.class);
    private final boolean logFunctionalErrors;
    private final boolean logTechnicalErrors;

    public ThrowingErrorHandler() {
        this(true, true);
    }

    @Override
    public Object handleError(Throwable error, String errorMessage, Callable<?> retryFunction) {
        this.logError(error, errorMessage);
        throw error;
    }

    protected void logError(Throwable error, String errorMessage) {
        if (!(error instanceof FunctionalException)) {
            if (this.logTechnicalErrors) {
                log.error("{}. Propagating error...", (Object)errorMessage, (Object)error);
            }
        } else if (this.logFunctionalErrors) {
            log.error("{}. Propagating error...", (Object)errorMessage, (Object)error);
        }
    }

    @ConstructorProperties(value={"logFunctionalErrors", "logTechnicalErrors"})
    @Generated
    public ThrowingErrorHandler(boolean logFunctionalErrors, boolean logTechnicalErrors) {
        this.logFunctionalErrors = logFunctionalErrors;
        this.logTechnicalErrors = logTechnicalErrors;
    }
}

