/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling;

import io.fluxcapacitor.common.MemoizingSupplier;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.handling.DefaultHandler;
import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.common.handling.HandlerConfiguration;
import io.fluxcapacitor.common.handling.HandlerFilter;
import io.fluxcapacitor.common.handling.HandlerInspector;
import io.fluxcapacitor.common.handling.HandlerMatcher;
import io.fluxcapacitor.common.handling.MessageFilter;
import io.fluxcapacitor.common.handling.ParameterResolver;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.common.ClientUtils;
import io.fluxcapacitor.javaclient.common.HasMessage;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.modeling.HandlerRepository;
import io.fluxcapacitor.javaclient.tracking.TrackSelf;
import io.fluxcapacitor.javaclient.tracking.handling.HandleCommand;
import io.fluxcapacitor.javaclient.tracking.handling.HandleError;
import io.fluxcapacitor.javaclient.tracking.handling.HandleEvent;
import io.fluxcapacitor.javaclient.tracking.handling.HandleMetrics;
import io.fluxcapacitor.javaclient.tracking.handling.HandleNotification;
import io.fluxcapacitor.javaclient.tracking.handling.HandleQuery;
import io.fluxcapacitor.javaclient.tracking.handling.HandleResult;
import io.fluxcapacitor.javaclient.tracking.handling.HandleSchedule;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerDecorator;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerFactory;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerInterceptor;
import io.fluxcapacitor.javaclient.tracking.handling.PayloadFilter;
import io.fluxcapacitor.javaclient.tracking.handling.SegmentFilter;
import io.fluxcapacitor.javaclient.tracking.handling.Stateful;
import io.fluxcapacitor.javaclient.tracking.handling.StatefulHandler;
import io.fluxcapacitor.javaclient.web.HandleDelete;
import io.fluxcapacitor.javaclient.web.HandleGet;
import io.fluxcapacitor.javaclient.web.HandleHead;
import io.fluxcapacitor.javaclient.web.HandleOptions;
import io.fluxcapacitor.javaclient.web.HandlePatch;
import io.fluxcapacitor.javaclient.web.HandlePost;
import io.fluxcapacitor.javaclient.web.HandlePut;
import io.fluxcapacitor.javaclient.web.HandleSocketClose;
import io.fluxcapacitor.javaclient.web.HandleSocketHandshake;
import io.fluxcapacitor.javaclient.web.HandleSocketMessage;
import io.fluxcapacitor.javaclient.web.HandleSocketOpen;
import io.fluxcapacitor.javaclient.web.HandleSocketPong;
import io.fluxcapacitor.javaclient.web.HandleTrace;
import io.fluxcapacitor.javaclient.web.HandleWeb;
import io.fluxcapacitor.javaclient.web.HandleWebResponse;
import io.fluxcapacitor.javaclient.web.HttpRequestMethod;
import io.fluxcapacitor.javaclient.web.WebHandlerMatcher;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;

public class DefaultHandlerFactory
implements HandlerFactory {
    private final MessageType messageType;
    private final HandlerDecorator defaultDecorator;
    private final List<ParameterResolver<? super DeserializingMessage>> parameterResolvers;
    private final MessageFilter<? super DeserializingMessage> messageFilter;
    private final Class<? extends Annotation> handlerAnnotation;
    private final Function<Class<?>, HandlerRepository> handlerRepositorySupplier;

    public DefaultHandlerFactory(MessageType messageType, HandlerDecorator defaultDecorator, List<ParameterResolver<? super DeserializingMessage>> parameterResolvers, Function<Class<?>, HandlerRepository> handlerRepositorySupplier) {
        this.messageType = messageType;
        this.defaultDecorator = defaultDecorator;
        this.parameterResolvers = parameterResolvers;
        this.handlerRepositorySupplier = handlerRepositorySupplier;
        this.handlerAnnotation = this.getHandlerAnnotation(messageType);
        this.messageFilter = this.defaultMessageFilter();
    }

    public DefaultHandlerFactory(HttpRequestMethod httpRequestMethod, HandlerDecorator defaultDecorator, List<ParameterResolver<? super DeserializingMessage>> parameterResolvers, Function<Class<?>, HandlerRepository> handlerRepositorySupplier) {
        this.messageType = MessageType.WEBREQUEST;
        this.defaultDecorator = defaultDecorator;
        this.parameterResolvers = parameterResolvers;
        this.handlerRepositorySupplier = handlerRepositorySupplier;
        this.handlerAnnotation = this.getHandlerAnnotation(httpRequestMethod);
        this.messageFilter = this.defaultMessageFilter();
    }

    @Override
    public Optional<Handler<DeserializingMessage>> createHandler(Object target, HandlerFilter handlerFilter, List<HandlerInterceptor> extraInterceptors) {
        Class<?> targetClass = HandlerFactory.getTargetClass(target);
        HandlerDecorator handlerDecorator = Stream.concat(extraInterceptors.stream(), Stream.of(this.defaultDecorator)).reduce(HandlerDecorator::andThen).orElseThrow();
        return Optional.of(this.handlerAnnotation).map(a -> HandlerConfiguration.builder().methodAnnotation((Class<Annotation>)a).handlerFilter(handlerFilter).messageFilter(this.messageFilter).build()).filter(config -> HandlerInspector.hasHandlerMethods(targetClass, config)).map(config -> this.buildHandler(target, (HandlerConfiguration<DeserializingMessage>)config)).map(handlerDecorator::wrap);
    }

    private Handler<DeserializingMessage> buildHandler(@NonNull Object target, HandlerConfiguration<DeserializingMessage> config) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        Class<?> clazz = ReflectionUtils.ifClass(target);
        if (clazz instanceof Class) {
            Class<?> targetClass = clazz;
            Stateful handler = (Stateful)ReflectionUtils.getTypeAnnotation(targetClass, Stateful.class);
            if (handler != null) {
                return new StatefulHandler(targetClass, this.createHandlerMatcher(targetClass, config), this.handlerRepositorySupplier.apply(targetClass));
            }
            Optional trackSelf = Optional.ofNullable(ReflectionUtils.getTypeAnnotation(targetClass, TrackSelf.class)).or(() -> Optional.ofNullable(targetClass.getPackage()).flatMap(p -> ReflectionUtils.getPackageAnnotation(p, TrackSelf.class)));
            if (trackSelf.isPresent()) {
                MessageFilter<DeserializingMessage> selfFilter = (message, method, handlerAnnotation) -> targetClass.isAssignableFrom(message.getPayloadClass());
                config = config.toBuilder().messageFilter(selfFilter.and(config.messageFilter())).build();
                return new DefaultHandler<DeserializingMessage>(targetClass, DeserializingMessage::getPayload, this.createHandlerMatcher(targetClass, config));
            }
            MemoizingSupplier<Object> instanceSupplier = ClientUtils.memoize(() -> ReflectionUtils.asInstance(targetClass));
            return new DefaultHandler<DeserializingMessage>(targetClass, m -> targetClass.equals(m.getPayloadClass()) ? m.getPayload() : instanceSupplier.get(), this.createHandlerMatcher(targetClass, config));
        }
        Class<?> targetClass = target.getClass();
        return new DefaultHandler<DeserializingMessage>(targetClass, m -> target, this.createHandlerMatcher(targetClass, config));
    }

    protected Class<? extends Annotation> getHandlerAnnotation(MessageType messageType) {
        return switch (messageType) {
            default -> throw new MatchException(null, null);
            case MessageType.COMMAND -> HandleCommand.class;
            case MessageType.EVENT -> HandleEvent.class;
            case MessageType.NOTIFICATION -> HandleNotification.class;
            case MessageType.QUERY -> HandleQuery.class;
            case MessageType.RESULT -> HandleResult.class;
            case MessageType.ERROR -> HandleError.class;
            case MessageType.SCHEDULE -> HandleSchedule.class;
            case MessageType.METRICS -> HandleMetrics.class;
            case MessageType.WEBREQUEST -> HandleWeb.class;
            case MessageType.WEBRESPONSE -> HandleWebResponse.class;
        };
    }

    protected Class<? extends Annotation> getHandlerAnnotation(HttpRequestMethod requestMethod) {
        return switch (requestMethod) {
            default -> throw new MatchException(null, null);
            case HttpRequestMethod.GET -> HandleGet.class;
            case HttpRequestMethod.POST -> HandlePost.class;
            case HttpRequestMethod.PUT -> HandlePut.class;
            case HttpRequestMethod.PATCH -> HandlePatch.class;
            case HttpRequestMethod.DELETE -> HandleDelete.class;
            case HttpRequestMethod.HEAD -> HandleHead.class;
            case HttpRequestMethod.OPTIONS -> HandleOptions.class;
            case HttpRequestMethod.TRACE -> HandleTrace.class;
            case HttpRequestMethod.WS_OPEN -> HandleSocketOpen.class;
            case HttpRequestMethod.WS_MESSAGE -> HandleSocketMessage.class;
            case HttpRequestMethod.WS_CLOSE -> HandleSocketClose.class;
            case HttpRequestMethod.WS_PONG -> HandleSocketPong.class;
            case HttpRequestMethod.WS_HANDSHAKE -> HandleSocketHandshake.class;
        };
    }

    protected HandlerMatcher<Object, DeserializingMessage> createHandlerMatcher(Class<?> targetClass, HandlerConfiguration<DeserializingMessage> config) {
        return switch (this.messageType) {
            case MessageType.WEBREQUEST -> WebHandlerMatcher.create(targetClass, this.parameterResolvers, config);
            default -> HandlerInspector.inspect(targetClass, this.parameterResolvers, config);
        };
    }

    protected MessageFilter<? super DeserializingMessage> defaultMessageFilter() {
        MessageFilter<HasMessage> defaultFilter = new PayloadFilter().and(new SegmentFilter());
        return this.parameterResolvers.stream().flatMap(r -> r instanceof MessageFilter ? Stream.of((MessageFilter)((Object)r)) : Stream.empty()).reduce(MessageFilter::and).map(f -> f.and(defaultFilter)).orElse(defaultFilter);
    }

    @ConstructorProperties(value={"messageType", "defaultDecorator", "parameterResolvers", "messageFilter", "handlerAnnotation", "handlerRepositorySupplier"})
    @Generated
    public DefaultHandlerFactory(MessageType messageType, HandlerDecorator defaultDecorator, List<ParameterResolver<? super DeserializingMessage>> parameterResolvers, MessageFilter<? super DeserializingMessage> messageFilter, Class<? extends Annotation> handlerAnnotation, Function<Class<?>, HandlerRepository> handlerRepositorySupplier) {
        this.messageType = messageType;
        this.defaultDecorator = defaultDecorator;
        this.parameterResolvers = parameterResolvers;
        this.messageFilter = messageFilter;
        this.handlerAnnotation = handlerAnnotation;
        this.handlerRepositorySupplier = handlerRepositorySupplier;
    }
}

