/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.web;

import io.fluxcapacitor.javaclient.web.HttpRequestMethod;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public final class WebParameters {
    static final Pattern uriPattern = Pattern.compile("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?");
    private final String value;
    private final HttpRequestMethod method;
    private final boolean disabled;
    private final AtomicReference<Object> matcher = new AtomicReference();
    private final AtomicReference<Object> path = new AtomicReference();
    private final AtomicReference<Object> origin = new AtomicReference();

    static Matcher uriMatcher(String uriString) {
        Matcher result = uriPattern.matcher(Optional.ofNullable(uriString).orElse(""));
        if (result.matches()) {
            return result;
        }
        throw new IllegalStateException("Malformed URI: '" + uriString + "'");
    }

    @ConstructorProperties(value={"value", "method", "disabled"})
    @Generated
    public WebParameters(String value, HttpRequestMethod method, boolean disabled) {
        this.value = value;
        this.method = method;
        this.disabled = disabled;
    }

    @Generated
    public HttpRequestMethod getMethod() {
        return this.method;
    }

    @Generated
    public boolean isDisabled() {
        return this.disabled;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebParameters)) {
            return false;
        }
        WebParameters other = (WebParameters)o;
        if (this.isDisabled() != other.isDisabled()) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        HttpRequestMethod this$method = this.getMethod();
        HttpRequestMethod other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)((Object)this$method)).equals((Object)other$method)) {
            return false;
        }
        Matcher this$matcher = this.getMatcher();
        Matcher other$matcher = other.getMatcher();
        if (this$matcher == null ? other$matcher != null : !this$matcher.equals(other$matcher)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$origin = this.getOrigin();
        String other$origin = other.getOrigin();
        return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDisabled() ? 79 : 97);
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        HttpRequestMethod $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)((Object)$method)).hashCode());
        Matcher $matcher = this.getMatcher();
        result = result * 59 + ($matcher == null ? 43 : $matcher.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $origin = this.getOrigin();
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "WebParameters(value=" + this.getValue() + ", method=" + String.valueOf((Object)this.getMethod()) + ", disabled=" + this.isDisabled() + ", matcher=" + String.valueOf(this.getMatcher()) + ", path=" + this.getPath() + ", origin=" + this.getOrigin() + ")";
    }

    @Generated
    private String getValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    private Matcher getMatcher() {
        Object $value = this.matcher.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.matcher;
            synchronized (atomicReference) {
                $value = this.matcher.get();
                if ($value == null) {
                    Matcher actualValue = WebParameters.uriMatcher(this.getValue());
                    $value = actualValue == null ? this.matcher : actualValue;
                    this.matcher.set($value);
                }
            }
        }
        return (Matcher)($value == this.matcher ? null : $value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public String getPath() {
        Object $value = this.path.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.path;
            synchronized (atomicReference) {
                $value = this.path.get();
                if ($value == null) {
                    String actualValue = Optional.ofNullable(this.getMatcher().group(5)).map(p -> p.startsWith("/") ? p : (p.isBlank() ? "" : "/" + p)).orElse("");
                    $value = actualValue == null ? this.path : actualValue;
                    this.path.set($value);
                }
            }
        }
        return (String)($value == this.path ? null : $value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public String getOrigin() {
        Object $value = this.origin.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.origin;
            synchronized (atomicReference) {
                $value = this.origin.get();
                if ($value == null) {
                    String actualValue = Optional.ofNullable(this.getMatcher().group(1)).map(scheme -> scheme + this.getMatcher().group(3)).orElse(null);
                    $value = actualValue == null ? this.origin : actualValue;
                    this.origin.set($value);
                }
            }
        }
        return (String)($value == this.origin ? null : $value);
    }
}

