/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.web;

import io.fluxcapacitor.common.handling.ParameterResolver;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.common.HasMessage;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.User;
import io.fluxcapacitor.javaclient.tracking.handling.validation.ValidationUtils;
import io.fluxcapacitor.javaclient.web.HandleWeb;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import java.util.function.Function;
import lombok.Generated;

public class WebPayloadParameterResolver
implements ParameterResolver<HasMessage> {
    private final boolean validatePayload;
    private final boolean authoriseUser;

    @Override
    public Function<HasMessage, Object> resolve(Parameter p, Annotation methodAnnotation) {
        return m -> {
            Object payload = m.getPayloadAs(p.getType());
            if (this.validatePayload) {
                ValidationUtils.assertValid(payload, new Class[0]);
            }
            if (this.authoriseUser && payload != null) {
                ValidationUtils.assertAuthorized(payload.getClass(), User.getCurrent());
            }
            return payload;
        };
    }

    @Override
    public boolean matches(Parameter parameter, Annotation methodAnnotation, HasMessage value) {
        return ReflectionUtils.isOrHas(methodAnnotation, HandleWeb.class);
    }

    @ConstructorProperties(value={"validatePayload", "authoriseUser"})
    @Generated
    public WebPayloadParameterResolver(boolean validatePayload, boolean authoriseUser) {
        this.validatePayload = validatePayload;
        this.authoriseUser = authoriseUser;
    }
}

